/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hdds.scm.ha.SCMHADBTransactionBuffer;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.RDBBatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.ratis.statemachine.SnapshotInfo;

public class SCMHADBTransactionBufferStub
implements SCMHADBTransactionBuffer {
    private DBStore dbStore;
    private BatchOperation currentBatchOperation;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();

    public SCMHADBTransactionBufferStub() {
    }

    public SCMHADBTransactionBufferStub(DBStore store) {
        this.dbStore = store;
    }

    private BatchOperation getCurrentBatchOperation() {
        if (this.currentBatchOperation == null) {
            this.currentBatchOperation = this.dbStore != null ? this.dbStore.initBatchOperation() : new RDBBatchOperation();
        }
        return this.currentBatchOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <KEY, VALUE> void addToBuffer(Table<KEY, VALUE> table, KEY key, VALUE value) throws IOException {
        this.rwLock.readLock().lock();
        try {
            table.putWithBatch(this.getCurrentBatchOperation(), key, value);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public <KEY, VALUE> void removeFromBuffer(Table<KEY, VALUE> table, KEY key) throws IOException {
        this.rwLock.readLock().lock();
        try {
            table.deleteWithBatch(this.getCurrentBatchOperation(), key);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public void updateLatestTrxInfo(TransactionInfo info) {
    }

    @Override
    public TransactionInfo getLatestTrxInfo() {
        return null;
    }

    @Override
    public SnapshotInfo getLatestSnapshot() {
        return null;
    }

    @Override
    public void setLatestSnapshot(SnapshotInfo latestSnapshot) {
    }

    @Override
    public AtomicReference<SnapshotInfo> getLatestSnapshotRef() {
        return null;
    }

    @Override
    public void flush() throws IOException {
        this.rwLock.writeLock().lock();
        try {
            if (this.dbStore != null) {
                this.dbStore.commitBatchOperation(this.getCurrentBatchOperation());
            }
            if (this.currentBatchOperation != null) {
                this.currentBatchOperation.close();
                this.currentBatchOperation = null;
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public boolean shouldFlush(long snapshotWaitTime) {
        return true;
    }

    @Override
    public void init() throws IOException {
    }

    public void close() throws IOException {
        this.flush();
    }
}

