/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.ha.SCMService;
import org.apache.hadoop.hdds.scm.ha.SCMServiceManager;
import org.apache.hadoop.hdds.scm.node.NodeDecommissionManager;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewNodeHandler
implements EventHandler<DatanodeDetails> {
    private static final Logger LOG = LoggerFactory.getLogger(NewNodeHandler.class);
    private final PipelineManager pipelineManager;
    private final NodeDecommissionManager decommissionManager;
    private final SCMServiceManager serviceManager;

    public NewNodeHandler(PipelineManager pipelineManager, NodeDecommissionManager decommissionManager, SCMServiceManager serviceManager) {
        this.pipelineManager = pipelineManager;
        this.decommissionManager = decommissionManager;
        this.serviceManager = serviceManager;
    }

    public void onMessage(DatanodeDetails datanodeDetails, EventPublisher publisher) {
        try {
            this.pipelineManager.closeStalePipelines(datanodeDetails);
            this.serviceManager.notifyEventTriggered(SCMService.Event.NEW_NODE_HANDLER_TRIGGERED);
            if (datanodeDetails.getPersistedOpState() != HddsProtos.NodeOperationalState.IN_SERVICE) {
                this.decommissionManager.continueAdminForNode(datanodeDetails);
            }
        }
        catch (NodeNotFoundException e) {
            LOG.warn("NodeNotFound when adding the node to the decommissionManager", (Throwable)e);
        }
    }
}

