/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

@Metrics(about="Snapshot Internal Operation Metrics", context="ozone")
public class OmSnapshotInternalMetrics {
    public static final String METRICS_SOURCE_NAME = OmSnapshotInternalMetrics.class.getSimpleName();
    private MetricsRegistry registry = new MetricsRegistry(METRICS_SOURCE_NAME);
    @Metric(value={"Total no. of snapshots purged"})
    private MutableCounterLong numSnapshotPurges;
    @Metric(value={"Total no. of snapshot set properties"})
    private MutableCounterLong numSnapshotSetProperties;
    @Metric(value={"Total no. of move table keys requests"})
    private MutableCounterLong numSnapshotMoveTableKeys;
    @Metric(value={"Total no. of snapshot purge failures"})
    private MutableCounterLong numSnapshotPurgeFails;
    @Metric(value={"Total no. of snapshot set property failures"})
    private MutableCounterLong numSnapshotSetPropertyFails;
    @Metric(value={"Total no. of snapshot move table keys failures"})
    private MutableCounterLong numSnapshotMoveTableKeysFails;

    public static OmSnapshotInternalMetrics create() {
        return (OmSnapshotInternalMetrics)DefaultMetricsSystem.instance().register(METRICS_SOURCE_NAME, "Metrics tracking the progress of snapshot internal operations", (Object)new OmSnapshotInternalMetrics());
    }

    public static void unregister() {
        DefaultMetricsSystem.instance().unregisterSource(METRICS_SOURCE_NAME);
    }

    public void incNumSnapshotPurges() {
        this.numSnapshotPurges.incr();
    }

    public void incNumSnapshotSetProperties() {
        this.numSnapshotSetProperties.incr();
    }

    public void incNumSnapshotMoveTableKeys() {
        this.numSnapshotMoveTableKeys.incr();
    }

    public void incNumSnapshotPurgeFails() {
        this.numSnapshotPurgeFails.incr();
    }

    public void incNumSnapshotSetPropertyFails() {
        this.numSnapshotSetPropertyFails.incr();
    }

    public void incNumSnapshotMoveTableKeysFails() {
        this.numSnapshotMoveTableKeysFails.incr();
    }

    public long getNumSnapshotPurges() {
        return this.numSnapshotPurges.value();
    }

    public long getNumSnapshotSetProperties() {
        return this.numSnapshotSetProperties.value();
    }

    public long getNumSnapshotMoveTableKeys() {
        return this.numSnapshotMoveTableKeys.value();
    }

    public long getNumSnapshotPurgeFails() {
        return this.numSnapshotPurgeFails.value();
    }

    public long getNumSnapshotSetPropertyFails() {
        return this.numSnapshotSetPropertyFails.value();
    }

    public long getNumSnapshotMoveTableKeysFails() {
        return this.numSnapshotMoveTableKeysFails.value();
    }
}

