/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.multipart;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmFSOFile;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadCommitPartRequest;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3MultipartUploadCommitPartResponse;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3MultipartUploadCommitPartResponseWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class S3MultipartUploadCommitPartRequestWithFSO
extends S3MultipartUploadCommitPartRequest {
    public S3MultipartUploadCommitPartRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    @Override
    protected String getOpenKey(String volumeName, String bucketName, String keyName, OMMetadataManager omMetadataManager, long clientID) throws IOException {
        return new OmFSOFile.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setOmMetadataManager(omMetadataManager).build().getOpenFileName(clientID);
    }

    @Override
    protected OmKeyInfo getOmKeyInfo(OMMetadataManager omMetadataManager, String openKey, String keyName) throws IOException {
        return OMFileRequest.getOmKeyInfoFromFileTable(true, omMetadataManager, openKey, keyName);
    }

    @Override
    protected S3MultipartUploadCommitPartResponse getOmClientResponse(OzoneManager ozoneManager, Map<String, RepeatedOmKeyInfo> keyToDeleteMap, String openKey, OmKeyInfo omKeyInfo, String multipartKey, OmMultipartKeyInfo multipartKeyInfo, OzoneManagerProtocolProtos.OMResponse build, OmBucketInfo omBucketInfo, long bucketId) {
        return new S3MultipartUploadCommitPartResponseWithFSO(build, multipartKey, openKey, multipartKeyInfo, keyToDeleteMap, omKeyInfo, omBucketInfo, bucketId, this.getBucketLayout());
    }
}

