/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.snapshot;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditLoggerType;
import org.apache.hadoop.ozone.audit.OMSystemAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OmSnapshotInternalMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.snapshot.OMSnapshotSetPropertyResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMSnapshotSetPropertyRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMSnapshotSetPropertyRequest.class);
    private static final AuditLogger AUDIT = new AuditLogger(AuditLoggerType.OMSYSTEMLOGGER);
    private static final String AUDIT_PARAM_SNAPSHOT_DB_KEY = "snapshotDBKey";
    private static final String AUDIT_PARAM_SNAPSHOT_EXCLUSIVE_SIZE = "snapshotExclusiveSize";
    private static final String AUDIT_PARAM_SNAPSHOT_EXCLUSIVE_REPL_SIZE = "snapshotExclusiveReplicatedSize";
    private static final String AUDIT_PARAM_DEEP_CLEAN_DEL_DIR = "deepCleanDeletedDir";
    private static final String AUDIT_PARAM_DEEP_CLEAN_DEL_KEY = "deepCleanDeletedKey";
    private static final String AUDIT_PARAM_EXCLUSIVE_SIZE_DELTA_FROM_DIR_DEEP_CLEAN = "exclusiveSizeDeltaFromDirDeepCleaning";
    private static final String AUDIT_PARAM_EXCLUSIVE_REPL_SIZE_DELTA_FROM_DIR_DEEP_CLEAN = "exclusiveReplicatedSizeDeltaFromDirDeepCleaning";

    public OMSnapshotSetPropertyRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    private void updateSnapshotProperty(SnapshotInfo snapInfo, OzoneManagerProtocolProtos.SetSnapshotPropertyRequest setSnapshotPropertyRequest, Map<String, String> auditParams) {
        OzoneManagerProtocolProtos.SnapshotSize snapshotSize;
        if (setSnapshotPropertyRequest.hasDeepCleanedDeletedDir()) {
            snapInfo.setDeepCleanedDeletedDir(setSnapshotPropertyRequest.getDeepCleanedDeletedDir());
            auditParams.put(AUDIT_PARAM_DEEP_CLEAN_DEL_DIR, String.valueOf(setSnapshotPropertyRequest.getDeepCleanedDeletedDir()));
        }
        if (setSnapshotPropertyRequest.hasDeepCleanedDeletedKey()) {
            snapInfo.setDeepClean(setSnapshotPropertyRequest.getDeepCleanedDeletedKey());
            auditParams.put(AUDIT_PARAM_DEEP_CLEAN_DEL_KEY, String.valueOf(setSnapshotPropertyRequest.getDeepCleanedDeletedKey()));
        }
        if (setSnapshotPropertyRequest.hasSnapshotSize()) {
            snapshotSize = setSnapshotPropertyRequest.getSnapshotSize();
            snapInfo.setExclusiveSize(snapshotSize.getExclusiveSize());
            snapInfo.setExclusiveReplicatedSize(snapshotSize.getExclusiveReplicatedSize());
            auditParams.put(AUDIT_PARAM_SNAPSHOT_EXCLUSIVE_SIZE, String.valueOf(snapshotSize.getExclusiveSize()));
            auditParams.put(AUDIT_PARAM_SNAPSHOT_EXCLUSIVE_REPL_SIZE, String.valueOf(snapshotSize.getExclusiveReplicatedSize()));
        }
        if (setSnapshotPropertyRequest.hasSnapshotSizeDeltaFromDirDeepCleaning()) {
            snapshotSize = setSnapshotPropertyRequest.getSnapshotSizeDeltaFromDirDeepCleaning();
            snapInfo.setExclusiveSizeDeltaFromDirDeepCleaning(snapshotSize.getExclusiveSize());
            snapInfo.setExclusiveReplicatedSizeDeltaFromDirDeepCleaning(snapshotSize.getExclusiveReplicatedSize());
            auditParams.put(AUDIT_PARAM_EXCLUSIVE_SIZE_DELTA_FROM_DIR_DEEP_CLEAN, String.valueOf(snapshotSize.getExclusiveSize()));
            auditParams.put(AUDIT_PARAM_EXCLUSIVE_REPL_SIZE_DELTA_FROM_DIR_DEEP_CLEAN, String.valueOf(snapshotSize.getExclusiveReplicatedSize()));
        }
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OMSnapshotSetPropertyResponse omClientResponse;
        OmSnapshotInternalMetrics omSnapshotIntMetrics = ozoneManager.getOmSnapshotIntMetrics();
        OMMetadataManager metadataManager = ozoneManager.getMetadataManager();
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        ArrayList setSnapshotPropertyRequests = Lists.newArrayList();
        if (this.getOmRequest().hasSetSnapshotPropertyRequest()) {
            setSnapshotPropertyRequests.add(this.getOmRequest().getSetSnapshotPropertyRequest());
        }
        setSnapshotPropertyRequests.addAll(this.getOmRequest().getSetSnapshotPropertyRequestsList());
        HashSet<String> snapshotKeys = new HashSet<String>();
        HashMap<String, SnapshotInfo> snapshotInfoMap = new HashMap<String, SnapshotInfo>();
        HashMap<String, LinkedHashMap<String, String>> auditParamsMap = new HashMap<String, LinkedHashMap<String, String>>();
        try {
            for (OzoneManagerProtocolProtos.SetSnapshotPropertyRequest setSnapshotPropertyRequest : setSnapshotPropertyRequests) {
                String snapshotKey = setSnapshotPropertyRequest.getSnapshotKey();
                if (snapshotKeys.contains(snapshotKey)) {
                    OMException e = new OMException("Snapshot with snapshot key: " + snapshotKey + " added multiple times in the request. Request: " + setSnapshotPropertyRequests, OMException.ResultCodes.INVALID_REQUEST);
                    AUDIT.logWriteFailure(ozoneManager.buildAuditMessageForFailure(OMSystemAction.SNAPSHOT_SET_PROPERTY, null, e));
                    throw e;
                }
                snapshotKeys.add(snapshotKey);
                SnapshotInfo updatedSnapInfo = snapshotInfoMap.computeIfAbsent(snapshotKey, k -> {
                    try {
                        return (SnapshotInfo)metadataManager.getSnapshotInfoTable().get(k);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Exception while getting key " + k, e);
                    }
                });
                if (updatedSnapInfo == null) {
                    LOG.error("Snapshot: '{}' does not exist in snapshot table.", (Object)snapshotKey);
                    OMException e = new OMException("Snapshot: '{}' does not exist in snapshot table." + snapshotKey + "Request: " + setSnapshotPropertyRequests, OMException.ResultCodes.FILE_NOT_FOUND);
                    AUDIT.logWriteFailure(ozoneManager.buildAuditMessageForFailure(OMSystemAction.SNAPSHOT_SET_PROPERTY, null, e));
                    throw e;
                }
                LinkedHashMap<String, String> auditParams = new LinkedHashMap<String, String>();
                auditParams.put(AUDIT_PARAM_SNAPSHOT_DB_KEY, snapshotKey);
                this.updateSnapshotProperty(updatedSnapInfo, setSnapshotPropertyRequest, auditParams);
                auditParamsMap.put(snapshotKey, auditParams);
            }
            if (snapshotInfoMap.isEmpty()) {
                OMException oMException = new OMException("Snapshots: " + snapshotKeys + " don't not exist in snapshot table.", OMException.ResultCodes.FILE_NOT_FOUND);
                AUDIT.logWriteFailure(ozoneManager.buildAuditMessageForFailure(OMSystemAction.SNAPSHOT_SET_PROPERTY, null, oMException));
                throw oMException;
            }
            for (Map.Entry entry : snapshotInfoMap.entrySet()) {
                metadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)((String)entry.getKey())), CacheValue.get((long)context.getIndex(), (Object)((SnapshotInfo)entry.getValue())));
                omSnapshotIntMetrics.incNumSnapshotSetProperties();
                AUDIT.logWriteSuccess(ozoneManager.buildAuditMessageForSuccess(OMSystemAction.SNAPSHOT_SET_PROPERTY, (Map)auditParamsMap.get(entry.getKey())));
            }
            omClientResponse = new OMSnapshotSetPropertyResponse(omResponse.build(), snapshotInfoMap.values());
            LOG.info("Successfully executed snapshotSetPropertyRequest: {{}}.", (Object)setSnapshotPropertyRequests);
        }
        catch (IOException | UncheckedIOException exception) {
            omClientResponse = new OMSnapshotSetPropertyResponse(this.createErrorOMResponse(omResponse, exception));
            omSnapshotIntMetrics.incNumSnapshotSetPropertyFails();
            LOG.error("Failed to execute snapshotSetPropertyRequest: {{}}.", (Object)setSnapshotPropertyRequests, (Object)exception);
            AUDIT.logWriteFailure(ozoneManager.buildAuditMessageForFailure(OMSystemAction.SNAPSHOT_SET_PROPERTY, null, exception));
        }
        return omClientResponse;
    }
}

