/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.volume;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"volumeTable", "bucketTable"})
public class OMQuotaRepairResponse
extends OMClientResponse {
    private Map<String, OmVolumeArgs> volumeArgsMap;
    private Map<Pair<String, String>, OmBucketInfo> volBucketInfoMap;

    public OMQuotaRepairResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
    }

    public OMQuotaRepairResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, Map<String, OmVolumeArgs> volumeArgsMap, Map<Pair<String, String>, OmBucketInfo> volBucketInfoMap) {
        super(omResponse);
        this.volBucketInfoMap = volBucketInfoMap;
        this.volumeArgsMap = volumeArgsMap;
    }

    @Override
    public void addToDBBatch(OMMetadataManager metadataManager, BatchOperation batchOp) throws IOException {
        for (OmBucketInfo omBucketInfo : this.volBucketInfoMap.values()) {
            metadataManager.getBucketTable().putWithBatch(batchOp, (Object)metadataManager.getBucketKey(omBucketInfo.getVolumeName(), omBucketInfo.getBucketName()), (Object)omBucketInfo);
        }
        for (OmVolumeArgs volArgs : this.volumeArgsMap.values()) {
            metadataManager.getVolumeTable().putWithBatch(batchOp, (Object)volArgs.getVolume(), (Object)volArgs);
        }
    }
}

