/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.OMNodeDetails;
import org.apache.hadoop.ozone.om.protocolPB.OMInterServiceProtocolPB;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerRatisServer;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerRatisUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerInterServiceProtocolProtos;

public class OMInterServiceProtocolServerSideImpl
implements OMInterServiceProtocolPB {
    private final OzoneManagerRatisServer omRatisServer;
    private final OzoneManager ozoneManager;

    public OMInterServiceProtocolServerSideImpl(OzoneManager ozoneMgr, OzoneManagerRatisServer ratisServer) {
        this.ozoneManager = ozoneMgr;
        this.omRatisServer = ratisServer;
    }

    public OzoneManagerInterServiceProtocolProtos.BootstrapOMResponse bootstrap(RpcController controller, OzoneManagerInterServiceProtocolProtos.BootstrapOMRequest request) throws ServiceException {
        if (request == null) {
            return null;
        }
        OzoneManagerRatisUtils.checkLeaderStatus(this.ozoneManager);
        OMNodeDetails newOmNode = new OMNodeDetails.Builder().setOMNodeId(request.getNodeId()).setHostAddress(request.getHostAddress()).setRatisPort(request.getRatisPort()).setIsListener(request.getIsListener()).build();
        try {
            this.omRatisServer.addOMToRatisRing(newOmNode);
        }
        catch (IOException ex) {
            return OzoneManagerInterServiceProtocolProtos.BootstrapOMResponse.newBuilder().setSuccess(false).setErrorCode(OzoneManagerInterServiceProtocolProtos.ErrorCode.RATIS_BOOTSTRAP_ERROR).setErrorMsg(ex.getMessage()).build();
        }
        return OzoneManagerInterServiceProtocolProtos.BootstrapOMResponse.newBuilder().setSuccess(true).build();
    }
}

