/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.symmetric;

import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.SecretKeyProtocol;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.symmetric.DefaultSecretKeySignerClient;
import org.apache.hadoop.hdds.security.symmetric.DefaultSecretKeyVerifierClient;
import org.apache.hadoop.hdds.security.symmetric.ManagedSecretKey;
import org.apache.hadoop.hdds.security.symmetric.SecretKeyClient;
import org.apache.hadoop.hdds.security.symmetric.SecretKeySignerClient;
import org.apache.hadoop.hdds.security.symmetric.SecretKeyVerifierClient;

public class DefaultSecretKeyClient
implements SecretKeyClient {
    private final SecretKeySignerClient signerClientDelegate;
    private final SecretKeyVerifierClient verifierClientDelegate;

    DefaultSecretKeyClient(SecretKeySignerClient signerClientDelegate, SecretKeyVerifierClient verifierClientDelegate) {
        this.signerClientDelegate = signerClientDelegate;
        this.verifierClientDelegate = verifierClientDelegate;
    }

    @Override
    public ManagedSecretKey getCurrentSecretKey() {
        return this.signerClientDelegate.getCurrentSecretKey();
    }

    @Override
    public void start(ConfigurationSource conf) throws IOException {
        this.signerClientDelegate.start(conf);
    }

    @Override
    public void stop() {
        this.signerClientDelegate.stop();
    }

    @Override
    public ManagedSecretKey getSecretKey(UUID id) throws SCMSecurityException {
        return this.verifierClientDelegate.getSecretKey(id);
    }

    public static SecretKeyClient create(ConfigurationSource conf, SecretKeyProtocol secretKeyProtocol, String threadNamePrefix) throws IOException {
        DefaultSecretKeySignerClient singerClient = new DefaultSecretKeySignerClient(secretKeyProtocol, threadNamePrefix);
        DefaultSecretKeyVerifierClient verifierClient = new DefaultSecretKeyVerifierClient(secretKeyProtocol, conf);
        return new DefaultSecretKeyClient(singerClient, verifierClient);
    }
}

