/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server.http;

import com.codahale.metrics.MetricRegistry;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.dropwizard.samplebuilder.SampleBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.apache.hadoop.hdds.server.http.RatisNameRewriteSampleBuilder;
import org.apache.ratis.metrics.MetricRegistries;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.dropwizard3.RatisMetricsUtils;

public class RatisDropwizardExports
extends DropwizardExports {
    public RatisDropwizardExports(MetricRegistry registry) {
        super(registry, (SampleBuilder)new RatisNameRewriteSampleBuilder());
    }

    public static List<MetricReporter> registerRatisMetricReporters(Map<String, RatisDropwizardExports> ratisMetricsMap, BooleanSupplier checkStopped) {
        ArrayList<MetricReporter> ratisReporterList = new ArrayList<MetricReporter>();
        ratisReporterList.add(new MetricReporter(RatisMetricsUtils.jmxReporter(), RatisMetricsUtils.stopJmxReporter()));
        Consumer<RatisMetricRegistry> reporter = r1 -> RatisDropwizardExports.registerDropwizard(r1, ratisMetricsMap, checkStopped);
        Consumer<RatisMetricRegistry> stopper = r2 -> RatisDropwizardExports.deregisterDropwizard(r2, ratisMetricsMap);
        ratisReporterList.add(new MetricReporter(reporter, stopper));
        for (MetricReporter metricReporter : ratisReporterList) {
            metricReporter.addToGlobalRegistration();
        }
        return ratisReporterList;
    }

    public static void clear(Map<String, RatisDropwizardExports> ratisMetricsMap, List<MetricReporter> ratisReporterList) {
        ratisMetricsMap.entrySet().stream().forEach(e -> {
            Collector c = (Collector)ratisMetricsMap.remove(e.getKey());
            if (c != null) {
                CollectorRegistry.defaultRegistry.unregister(c);
            }
        });
        if (null != ratisReporterList) {
            for (MetricReporter metricReporter : ratisReporterList) {
                metricReporter.removeFromGlobalRegistration();
            }
        }
        MetricRegistries.global().clear();
    }

    static String getName(MetricRegistryInfo info) {
        return MetricRegistry.name((String)info.getApplicationName(), (String[])new String[]{info.getMetricsComponentName(), info.getPrefix()});
    }

    private static void registerDropwizard(RatisMetricRegistry registry, Map<String, RatisDropwizardExports> ratisMetricsMap, BooleanSupplier checkStopped) {
        if (checkStopped.getAsBoolean()) {
            return;
        }
        RatisDropwizardExports rde = new RatisDropwizardExports(RatisMetricsUtils.getDropWizardMetricRegistry(registry));
        String name = RatisDropwizardExports.getName(registry.getMetricRegistryInfo());
        if (null == ratisMetricsMap.putIfAbsent(name, rde)) {
            CollectorRegistry.defaultRegistry.register((Collector)rde);
        }
    }

    private static void deregisterDropwizard(RatisMetricRegistry registry, Map<String, RatisDropwizardExports> ratisMetricsMap) {
        String name = RatisDropwizardExports.getName(registry.getMetricRegistryInfo());
        Collector c = (Collector)ratisMetricsMap.remove(name);
        if (c != null) {
            CollectorRegistry.defaultRegistry.unregister(c);
        }
    }

    public static class MetricReporter {
        private final Consumer<RatisMetricRegistry> reporter;
        private final Consumer<RatisMetricRegistry> stopper;

        MetricReporter(Consumer<RatisMetricRegistry> reporter, Consumer<RatisMetricRegistry> stopper) {
            this.reporter = reporter;
            this.stopper = stopper;
        }

        void addToGlobalRegistration() {
            MetricRegistries.global().addReporterRegistration(this.reporter, this.stopper);
        }

        void removeFromGlobalRegistration() {
            MetricRegistries.global().removeReporterRegistration(this.reporter, this.stopper);
        }
    }
}

