/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.util.EnumSet;
import java.util.Set;
import jnr.constants.platform.Signal;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import jnr.posix.SignalHandler;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.slf4j.Logger;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public enum SignalLogger {
    INSTANCE;

    private static final Set<Signal> SIGNALS;
    private static final POSIX POSIX_IMPL;
    private static final SignalHandler DEFAULT_HANDLER;
    private boolean registered = false;

    public void register(Logger log) {
        if (this.registered) {
            throw new IllegalStateException("Can't re-install the signal handlers.");
        }
        this.registered = true;
        StringBuilder bld = new StringBuilder();
        bld.append("registered UNIX signal handlers for [");
        String separator = "";
        for (Signal signal : SIGNALS) {
            try {
                new Handler(signal, log);
                bld.append(separator).append(signal.name());
                separator = ", ";
            }
            catch (Exception e) {
                log.info("Error installing UNIX signal handler for {}", (Object)signal, (Object)e);
            }
        }
        bld.append(']');
        if (log.isInfoEnabled()) {
            log.info(bld.toString());
        }
    }

    static {
        SIGNALS = EnumSet.of(Signal.SIGHUP, Signal.SIGINT, Signal.SIGTERM);
        POSIX_IMPL = POSIXFactory.getJavaPOSIX();
        DEFAULT_HANDLER = System::exit;
    }

    private static class Handler
    implements SignalHandler {
        private final Logger log;
        private final SignalHandler prevHandler;

        Handler(Signal signal, Logger log) {
            this.log = log;
            SignalHandler handler = POSIX_IMPL.signal(signal, (SignalHandler)this);
            this.prevHandler = handler != null ? handler : DEFAULT_HANDLER;
        }

        public void handle(int signal) {
            this.log.error("RECEIVED SIGNAL {}: {}", (Object)signal, (Object)Signal.valueOf((long)signal));
            this.prevHandler.handle(signal);
        }
    }
}

