/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.hadoop.ozone.s3.util.S3Utils;

public class UnsignedChunksInputStream
extends InputStream {
    private final InputStream originalStream;
    private int remainingData = 0;
    private boolean isFinalChunkEncountered = false;

    public UnsignedChunksInputStream(InputStream inputStream) {
        this.originalStream = inputStream;
    }

    @Override
    public int read() throws IOException {
        if (this.isFinalChunkEncountered) {
            return -1;
        }
        if (this.remainingData > 0) {
            int curr = this.originalStream.read();
            --this.remainingData;
            if (this.remainingData == 0) {
                this.originalStream.read();
                this.originalStream.read();
            }
            return curr;
        }
        this.remainingData = this.readContentLengthFromHeader();
        if (this.remainingData <= 0) {
            this.isFinalChunkEncountered = true;
            return -1;
        }
        return this.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Objects.requireNonNull(b, "b == null");
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException("Offset=" + off + " and len=" + len + " don't match the array length of " + b.length);
        }
        if (len == 0) {
            return 0;
        }
        if (this.isFinalChunkEncountered) {
            return -1;
        }
        int currentOff = off;
        int currentLen = len;
        int totalReadBytes = 0;
        int realReadLen = 0;
        int maxReadLen = 0;
        do {
            if (this.remainingData > 0) {
                maxReadLen = Math.min(this.remainingData, currentLen);
                realReadLen = this.originalStream.read(b, currentOff, maxReadLen);
                if (realReadLen == -1) break;
                currentOff += realReadLen;
                currentLen -= realReadLen;
                totalReadBytes += realReadLen;
                this.remainingData -= realReadLen;
                if (this.remainingData != 0) continue;
                this.originalStream.read();
                this.originalStream.read();
                continue;
            }
            this.remainingData = this.readContentLengthFromHeader();
            if (this.remainingData == 0) {
                this.isFinalChunkEncountered = true;
            }
            if (this.isFinalChunkEncountered || this.remainingData == -1) break;
        } while (currentLen > 0);
        return totalReadBytes > 0 ? totalReadBytes : -1;
    }

    private int readContentLengthFromHeader() throws IOException {
        int prev = -1;
        int curr = 0;
        StringBuilder buf = new StringBuilder();
        while (!S3Utils.eol(prev, curr) && curr != -1) {
            int next = this.originalStream.read();
            if (next != -1) {
                buf.append((char)next);
            }
            prev = curr;
            curr = next;
        }
        String readString = buf.toString().trim();
        if (readString.isEmpty()) {
            return -1;
        }
        return Integer.parseInt(readString, 16);
    }
}

