/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.ldb;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.AbstractSubcommand;
import org.apache.hadoop.hdds.utils.db.managed.ManagedCheckpoint;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksDB;
import org.apache.hadoop.ozone.debug.RocksDBUtils;
import org.apache.hadoop.ozone.debug.ldb.RDBParser;
import org.rocksdb.ColumnFamilyDescriptor;
import picocli.CommandLine;

@CommandLine.Command(name="checkpoint", description={"Create checkpoint for specified db"})
public class Checkpoint
extends AbstractSubcommand
implements Callable<Void> {
    @CommandLine.Option(names={"--output"}, required=true, description={"Path to output directory for the checkpoint."})
    private String outputPath;
    @CommandLine.ParentCommand
    private RDBParser parent;

    @Override
    public Void call() throws Exception {
        List<ColumnFamilyDescriptor> cfDescList = RocksDBUtils.getColumnFamilyDescriptors(this.parent.getDbPath());
        ArrayList cfHandleList = new ArrayList();
        try (ManagedRocksDB db = ManagedRocksDB.openReadOnly((String)this.parent.getDbPath(), cfDescList, cfHandleList);){
            ManagedCheckpoint cp = ManagedCheckpoint.create((ManagedRocksDB)db);
            ((org.rocksdb.Checkpoint)cp.get()).createCheckpoint(this.outputPath);
            this.out().println("Created checkpoint at " + this.outputPath);
        }
        return null;
    }
}

