/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.replicas;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.cli.ContainerOperationClient;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.hadoop.ozone.debug.replicas.BlockVerificationResult;
import org.apache.hadoop.ozone.debug.replicas.ReplicaVerifier;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.security.token.Token;

public class BlockExistenceVerifier
implements ReplicaVerifier {
    private final ContainerOperationClient containerClient;
    private final XceiverClientManager xceiverClientManager;
    private static final String CHECK_TYPE = "blockExistence";

    @Override
    public String getType() {
        return CHECK_TYPE;
    }

    public BlockExistenceVerifier(OzoneConfiguration conf) throws IOException {
        this.containerClient = new ContainerOperationClient(conf);
        this.xceiverClientManager = this.containerClient.getXceiverClientManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockVerificationResult verifyBlock(DatanodeDetails datanode, OmKeyLocationInfo keyLocation) {
        BlockVerificationResult blockVerificationResult;
        XceiverClientSpi client;
        block5: {
            boolean hasBlock;
            client = null;
            Pipeline pipeline = keyLocation.getPipeline().copyForReadFromNode(datanode);
            client = this.xceiverClientManager.acquireClientForReadData(pipeline);
            ContainerProtos.GetBlockResponseProto response = ContainerProtocolCalls.getBlock((XceiverClientSpi)client, (BlockID)keyLocation.getBlockID(), (Token)keyLocation.getToken(), (Map)pipeline.getReplicaIndexes());
            boolean bl = hasBlock = response != null && response.hasBlockData();
            if (!hasBlock) break block5;
            BlockVerificationResult blockVerificationResult2 = BlockVerificationResult.pass();
            this.xceiverClientManager.releaseClient(client, false);
            return blockVerificationResult2;
        }
        try {
            blockVerificationResult = BlockVerificationResult.failCheck("Block does not exist on this replica");
        }
        catch (IOException e) {
            BlockVerificationResult blockVerificationResult3;
            try {
                blockVerificationResult3 = BlockVerificationResult.failIncomplete(e.getMessage());
            }
            catch (Throwable throwable) {
                this.xceiverClientManager.releaseClient(client, false);
                throw throwable;
            }
            this.xceiverClientManager.releaseClient(client, false);
            return blockVerificationResult3;
        }
        this.xceiverClientManager.releaseClient(client, false);
        return blockVerificationResult;
    }
}

