/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon.containergenerator;

import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import picocli.CommandLine;

public abstract class BaseGenerator
extends BaseFreonGenerator
implements Callable<Void> {
    @CommandLine.Option(names={"-u", "--user"}, description={"Owner of the files"}, defaultValue="ozone")
    private static String userId;
    @CommandLine.Option(names={"--key-size"}, description={"Size of the generated keys (in bytes) in each of the containers"}, defaultValue="16000000")
    private int keySize;
    @CommandLine.Option(names={"--size"}, description={"Size of generated containers (default is defined by ozone.scm.container.size)"})
    private long containerSize;
    @CommandLine.Option(names={"--from"}, description={"First container index to use"}, defaultValue="1")
    private long containerIdOffset;

    public static String getUserId() {
        return userId;
    }

    public int getKeysPerContainer(ConfigurationSource conf) {
        return (int)(this.getContainerSize(conf) / (long)this.getKeySize());
    }

    public long getContainerIdOffset() {
        return this.containerIdOffset;
    }

    public long getContainerSize(ConfigurationSource conf) {
        if (this.containerSize == 0L) {
            Double defaultContainerSize = conf.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.BYTES);
            return defaultContainerSize.longValue();
        }
        return this.containerSize;
    }

    public int getKeySize() {
        return this.keySize;
    }
}

