/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.EnumSet;
import java.util.List;
import java.util.function.BiFunction;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.CreateViewAsStep;
import org.jooq.CreateViewFinalStep;
import org.jooq.Field;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.conf.ParamType;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.Tools;

final class CreateViewImpl<R extends Record>
extends AbstractQuery
implements CreateViewAsStep<R>,
CreateViewFinalStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.CREATE_VIEW};
    private static final EnumSet<SQLDialect> NO_SUPPORT_IF_NOT_EXISTS = EnumSet.of(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.POSTGRES);
    private final boolean ifNotExists;
    private final boolean orReplace;
    private final Table<?> view;
    private final BiFunction<? super Field<?>, ? super Integer, ? extends Field<?>> fieldNameFunction;
    private Field<?>[] fields;
    private Select<?> select;

    CreateViewImpl(Configuration configuration, Table<?> view, Field<?>[] fields, boolean ifNotExists, boolean orReplace) {
        super(configuration);
        this.view = view;
        this.fields = fields;
        this.fieldNameFunction = null;
        this.ifNotExists = ifNotExists;
        this.orReplace = orReplace;
    }

    CreateViewImpl(Configuration configuration, Table<?> view, BiFunction<? super Field<?>, ? super Integer, ? extends Field<?>> fieldNameFunction, boolean ifNotExists, boolean orReplace) {
        super(configuration);
        this.view = view;
        this.fields = null;
        this.fieldNameFunction = fieldNameFunction;
        this.ifNotExists = ifNotExists;
        this.orReplace = orReplace;
    }

    @Override
    public final CreateViewFinalStep as(Select<? extends R> s) {
        this.select = s;
        if (this.fieldNameFunction != null) {
            List<Field<?>> source = s.getSelect();
            this.fields = new Field[source.size()];
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = this.fieldNameFunction.apply(source.get(i), i);
            }
        }
        return this;
    }

    private final boolean supportsIfNotExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_NOT_EXISTS.contains((Object)ctx.family());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifNotExists && !this.supportsIfNotExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.CREATE_VIEW);
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.CREATE_VIEW);
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        boolean rename = this.fields != null && this.fields.length > 0;
        boolean renameSupported = ctx.family() != SQLDialect.SQLITE;
        boolean replaceSupported = false;
        ParamType paramType = ctx.paramType();
        ctx.start(Clause.CREATE_VIEW_NAME).visit(replaceSupported && this.orReplace ? Keywords.K_REPLACE : Keywords.K_CREATE);
        if (this.orReplace && !replaceSupported) {
            ctx.sql(' ').visit(Keywords.K_OR);
            switch (ctx.family()) {
                default: 
            }
            ctx.sql(' ').visit(Keywords.K_REPLACE);
        }
        ctx.sql(' ').visit(Keywords.K_VIEW).sql(' ');
        if (this.ifNotExists && this.supportsIfNotExists(ctx)) {
            ctx.visit(Keywords.K_IF_NOT_EXISTS).sql(' ');
        }
        ctx.visit(this.view);
        if (rename && renameSupported) {
            boolean qualify = ctx.qualify();
            ctx.sql('(').qualify(false).visit(new QueryPartList((QueryPart[])this.fields)).qualify(qualify).sql(')');
        }
        ctx.end(Clause.CREATE_VIEW_NAME).formatSeparator().visit(Keywords.K_AS).formatSeparator().start(Clause.CREATE_VIEW_AS).paramType(ParamType.INLINED).visit(rename && !renameSupported ? DSL.selectFrom(DSL.table(this.select).as(DSL.name("t"), Tools.fieldNames(this.fields))) : this.select).paramType(paramType).end(Clause.CREATE_VIEW_AS);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

