/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.tenant;

import java.io.IOException;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.tenant.TenantHandler;
import picocli.CommandLine;

@CommandLine.Command(name="set-secret", aliases={"setsecret"}, description={"Set secret for a tenant user accessId."})
public class TenantSetSecretHandler
extends TenantHandler {
    @CommandLine.Parameters(description={"AccessId"}, arity="1")
    private String accessId;
    @CommandLine.Option(names={"-s", "--secret"}, description={"Secret key"}, required=true)
    private String secretKey;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        S3SecretValue accessIdSecretKeyPair = client.getObjectStore().setS3Secret(this.accessId, this.secretKey);
        this.out().println("export AWS_ACCESS_KEY_ID='" + accessIdSecretKeyPair.getAwsAccessKey() + "'");
        this.out().println("export AWS_SECRET_ACCESS_KEY='" + accessIdSecretKeyPair.getAwsSecret() + "'");
    }
}

