/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import picocli.CommandLine;

@CommandLine.Command(name="status", description={"Check if SCM is in safe mode"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class SafeModeCheckSubcommand
extends ScmSubcommand {
    @Override
    public void execute(ScmClient scmClient) throws IOException {
        boolean execReturn = scmClient.inSafeMode();
        if (execReturn) {
            System.out.println("SCM is in safe mode.");
        } else {
            System.out.println("SCM is out of safe mode.");
        }
        if (this.isVerbose()) {
            for (Map.Entry entry : scmClient.getSafeModeRuleStatuses().entrySet()) {
                Pair value = (Pair)entry.getValue();
                System.out.printf("validated:%s, %s, %s%n", value.getLeft(), entry.getKey(), value.getRight());
            }
        }
    }
}

