/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.container;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hdds.cli.ItemsFromStdin;
import picocli.CommandLine;

@CommandLine.Command
public class ContainerIDParameters
extends ItemsFromStdin {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    @CommandLine.Parameters(description={"Container IDs: one or more, separated by spaces. To read from stdin, specify '-' and supply one item per line."}, arity="1..*", paramLabel="<container ID>")
    public void setContainerIDs(List<String> arguments) {
        this.setItems(arguments);
    }

    public List<Long> getValidatedIDs() {
        ArrayList<Long> containerIDs = new ArrayList<Long>(this.size());
        ArrayList<String> invalidIDs = new ArrayList<String>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            String input = (String)iterator.next();
            boolean idValid = true;
            try {
                long id = Long.parseLong(input);
                if (id <= 0L) {
                    idValid = false;
                } else {
                    containerIDs.add(id);
                }
            }
            catch (NumberFormatException e) {
                idValid = false;
            }
            if (idValid) continue;
            invalidIDs.add(input);
        }
        if (!invalidIDs.isEmpty()) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Container IDs must be positive integers. Invalid container IDs: " + String.join((CharSequence)" ", invalidIDs));
        }
        return containerIDs;
    }
}

