/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.spi.ReconFileMetadataManager;
import org.apache.hadoop.ozone.recon.tasks.FileSizeCountKey;
import org.apache.ozone.recon.schema.UtilizationSchemaDefinition;
import org.apache.ozone.recon.schema.generated.tables.ContainerCountBySizeTable;
import org.apache.ozone.recon.schema.generated.tables.daos.ContainerCountBySizeDao;
import org.apache.ozone.recon.schema.generated.tables.pojos.ContainerCountBySize;
import org.apache.ozone.recon.schema.generated.tables.pojos.FileCountBySize;
import org.jooq.DSLContext;
import org.jooq.Record1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/utilization")
@Produces(value={"application/json"})
public class UtilizationEndpoint {
    private UtilizationSchemaDefinition utilizationSchemaDefinition;
    private ContainerCountBySizeDao containerCountBySizeDao;
    private ReconFileMetadataManager reconFileMetadataManager;
    private static final Logger LOG = LoggerFactory.getLogger(UtilizationEndpoint.class);

    @Inject
    public UtilizationEndpoint(ContainerCountBySizeDao containerCountBySizeDao, UtilizationSchemaDefinition utilizationSchemaDefinition, ReconFileMetadataManager reconFileMetadataManager) {
        this.utilizationSchemaDefinition = utilizationSchemaDefinition;
        this.containerCountBySizeDao = containerCountBySizeDao;
        this.reconFileMetadataManager = reconFileMetadataManager;
    }

    @GET
    @Path(value="/fileCount")
    public Response getFileCounts(@QueryParam(value="volume") String volume, @QueryParam(value="bucket") String bucket, @QueryParam(value="fileSize") long fileSize) {
        ArrayList<FileCountBySize> resultSet = new ArrayList<FileCountBySize>();
        try {
            Table<FileSizeCountKey, Long> fileCountTable = this.reconFileMetadataManager.getFileCountTable();
            if (volume != null && bucket != null && fileSize > 0L) {
                FileSizeCountKey key = new FileSizeCountKey(volume, bucket, fileSize);
                Long count = (Long)fileCountTable.get((Object)key);
                if (count != null && count > 0L) {
                    FileCountBySize record = new FileCountBySize();
                    record.setVolume(volume);
                    record.setBucket(bucket);
                    record.setFileSize(fileSize);
                    record.setCount(count);
                    resultSet.add(record);
                }
            } else {
                try (Table.KeyValueIterator iterator = fileCountTable.iterator();){
                    while (iterator.hasNext()) {
                        Table.KeyValue entry = (Table.KeyValue)iterator.next();
                        FileSizeCountKey key = (FileSizeCountKey)entry.getKey();
                        Long count = (Long)entry.getValue();
                        boolean matches = true;
                        if (volume != null && !volume.equals(key.getVolume())) {
                            matches = false;
                        }
                        if (bucket != null && !bucket.equals(key.getBucket())) {
                            matches = false;
                        }
                        if (!matches || count == null || count <= 0L) continue;
                        FileCountBySize record = new FileCountBySize();
                        record.setVolume(key.getVolume());
                        record.setBucket(key.getBucket());
                        record.setFileSize(key.getFileSizeUpperBound());
                        record.setCount(count);
                        resultSet.add(record);
                    }
                }
            }
            return Response.ok(resultSet).build();
        }
        catch (Exception e) {
            LOG.error("Error retrieving file counts from RocksDB", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/containerCount")
    public Response getContainerCounts(@QueryParam(value="containerSize") long upperBound) {
        DSLContext dslContext = this.utilizationSchemaDefinition.getDSLContext();
        Long containerSizeUpperBound = ReconUtils.getContainerSizeUpperBound(upperBound);
        try {
            Record1 recordToFind;
            ContainerCountBySize record2;
            List<Object> resultSet = upperBound > 0L ? ((record2 = (ContainerCountBySize)this.containerCountBySizeDao.findById((Long)(recordToFind = dslContext.newRecord(ContainerCountBySizeTable.CONTAINER_COUNT_BY_SIZE.CONTAINER_SIZE).value1((Object)containerSizeUpperBound)).value1())) != null ? Collections.singletonList(record2) : Collections.emptyList()) : this.containerCountBySizeDao.findAll().stream().filter(record -> record.getCount() > 0L).collect(Collectors.toList());
            return Response.ok(resultSet).build();
        }
        catch (Exception e) {
            LOG.error("Error retrieving container counts", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

