/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.filters;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.server.OzoneAdmins;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ReconAdminFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ReconAdminFilter.class);
    private final OzoneConfiguration conf;

    @Inject
    ReconAdminFilter(OzoneConfiguration conf) {
        this.conf = conf;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        Principal userPrincipal = httpServletRequest.getUserPrincipal();
        boolean isAdmin = false;
        String userName = null;
        if (userPrincipal != null) {
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)userPrincipal.getName());
            userName = ugi.getUserName();
            if (this.hasPermission(ugi)) {
                isAdmin = true;
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        }
        if (isAdmin) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Allowing request from admin user {} to {}", (Object)userName, (Object)httpServletRequest.getRequestURL());
            }
        } else {
            LOG.warn("Rejecting request from non admin user {} to {}", (Object)userName, (Object)httpServletRequest.getRequestURL());
            httpServletResponse.setStatus(403);
        }
    }

    public void destroy() {
    }

    private boolean hasPermission(UserGroupInformation user) {
        Collection admins = this.conf.getStringCollection("ozone.administrators");
        admins.addAll(this.conf.getStringCollection("ozone.recon.administrators"));
        Collection adminGroups = this.conf.getStringCollection("ozone.administrators.groups");
        adminGroups.addAll(this.conf.getStringCollection("ozone.recon.administrators.groups"));
        return new OzoneAdmins(admins, adminGroups).isAdmin(user);
    }
}

