/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconContainerMetadataManager;
import org.apache.hadoop.ozone.recon.tasks.ContainerKeyMapperHelper;
import org.apache.hadoop.ozone.recon.tasks.OMUpdateEventBatch;
import org.apache.hadoop.ozone.recon.tasks.ReconOmTask;

public class ContainerKeyMapperTaskFSO
implements ReconOmTask {
    private final ReconContainerMetadataManager reconContainerMetadataManager;
    private final OzoneConfiguration ozoneConfiguration;

    @Inject
    public ContainerKeyMapperTaskFSO(ReconContainerMetadataManager reconContainerMetadataManager, OzoneConfiguration configuration) {
        this.reconContainerMetadataManager = reconContainerMetadataManager;
        this.ozoneConfiguration = configuration;
    }

    @Override
    public ReconOmTask getStagedTask(ReconOMMetadataManager stagedOmMetadataManager, DBStore stagedReconDbStore) throws IOException {
        return new ContainerKeyMapperTaskFSO(this.reconContainerMetadataManager.getStagedReconContainerMetadataManager(stagedReconDbStore), this.ozoneConfiguration);
    }

    @Override
    public ReconOmTask.TaskResult reprocess(OMMetadataManager omMetadataManager) {
        long containerKeyFlushToDBMaxThreshold = this.ozoneConfiguration.getLong("ozone.recon.containerkey.flush.db.max.threshold", 150000L);
        boolean result = ContainerKeyMapperHelper.reprocess(omMetadataManager, this.reconContainerMetadataManager, BucketLayout.FILE_SYSTEM_OPTIMIZED, this.getTaskName(), containerKeyFlushToDBMaxThreshold);
        return this.buildTaskResult(result);
    }

    @Override
    public String getTaskName() {
        return "ContainerKeyMapperTaskFSO";
    }

    @Override
    public ReconOmTask.TaskResult process(OMUpdateEventBatch events, Map<String, Integer> subTaskSeekPosMap) {
        boolean result = ContainerKeyMapperHelper.process(events, "fileTable", this.reconContainerMetadataManager, this.getTaskName());
        return this.buildTaskResult(result);
    }
}

