/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.DatanodeVersion;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.ReconfigurationHandler;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.DatanodeID;
import org.apache.hadoop.hdds.protocol.SecretKeyProtocol;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.protocolPB.SecretKeyProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.symmetric.DefaultSecretKeyClient;
import org.apache.hadoop.hdds.security.symmetric.SecretKeyClient;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.client.DNCertificateClient;
import org.apache.hadoop.hdds.server.OzoneAdmins;
import org.apache.hadoop.hdds.server.http.HttpConfig;
import org.apache.hadoop.hdds.server.http.RatisDropwizardExports;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.HddsVersionInfo;
import org.apache.hadoop.hdds.utils.VersionInfo;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.ozone.DNMXBeanImpl;
import org.apache.hadoop.ozone.HddsDatanodeClientProtocolServer;
import org.apache.hadoop.ozone.HddsDatanodeHttpServer;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.container.common.DatanodeLayoutStorage;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeStateMachine;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.DeleteBlocksCommandHandler;
import org.apache.hadoop.ozone.container.common.utils.StorageVolumeUtil;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.common.volume.StorageVolume;
import org.apache.hadoop.ozone.util.OzoneNetUtils;
import org.apache.hadoop.ozone.util.ShutdownHookManager;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.ServicePlugin;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="ozone datanode", hidden=true, description={"Start the datanode for ozone"}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true)
public class HddsDatanodeService
extends GenericCli
implements Callable<Void>,
ServicePlugin {
    private static final Logger LOG = LoggerFactory.getLogger(HddsDatanodeService.class);
    public static final String TESTING_DATANODE_VERSION_INITIAL = "testing.hdds.datanode.version.initial";
    public static final String TESTING_DATANODE_VERSION_CURRENT = "testing.hdds.datanode.version.current";
    private OzoneConfiguration conf;
    private SecurityConfig secConf;
    private DatanodeDetails datanodeDetails;
    private DatanodeStateMachine datanodeStateMachine;
    private List<ServicePlugin> plugins;
    private CertificateClient dnCertClient;
    private SecretKeyClient secretKeyClient;
    private String component;
    private HddsDatanodeHttpServer httpServer;
    private boolean printBanner;
    private String[] args;
    private final AtomicBoolean isStopped = new AtomicBoolean(false);
    private final Map<String, RatisDropwizardExports> ratisMetricsMap = new ConcurrentHashMap<String, RatisDropwizardExports>();
    private List<RatisDropwizardExports.MetricReporter> ratisReporterList = null;
    private DNMXBeanImpl serviceRuntimeInfo;
    private ObjectName dnInfoBeanName;
    private HddsDatanodeClientProtocolServer clientProtocolServer;
    private OzoneAdmins admins;
    private ReconfigurationHandler reconfigurationHandler;

    public HddsDatanodeService() {
    }

    @VisibleForTesting
    public HddsDatanodeService(String[] args) {
        this(false, args);
    }

    private HddsDatanodeService(boolean printBanner, String[] args) {
        this.printBanner = printBanner;
        this.args = args != null ? Arrays.copyOf(args, args.length) : null;
    }

    public static void main(String[] args) {
        try {
            OzoneNetUtils.disableJvmNetworkAddressCacheIfRequired((OzoneConfiguration)new OzoneConfiguration());
            HddsDatanodeService hddsDatanodeService = new HddsDatanodeService(true, args);
            hddsDatanodeService.run(args);
        }
        catch (Throwable e) {
            LOG.error("Exception in HddsDatanodeService.", e);
            ExitUtil.terminate((int)1, (Throwable)e);
        }
    }

    @Override
    public Void call() throws Exception {
        OzoneConfiguration configuration = this.getOzoneConf();
        if (this.printBanner) {
            HddsServerUtil.startupShutdownMessage((VersionInfo)HddsVersionInfo.HDDS_VERSION_INFO, HddsDatanodeService.class, (String[])this.args, (Logger)LOG, (OzoneConfiguration)configuration);
        }
        this.start(configuration);
        ShutdownHookManager.get().addShutdownHook(() -> {
            try {
                this.stop();
                this.join();
            }
            catch (Exception e) {
                LOG.error("Error during stop Ozone Datanode.", (Throwable)e);
            }
        }, 10);
        return null;
    }

    public void setConfiguration(OzoneConfiguration configuration) {
        this.conf = configuration;
    }

    public void start(Object service) {
        if (service instanceof Configurable) {
            this.start(new OzoneConfiguration(((Configurable)service).getConf()));
        } else {
            this.start(new OzoneConfiguration());
        }
    }

    public void start(OzoneConfiguration configuration) {
        this.setConfiguration(configuration);
        this.start();
    }

    public void start() {
        this.serviceRuntimeInfo = new DNMXBeanImpl(HddsVersionInfo.HDDS_VERSION_INFO){

            public String getNamespace() {
                return HddsUtils.getScmServiceId((ConfigurationSource)HddsDatanodeService.this.conf);
            }
        };
        this.serviceRuntimeInfo.setStartTime();
        this.ratisReporterList = RatisDropwizardExports.registerRatisMetricReporters(this.ratisMetricsMap, () -> this.isStopped.get());
        OzoneConfiguration.activate();
        HddsServerUtil.initializeMetrics((OzoneConfiguration)this.conf, (String)"HddsDatanode");
        try {
            DatanodeLayoutStorage layoutStorage;
            String hostname = HddsUtils.getHostName((ConfigurationSource)this.conf);
            this.datanodeDetails = this.initializeDatanodeDetails();
            this.datanodeDetails.setHostName(hostname);
            this.serviceRuntimeInfo.setHostName(hostname);
            this.datanodeDetails.validateDatanodeIpAddress();
            this.datanodeDetails.setVersion(HddsVersionInfo.HDDS_VERSION_INFO.getVersion());
            this.datanodeDetails.setSetupTime(Time.now());
            this.datanodeDetails.setRevision(HddsVersionInfo.HDDS_VERSION_INFO.getRevision());
            TracingUtil.initTracing((String)("HddsDatanodeService." + this.datanodeDetails.getID()), (ConfigurationSource)this.conf);
            LOG.info("HddsDatanodeService {}", (Object)this.datanodeDetails);
            if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)this.conf)) {
                this.component = "dn-" + this.datanodeDetails.getID();
                this.secConf = new SecurityConfig((ConfigurationSource)this.conf);
                if (!SecurityUtil.getAuthenticationMethod((Configuration)this.conf).equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS)) {
                    throw new AuthenticationException(SecurityUtil.getAuthenticationMethod((Configuration)this.conf) + " authentication method not supported. Datanode user login failed.");
                }
                LOG.info("Ozone security is enabled. Attempting login for Hdds Datanode user. Principal: {},keytab: {}", (Object)this.conf.get("hdds.datanode.kerberos.principal"), (Object)this.conf.get("hdds.datanode.kerberos.keytab.file"));
                UserGroupInformation.setConfiguration((Configuration)this.conf);
                SecurityUtil.login((Configuration)this.conf, (String)"hdds.datanode.kerberos.keytab.file", (String)"hdds.datanode.kerberos.principal", (String)hostname);
                LOG.info("Hdds Datanode login successful.");
            }
            if ((layoutStorage = new DatanodeLayoutStorage((ConfigurationSource)this.conf, this.datanodeDetails.getUuidString())).getState() != Storage.StorageState.INITIALIZED) {
                layoutStorage.initialize();
            }
            if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)this.conf)) {
                this.dnCertClient = this.initializeCertificateClient(this.dnCertClient);
                if (this.secConf.isTokenEnabled()) {
                    SecretKeyProtocolClientSideTranslatorPB secretKeyProtocol = HddsServerUtil.getSecretKeyClientForDatanode((ConfigurationSource)this.conf);
                    this.secretKeyClient = DefaultSecretKeyClient.create((ConfigurationSource)this.conf, (SecretKeyProtocol)secretKeyProtocol, (String)"");
                    this.secretKeyClient.start((ConfigurationSource)this.conf);
                }
            }
            this.reconfigurationHandler = new ReconfigurationHandler("DN", this.conf, this::checkAdminPrivilege).register("hdds.datanode.block.delete.threads.max", this::reconfigBlockDeleteThreadMax).register("ozone.block.deleting.service.workers", this::reconfigDeletingServiceWorkers).register("ozone.block.deleting.service.interval", this::reconfigBlockDeletingServiceInterval).register("ozone.block.deleting.service.timeout", this::reconfigBlockDeletingServiceTimeout).register("hdds.datanode.replication.streams.limit", this::reconfigReplicationStreamsLimit);
            this.reconfigurationHandler.setReconfigurationCompleteCallback(this.reconfigurationHandler.defaultLoggingCallback());
            this.datanodeStateMachine = new DatanodeStateMachine(this, this.datanodeDetails, (ConfigurationSource)this.conf, this.dnCertClient, this.secretKeyClient, this::terminateDatanode, this.reconfigurationHandler);
            try {
                this.httpServer = new HddsDatanodeHttpServer((MutableConfigurationSource)this.conf);
                this.httpServer.start();
                HttpConfig.Policy policy = HttpConfig.getHttpPolicy((MutableConfigurationSource)this.conf);
                if (policy.isHttpEnabled()) {
                    int httpPort = this.httpServer.getHttpAddress().getPort();
                    this.datanodeDetails.setPort(DatanodeDetails.newPort((DatanodeDetails.Port.Name)DatanodeDetails.Port.Name.HTTP, (Integer)httpPort));
                    this.serviceRuntimeInfo.setHttpPort(String.valueOf(httpPort));
                }
                if (policy.isHttpsEnabled()) {
                    int httpsPort = this.httpServer.getHttpsAddress().getPort();
                    this.datanodeDetails.setPort(DatanodeDetails.newPort((DatanodeDetails.Port.Name)DatanodeDetails.Port.Name.HTTPS, (Integer)httpsPort));
                    this.serviceRuntimeInfo.setHttpsPort(String.valueOf(httpsPort));
                }
            }
            catch (Exception ex) {
                LOG.error("HttpServer failed to start.", (Throwable)ex);
            }
            this.clientProtocolServer = new HddsDatanodeClientProtocolServer(this.datanodeDetails, this.conf, HddsVersionInfo.HDDS_VERSION_INFO, this.reconfigurationHandler);
            int clientRpcport = this.clientProtocolServer.getClientRpcAddress().getPort();
            this.serviceRuntimeInfo.setClientRpcPort(String.valueOf(clientRpcport));
            String starterUser = UserGroupInformation.getCurrentUser().getShortUserName();
            this.admins = OzoneAdmins.getOzoneAdmins((String)starterUser, (OzoneConfiguration)this.conf);
            LOG.info("Datanode start with admins: {}", (Object)this.admins.getAdminUsernames());
            this.clientProtocolServer.start();
            this.startPlugins();
            this.datanodeStateMachine.startDaemon();
            if ("follower".equalsIgnoreCase(System.getenv("OZONE_DATANODE_STANDALONE_TEST"))) {
                this.startRatisForTest();
            }
            this.registerMXBean();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't start the HDDS datanode plugin", e);
        }
        catch (AuthenticationException ex) {
            throw new RuntimeException("Fail to authentication when starting HDDS datanode plugin", ex);
        }
    }

    @VisibleForTesting
    SCMSecurityProtocolClientSideTranslatorPB createScmSecurityClient() throws IOException {
        return HddsServerUtil.getScmSecurityClientWithMaxRetry((OzoneConfiguration)this.conf, (UserGroupInformation)UserGroupInformation.getCurrentUser());
    }

    private void startRatisForTest() throws IOException {
        String clusterId = "clusterId";
        this.datanodeStateMachine.getContainer().start(clusterId);
        MutableVolumeSet volumeSet = this.getDatanodeStateMachine().getContainer().getVolumeSet();
        Map<String, StorageVolume> volumeMap = volumeSet.getVolumeMap();
        for (Map.Entry<String, StorageVolume> entry : volumeMap.entrySet()) {
            HddsVolume hddsVolume = (HddsVolume)entry.getValue();
            boolean result = StorageVolumeUtil.checkVolume(hddsVolume, clusterId, clusterId, (ConfigurationSource)this.conf, LOG, null);
            if (result) continue;
            volumeSet.failVolume(hddsVolume.getHddsRootDir().getPath());
        }
    }

    @VisibleForTesting
    public CertificateClient initializeCertificateClient(CertificateClient certClient) throws IOException {
        LOG.info("Initializing secure Datanode.");
        if (certClient == null) {
            certClient = this.dnCertClient = new DNCertificateClient(this.secConf, this.createScmSecurityClient(), this.datanodeDetails, this.datanodeDetails.getCertSerialId(), this::saveNewCertId, this::terminateDatanode);
        }
        certClient.initWithRecovery();
        return certClient;
    }

    private void registerMXBean() {
        HashMap<String, String> jmxProperties = new HashMap<String, String>();
        jmxProperties.put("component", "ServerRuntime");
        this.dnInfoBeanName = HddsUtils.registerWithJmxProperties((String)"HddsDatanodeService", (String)"HddsDatanodeServiceInfo", jmxProperties, (Object)this.serviceRuntimeInfo);
    }

    private void unregisterMXBean() {
        if (this.dnInfoBeanName != null) {
            MBeans.unregister((ObjectName)this.dnInfoBeanName);
            this.dnInfoBeanName = null;
        }
    }

    private DatanodeDetails initializeDatanodeDetails() throws IOException {
        DatanodeDetails details;
        String idFilePath = HddsServerUtil.getDatanodeIdFilePath((ConfigurationSource)this.conf);
        Preconditions.checkNotNull((Object)idFilePath);
        File idFile = new File(idFilePath);
        if (idFile.exists()) {
            details = ContainerUtils.readDatanodeDetailsFrom(idFile);
        } else {
            details = DatanodeDetails.newBuilder().setID(DatanodeID.randomID()).build();
            details.setInitialVersion(this.getInitialVersion());
        }
        details.setCurrentVersion(this.getCurrentVersion());
        return details;
    }

    private void persistDatanodeDetails(DatanodeDetails dnDetails) throws IOException {
        String idFilePath = HddsServerUtil.getDatanodeIdFilePath((ConfigurationSource)this.conf);
        Preconditions.checkNotNull((Object)idFilePath);
        File idFile = new File(idFilePath);
        ContainerUtils.writeDatanodeDetailsTo(dnDetails, idFile, (ConfigurationSource)this.conf);
    }

    private void startPlugins() {
        try {
            this.plugins = this.conf.getInstances("hdds.datanode.plugins", ServicePlugin.class);
        }
        catch (RuntimeException e) {
            String pluginsValue = this.conf.get("hdds.datanode.plugins");
            LOG.error("Unable to load HDDS DataNode plugins. Specified list of plugins: {}", (Object)pluginsValue, (Object)e);
            throw e;
        }
        for (ServicePlugin plugin : this.plugins) {
            try {
                plugin.start((Object)this);
                LOG.info("Started plug-in {}", (Object)plugin);
            }
            catch (Throwable t) {
                LOG.warn("ServicePlugin {} could not be started", (Object)plugin, (Object)t);
            }
        }
    }

    public OzoneConfiguration getConf() {
        return this.conf;
    }

    @VisibleForTesting
    public DatanodeDetails getDatanodeDetails() {
        return this.datanodeDetails;
    }

    @VisibleForTesting
    public DatanodeStateMachine getDatanodeStateMachine() {
        return this.datanodeStateMachine;
    }

    public HddsDatanodeClientProtocolServer getClientProtocolServer() {
        return this.clientProtocolServer;
    }

    public void join() {
        if (this.datanodeStateMachine != null) {
            try {
                this.datanodeStateMachine.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.info("Interrupted during StorageContainerManager join.");
            }
        }
        if (this.getClientProtocolServer() != null) {
            try {
                this.getClientProtocolServer().join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.info("Interrupted during HddsDatanodeClientProtocolServer join.");
            }
        }
    }

    public void terminateDatanode() {
        this.stop();
        ExitUtil.terminate((int)1);
    }

    public void stop() {
        if (!this.isStopped.getAndSet(true)) {
            if (this.plugins != null) {
                for (ServicePlugin plugin : this.plugins) {
                    try {
                        plugin.stop();
                        LOG.info("Stopped plug-in {}", (Object)plugin);
                    }
                    catch (Throwable t) {
                        LOG.warn("ServicePlugin {} could not be stopped", (Object)plugin, (Object)t);
                    }
                }
            }
            if (this.datanodeStateMachine != null) {
                this.datanodeStateMachine.stopDaemon();
            }
            if (this.httpServer != null) {
                try {
                    this.httpServer.stop();
                }
                catch (Exception e) {
                    LOG.error("Stopping HttpServer is failed.", (Throwable)e);
                }
            }
            if (this.getClientProtocolServer() != null) {
                this.getClientProtocolServer().stop();
            }
            this.unregisterMXBean();
            RatisDropwizardExports.clear(this.ratisMetricsMap, this.ratisReporterList);
            if (this.secretKeyClient != null) {
                this.secretKeyClient.stop();
            }
        }
    }

    public void close() {
        if (this.plugins != null) {
            for (ServicePlugin plugin : this.plugins) {
                try {
                    plugin.close();
                }
                catch (Throwable t) {
                    LOG.warn("ServicePlugin {} could not be closed", (Object)plugin, (Object)t);
                }
            }
        }
        if (this.dnCertClient != null) {
            try {
                this.dnCertClient.close();
            }
            catch (IOException e) {
                LOG.warn("Certificate client could not be closed", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    public String getComponent() {
        return this.component;
    }

    public CertificateClient getCertificateClient() {
        return this.dnCertClient;
    }

    @VisibleForTesting
    public void setCertificateClient(CertificateClient client) throws IOException {
        if (this.dnCertClient != null) {
            this.dnCertClient.close();
        }
        this.dnCertClient = client;
    }

    @VisibleForTesting
    public void setSecretKeyClient(SecretKeyClient client) {
        this.secretKeyClient = client;
    }

    public void printError(Throwable error) {
        LOG.error("Exception in HddsDatanodeService.", error);
    }

    public void saveNewCertId(String newCertId) {
        this.datanodeDetails.setCertSerialId(newCertId);
        try {
            this.persistDatanodeDetails(this.datanodeDetails);
        }
        catch (IOException ex) {
            String msg = "Failed to persist new cert ID " + newCertId + "to VERSION file. Terminating datanode...";
            LOG.error(msg, (Throwable)ex);
            this.terminateDatanode();
        }
    }

    public boolean isStopped() {
        return this.isStopped.get();
    }

    private void checkAdminPrivilege(String operation) throws IOException {
        UserGroupInformation ugi = HddsServerUtil.getRemoteUser();
        this.admins.checkAdminUserPrivilege(ugi);
    }

    @VisibleForTesting
    public ReconfigurationHandler getReconfigurationHandler() {
        return this.reconfigurationHandler;
    }

    private String reconfigBlockDeleteThreadMax(String value) {
        this.getConf().set("hdds.datanode.block.delete.threads.max", value);
        DeleteBlocksCommandHandler handler = (DeleteBlocksCommandHandler)this.getDatanodeStateMachine().getCommandDispatcher().getDeleteBlocksCommandHandler();
        handler.setPoolSize(Integer.parseInt(value));
        return value;
    }

    private String reconfigDeletingServiceWorkers(String value) {
        Preconditions.checkArgument((Integer.parseInt(value) >= 0 ? 1 : 0) != 0, (Object)"ozone.block.deleting.service.workers cannot be negative.");
        this.getConf().set("ozone.block.deleting.service.workers", value);
        return value;
    }

    private String reconfigReplicationStreamsLimit(String value) {
        this.getConf().set("hdds.datanode.replication.streams.limit", value);
        this.getDatanodeStateMachine().getContainer().getReplicationServer().setPoolSize(Integer.parseInt(value));
        return value;
    }

    private String reconfigBlockDeletingServiceInterval(String value) {
        this.getConf().set("ozone.block.deleting.service.interval", value);
        return value;
    }

    private String reconfigBlockDeletingServiceTimeout(String value) {
        this.getConf().set("ozone.block.deleting.service.timeout", value);
        return value;
    }

    private int getInitialVersion() {
        return this.conf.getInt(TESTING_DATANODE_VERSION_INITIAL, DatanodeVersion.CURRENT_VERSION);
    }

    private int getCurrentVersion() {
        return this.conf.getInt(TESTING_DATANODE_VERSION_CURRENT, DatanodeVersion.CURRENT_VERSION);
    }
}

