/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.impl.ContainerLayoutVersion;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.ratis.util.Preconditions;
import org.yaml.snakeyaml.Yaml;

public abstract class ContainerData {
    private final ContainerProtos.ContainerType containerType;
    private final AtomicBoolean immediateCloseActionSent = new AtomicBoolean(false);
    private final long containerID;
    private final int layOutVersion;
    private final Map<String, String> metadata;
    private String chunksPath;
    private ContainerProtos.ContainerDataProto.State state;
    private final long maxSize;
    private boolean committedSpace;
    private final String originPipelineId;
    private final String originNodeId;
    private final Statistics statistics = new Statistics();
    private HddsVolume volume;
    private String checksum;
    private long dataChecksum;
    private static final long UNSET_DATA_CHECKSUM = -1L;
    private boolean isEmpty;
    private int replicaIndex;
    private Long dataScanTimestamp;
    private transient Optional<Instant> lastDataScanTime = Optional.empty();
    public static final Charset CHARSET_ENCODING = StandardCharsets.UTF_8;
    public static final String ZERO_CHECKSUM = new String(new byte[64], CHARSET_ENCODING);
    protected static final List<String> YAML_FIELDS = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"containerType", "containerID", "layOutVersion", "state", "metadata", "maxSize", "checksum", "dataScanTimestamp", "originPipelineId", "originNodeId"}));

    protected ContainerData(ContainerProtos.ContainerType type, long containerId, ContainerLayoutVersion layoutVersion, long size, String originPipelineId, String originNodeId) {
        this.containerType = Objects.requireNonNull(type, "type == null");
        this.containerID = containerId;
        this.layOutVersion = layoutVersion.getVersion();
        this.metadata = new TreeMap<String, String>();
        this.state = ContainerProtos.ContainerDataProto.State.OPEN;
        this.maxSize = size;
        Preconditions.assertTrue((this.maxSize > 0L ? 1 : 0) != 0, () -> "maxSize = " + this.maxSize + " <= 0");
        this.originPipelineId = originPipelineId;
        this.originNodeId = originNodeId;
        this.isEmpty = false;
        this.checksum = ZERO_CHECKSUM;
        this.dataChecksum = -1L;
    }

    protected ContainerData(ContainerData source) {
        this(source.getContainerType(), source.getContainerID(), source.getLayoutVersion(), source.getMaxSize(), source.getOriginPipelineId(), source.getOriginNodeId());
        this.replicaIndex = source.getReplicaIndex();
    }

    public long getContainerID() {
        return this.containerID;
    }

    public AtomicBoolean getImmediateCloseActionSent() {
        return this.immediateCloseActionSent;
    }

    public abstract String getContainerPath();

    public abstract String getMetadataPath();

    public ContainerProtos.ContainerType getContainerType() {
        return this.containerType;
    }

    public synchronized ContainerProtos.ContainerDataProto.State getState() {
        return this.state;
    }

    public int getReplicaIndex() {
        return this.replicaIndex;
    }

    public void setReplicaIndex(int replicaIndex) {
        this.replicaIndex = replicaIndex;
    }

    public synchronized void setState(ContainerProtos.ContainerDataProto.State state) {
        ContainerProtos.ContainerDataProto.State oldState = this.state;
        this.state = state;
        if (oldState == ContainerProtos.ContainerDataProto.State.OPEN && state != oldState) {
            this.releaseCommitSpace();
        }
    }

    public boolean isCommittedSpace() {
        return this.committedSpace;
    }

    public void setCommittedSpace(boolean committed) {
        this.committedSpace = committed;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public ContainerLayoutVersion getLayoutVersion() {
        return ContainerLayoutVersion.getContainerLayoutVersion(this.layOutVersion);
    }

    public String getChunksPath() {
        return this.chunksPath;
    }

    public void setChunksPath(String chunkPath) {
        this.chunksPath = chunkPath;
    }

    public void addMetadata(String key, String value) {
        this.metadata.put(key, value);
    }

    public Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public void setMetadata(Map<String, String> metadataMap) {
        this.metadata.clear();
        this.metadata.putAll(metadataMap);
    }

    public synchronized boolean isOpen() {
        return ContainerProtos.ContainerDataProto.State.OPEN == this.state;
    }

    public synchronized boolean isClosing() {
        return ContainerProtos.ContainerDataProto.State.CLOSING == this.state;
    }

    public synchronized boolean isValid() {
        return ContainerProtos.ContainerDataProto.State.INVALID != this.state;
    }

    public synchronized boolean isClosed() {
        return ContainerProtos.ContainerDataProto.State.CLOSED == this.state;
    }

    public synchronized boolean isQuasiClosed() {
        return ContainerProtos.ContainerDataProto.State.QUASI_CLOSED == this.state;
    }

    public synchronized boolean isUnhealthy() {
        return ContainerProtos.ContainerDataProto.State.UNHEALTHY == this.state;
    }

    public synchronized void quasiCloseContainer() {
        this.setState(ContainerProtos.ContainerDataProto.State.QUASI_CLOSED);
    }

    public synchronized void closeContainer() {
        this.setState(ContainerProtos.ContainerDataProto.State.CLOSED);
    }

    public void releaseCommitSpace() {
        long unused = this.getMaxSize() - this.getBytesUsed();
        if (unused > 0L && this.committedSpace) {
            this.getVolume().incCommittedBytes(0L - unused);
        }
        this.committedSpace = false;
    }

    public void commitSpace() {
        long unused = this.getMaxSize() - this.getBytesUsed();
        ContainerProtos.ContainerDataProto.State myState = this.getState();
        Preconditions.assertTrue((!this.committedSpace ? 1 : 0) != 0);
        if (myState != ContainerProtos.ContainerDataProto.State.OPEN) {
            return;
        }
        HddsVolume cVol = this.getVolume();
        if (unused > 0L && cVol != null) {
            cVol.incCommittedBytes(unused);
            this.committedSpace = true;
        }
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    private void incrWriteBytes(long bytes) {
        this.getVolume().incrementUsedSpace(bytes);
        long bytesUsedBeforeWrite = this.getBytesUsed() - bytes;
        long availableSpaceBeforeWrite = this.getMaxSize() - bytesUsedBeforeWrite;
        if (this.committedSpace && availableSpaceBeforeWrite > 0L) {
            long decrement = Math.min(bytes, availableSpaceBeforeWrite);
            this.getVolume().incCommittedBytes(-decrement);
        }
    }

    public long getBytesUsed() {
        return this.getStatistics().getBlockBytes();
    }

    public void setVolume(HddsVolume hddsVolume) {
        this.volume = hddsVolume;
    }

    @JsonIgnore
    public HddsVolume getVolume() {
        return this.volume;
    }

    @VisibleForTesting
    public long getBlockCount() {
        return this.getStatistics().getBlockByteAndCounts().getCount();
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void markAsEmpty() {
        this.isEmpty = true;
    }

    public void setContainerFileChecksum(String checkSum) {
        this.checksum = checkSum;
    }

    public String getContainerFileChecksum() {
        return this.checksum;
    }

    public Optional<Instant> lastDataScanTime() {
        return this.lastDataScanTime;
    }

    public void updateDataScanTime(@Nullable Instant time) {
        this.lastDataScanTime = Optional.ofNullable(time);
        this.dataScanTimestamp = time != null ? Long.valueOf(time.toEpochMilli()) : null;
    }

    public void setDataScanTimestamp(Long timestamp) {
        this.dataScanTimestamp = timestamp;
        this.lastDataScanTime = timestamp != null ? Optional.of(Instant.ofEpochMilli(timestamp)) : Optional.empty();
    }

    public Long getDataScanTimestamp() {
        return this.dataScanTimestamp;
    }

    public String getOriginPipelineId() {
        return this.originPipelineId;
    }

    public String getOriginNodeId() {
        return this.originNodeId;
    }

    public void computeAndSetContainerFileChecksum(Yaml yaml) throws IOException {
        this.checksum = ZERO_CHECKSUM;
        String containerDataYamlStr = yaml.dump((Object)this);
        this.checksum = ContainerUtils.getContainerFileChecksum(containerDataYamlStr);
    }

    public void setDataChecksum(long dataChecksum) {
        if (dataChecksum < 0L) {
            throw new IllegalArgumentException("Data checksum cannot be set to a negative number.");
        }
        this.dataChecksum = dataChecksum;
    }

    public long getDataChecksum() {
        if (this.needsDataChecksum()) {
            return 0L;
        }
        return this.dataChecksum;
    }

    public boolean needsDataChecksum() {
        return this.dataChecksum == -1L;
    }

    public abstract ContainerProtos.ContainerDataProto getProtoBufMessage();

    public abstract long getBlockCommitSequenceId();

    public void updateWriteStats(long bytesWritten, boolean overwrite) {
        this.getStatistics().updateWrite(bytesWritten, overwrite);
        this.incrWriteBytes(bytesWritten);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " #" + this.containerID + " (" + this.state + ", " + (this.isEmpty ? "empty" : "non-empty") + ", ri=" + this.replicaIndex + ", origin=[dn_" + this.originNodeId + ", pipeline_" + this.originPipelineId + "])";
    }

    public static class Statistics {
        private long readBytes;
        private long readCount;
        private long writeBytes;
        private long writeCount;
        private long blockBytes;
        private long blockCount;
        private long blockPendingDeletion;

        public synchronized long getWriteBytes() {
            return this.writeBytes;
        }

        public synchronized long getBlockBytes() {
            return this.blockBytes;
        }

        public synchronized BlockByteAndCounts getBlockByteAndCounts() {
            return new BlockByteAndCounts(this.blockBytes, this.blockCount, this.blockPendingDeletion);
        }

        public synchronized long getBlockPendingDeletion() {
            return this.blockPendingDeletion;
        }

        public synchronized void incrementBlockCount() {
            ++this.blockCount;
        }

        public synchronized void updateRead(long length) {
            ++this.readCount;
            this.readBytes += length;
        }

        public synchronized void updateWrite(long length, boolean overwrite) {
            if (!overwrite) {
                this.blockBytes += length;
            }
            ++this.writeCount;
            this.writeBytes += length;
        }

        public synchronized void updateDeletion(long deletedBytes, long deletedBlockCount, long processedBlockCount) {
            this.blockBytes -= deletedBytes;
            this.blockCount -= deletedBlockCount;
            this.blockPendingDeletion -= processedBlockCount;
        }

        public synchronized void updateBlocks(long bytes, long count, long pendingDeletionIncrement) {
            this.blockBytes = bytes;
            this.blockCount = count;
            this.blockPendingDeletion += pendingDeletionIncrement;
        }

        public synchronized ContainerProtos.ContainerDataProto.Builder setContainerDataProto(ContainerProtos.ContainerDataProto.Builder b) {
            if (this.blockBytes > 0L) {
                b.setBytesUsed(this.blockBytes);
            }
            return b.setBlockCount(this.blockCount);
        }

        public synchronized StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.Builder setContainerReplicaProto(StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.Builder b) {
            return b.setReadBytes(this.readBytes).setReadCount(this.readCount).setWriteBytes(this.writeBytes).setWriteCount(this.writeCount).setUsed(this.blockBytes).setKeyCount(this.blockCount);
        }

        public synchronized void addBlockPendingDeletion(long count) {
            this.blockPendingDeletion += count;
        }

        public synchronized void resetBlockPendingDeletion() {
            this.blockPendingDeletion = 0L;
        }

        public synchronized void assertRead(long expectedBytes, long expectedCount) {
            Preconditions.assertSame((long)expectedBytes, (long)this.readBytes, (String)"readBytes");
            Preconditions.assertSame((long)expectedCount, (long)this.readCount, (String)"readCount");
        }

        public synchronized void assertWrite(long expectedBytes, long expectedCount) {
            Preconditions.assertSame((long)expectedBytes, (long)this.writeBytes, (String)"writeBytes");
            Preconditions.assertSame((long)expectedCount, (long)this.writeCount, (String)"writeCount");
        }

        public synchronized void assertBlock(long expectedBytes, long expectedCount, long expectedPendingDeletion) {
            Preconditions.assertSame((long)expectedBytes, (long)this.blockBytes, (String)"blockBytes");
            Preconditions.assertSame((long)expectedCount, (long)this.blockCount, (String)"blockCount");
            Preconditions.assertSame((long)expectedPendingDeletion, (long)this.blockPendingDeletion, (String)"blockPendingDeletion");
        }

        public synchronized void setBlockCountForTesting(long count) {
            this.blockCount = count;
        }

        public synchronized void setBlockBytesForTesting(long bytes) {
            this.blockBytes = bytes;
        }

        public synchronized String toString() {
            return "Statistics{read(" + this.readBytes + " bytes, #" + this.readCount + "), write(" + this.writeBytes + " bytes, #" + this.writeCount + "), block(" + this.blockBytes + " bytes, #" + this.blockCount + ", pendingDelete=" + this.blockPendingDeletion + ")}";
        }
    }

    public static class BlockByteAndCounts {
        private final long bytes;
        private final long count;
        private final long pendingDeletion;

        public BlockByteAndCounts(long bytes, long count, long pendingDeletion) {
            this.bytes = bytes;
            this.count = count;
            this.pendingDeletion = pendingDeletion;
        }

        public long getBytes() {
            return this.bytes;
        }

        public long getCount() {
            return this.count;
        }

        public long getPendingDeletion() {
            return this.pendingDeletion;
        }
    }
}

