/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine.commandhandler;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandHandler;
import org.apache.hadoop.ozone.container.common.transport.server.XceiverServerSpi;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.protocol.commands.CreatePipelineCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.util.Time;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.exceptions.AlreadyExistsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatePipelineCommandHandler
implements CommandHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CreatePipelineCommandHandler.class);
    private final AtomicLong invocationCount = new AtomicLong(0L);
    private final AtomicInteger queuedCount = new AtomicInteger(0);
    private final BiFunction<RaftPeer, GrpcTlsConfig, RaftClient> newRaftClient;
    private final Executor executor;
    private final MutableRate opsLatencyMs;
    private final Set<UUID> pipelinesInProgress;

    public CreatePipelineCommandHandler(ConfigurationSource conf, Executor executor) {
        this(RatisHelper.newRaftClient((ConfigurationSource)conf), executor);
    }

    CreatePipelineCommandHandler(BiFunction<RaftPeer, GrpcTlsConfig, RaftClient> newRaftClient, Executor executor) {
        this.newRaftClient = newRaftClient;
        this.executor = executor;
        MetricsRegistry registry = new MetricsRegistry(CreatePipelineCommandHandler.class.getSimpleName());
        this.opsLatencyMs = registry.newRate(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.createPipelineCommand + "Ms");
        this.pipelinesInProgress = ConcurrentHashMap.newKeySet();
    }

    @Override
    public void handle(SCMCommand<?> command, OzoneContainer ozoneContainer, StateContext context, SCMConnectionManager connectionManager) {
        CreatePipelineCommand createCommand = (CreatePipelineCommand)command;
        PipelineID pipelineID = createCommand.getPipelineID();
        UUID pipelineUUID = pipelineID.getId();
        if (!this.pipelinesInProgress.add(pipelineUUID)) {
            LOG.debug("Create Pipeline command for pipeline {} is already in progress, skipping duplicate command.", (Object)pipelineID);
            return;
        }
        try {
            this.queuedCount.incrementAndGet();
            CompletableFuture.runAsync(() -> {
                this.invocationCount.incrementAndGet();
                long startTime = Time.monotonicNow();
                DatanodeDetails dn = context.getParent().getDatanodeDetails();
                HddsProtos.PipelineID pipelineIdProto = pipelineID.getProtobuf();
                List<DatanodeDetails> peers = createCommand.getNodeList();
                List<Integer> priorityList = createCommand.getPriorityList();
                try {
                    XceiverServerSpi server = ozoneContainer.getWriteChannel();
                    if (!server.isExist(pipelineIdProto)) {
                        RaftGroupId groupId = RaftGroupId.valueOf((UUID)pipelineID.getId());
                        RaftGroup group = RatisHelper.newRaftGroup((RaftGroupId)groupId, peers, priorityList);
                        server.addGroup(pipelineIdProto, peers, priorityList);
                        peers.stream().filter(d -> !d.getID().equals((Object)dn.getID())).forEach(d -> {
                            RaftPeer peer = RatisHelper.toRaftPeer((DatanodeDetails)d);
                            try (RaftClient client2 = this.newRaftClient.apply(peer, ozoneContainer.getTlsClientConfig());){
                                client2.getGroupManagementApi(peer.getId()).add(group);
                            }
                            catch (AlreadyExistsException client2) {
                            }
                            catch (IOException ioe) {
                                LOG.warn("Add group failed for {}", d, (Object)ioe);
                            }
                        });
                        LOG.info("Created Pipeline {} {} {}.", new Object[]{createCommand.getReplicationType(), createCommand.getFactor(), pipelineID});
                    }
                }
                catch (IOException e) {
                    if (!(e.getCause() instanceof AlreadyExistsException)) {
                        LOG.error("Can't create pipeline {} {} {}", new Object[]{createCommand.getReplicationType(), createCommand.getFactor(), pipelineID, e});
                    }
                }
                finally {
                    long endTime = Time.monotonicNow();
                    this.opsLatencyMs.add(endTime - startTime);
                }
            }, this.executor).whenComplete((v, e) -> {
                this.queuedCount.decrementAndGet();
                this.pipelinesInProgress.remove(pipelineUUID);
            });
        }
        catch (RejectedExecutionException ex) {
            this.queuedCount.decrementAndGet();
            this.pipelinesInProgress.remove(pipelineUUID);
            LOG.warn("Create Pipeline command for pipeline {} is rejected as command queue has reached max size.", (Object)pipelineID);
        }
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getCommandType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.createPipelineCommand;
    }

    @Override
    public int getInvocationCount() {
        return (int)this.invocationCount.get();
    }

    @Override
    public long getAverageRunTime() {
        return (long)this.opsLatencyMs.lastStat().mean();
    }

    @Override
    public long getTotalRunTime() {
        return (long)this.opsLatencyMs.lastStat().total();
    }

    @Override
    public int getQueuedCount() {
        return this.queuedCount.get();
    }
}

