/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.helpers.ContainerMetrics;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.utils.StorageVolumeUtil;
import org.apache.hadoop.util.Time;
import org.apache.ratis.statemachine.StateMachine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class StreamDataChannelBase
implements StateMachine.DataChannel {
    static final Logger LOG = LoggerFactory.getLogger(StreamDataChannelBase.class);
    private final RandomAccessFile randomAccessFile;
    private final File file;
    private final AtomicBoolean linked = new AtomicBoolean();
    private final AtomicBoolean cleaned = new AtomicBoolean();
    private final ContainerData containerData;
    private final ContainerMetrics metrics;

    StreamDataChannelBase(File file, ContainerData containerData, ContainerMetrics metrics) throws StorageContainerException {
        try {
            this.file = file;
            this.randomAccessFile = new RandomAccessFile(file, "rw");
        }
        catch (FileNotFoundException e) {
            throw new StorageContainerException("BlockFile not exists with container Id " + containerData.getContainerID() + " file " + file.getAbsolutePath(), ContainerProtos.Result.IO_EXCEPTION);
        }
        this.containerData = containerData;
        this.metrics = metrics;
    }

    abstract ContainerProtos.Type getType();

    private FileChannel getChannel() {
        return this.randomAccessFile.getChannel();
    }

    protected void checkVolume() {
        StorageVolumeUtil.onFailure(this.containerData.getVolume());
    }

    public final void force(boolean metadata) throws IOException {
        try {
            this.getChannel().force(metadata);
        }
        catch (IOException e) {
            this.checkVolume();
            throw e;
        }
    }

    public final boolean isOpen() {
        return this.getChannel().isOpen();
    }

    protected void assertSpaceAvailability(int requested) throws StorageContainerException {
        ContainerUtils.assertSpaceAvailability(this.containerData.getContainerID(), this.containerData.getVolume(), requested);
    }

    public void setLinked() {
        this.linked.set(true);
    }

    public boolean cleanUp() {
        if (this.linked.get()) {
            return true;
        }
        if (this.cleaned.compareAndSet(false, true)) {
            try {
                this.cleanupInternal();
            }
            catch (IOException e) {
                LOG.warn("Failed to close " + this, (Throwable)e);
            }
        }
        return false;
    }

    protected abstract void cleanupInternal() throws IOException;

    public void close() throws IOException {
        try {
            this.randomAccessFile.close();
        }
        catch (IOException e) {
            this.checkVolume();
            throw e;
        }
    }

    final int writeFileChannel(ByteBuffer src) throws IOException {
        try {
            long startTime = Time.monotonicNowNanos();
            int writeBytes = this.getChannel().write(src);
            this.metrics.incContainerBytesStats(this.getType(), writeBytes);
            this.containerData.updateWriteStats(writeBytes, false);
            this.metrics.incContainerOpsLatencies(this.getType(), Time.monotonicNowNanos() - startTime);
            return writeBytes;
        }
        catch (IOException e) {
            this.checkVolume();
            throw e;
        }
    }

    public ContainerMetrics getMetrics() {
        return this.metrics;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{File=" + this.file.getAbsolutePath() + ", containerID=" + this.containerData.getContainerID() + '}';
    }
}

