/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.interfaces;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.common.ChecksumData;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.hadoop.ozone.common.ChunkBufferToByteString;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfo;
import org.apache.hadoop.ozone.container.common.helpers.ContainerMetrics;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.DispatcherContext;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainer;
import org.apache.ratis.statemachine.StateMachine;

public interface ChunkManager {
    public void writeChunk(Container var1, BlockID var2, ChunkInfo var3, ChunkBuffer var4, DispatcherContext var5) throws StorageContainerException;

    default public void writeChunk(Container container, BlockID blockID, ChunkInfo info, ByteBuffer data, DispatcherContext dispatcherContext) throws StorageContainerException {
        ChunkBuffer wrapper = ChunkBuffer.wrap((ByteBuffer)data);
        this.writeChunk(container, blockID, info, wrapper, dispatcherContext);
    }

    public ChunkBufferToByteString readChunk(Container var1, BlockID var2, ChunkInfo var3, DispatcherContext var4) throws StorageContainerException;

    public void deleteChunk(Container var1, BlockID var2, ChunkInfo var3) throws StorageContainerException;

    public void deleteChunks(Container var1, BlockData var2) throws StorageContainerException;

    default public void shutdown() {
    }

    default public void finishWriteChunks(KeyValueContainer kvContainer, BlockData blockData) throws IOException {
    }

    default public void finalizeWriteChunk(KeyValueContainer container, BlockID blockId) throws IOException {
    }

    default public String streamInit(Container container, BlockID blockID) throws StorageContainerException {
        return null;
    }

    default public StateMachine.DataChannel getStreamDataChannel(Container container, BlockID blockID, ContainerMetrics metrics) throws StorageContainerException {
        return null;
    }

    public static int getBufferCapacityForChunkRead(ChunkInfo chunkInfo, int defaultReadBufferCapacity) {
        long bufferCapacity = 0L;
        if (chunkInfo.isReadDataIntoSingleBuffer()) {
            bufferCapacity = chunkInfo.getLen();
        } else {
            ChecksumData checksumData = chunkInfo.getChecksumData();
            if (checksumData != null) {
                bufferCapacity = checksumData.getChecksumType() == ContainerProtos.ChecksumType.NONE ? (long)defaultReadBufferCapacity : (long)checksumData.getBytesPerChecksum();
            }
        }
        if (bufferCapacity == 0L) {
            bufferCapacity = chunkInfo.getLen();
        }
        if (bufferCapacity > Integer.MAX_VALUE) {
            throw new IllegalStateException("Integer overflow: bufferCapacity = " + bufferCapacity + " > Integer.MAX_VALUE = " + Integer.MAX_VALUE + ", defaultReadBufferCapacity=" + defaultReadBufferCapacity + ", chunkInfo=" + chunkInfo);
        }
        return Math.toIntExact(bufferCapacity);
    }
}

