/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.metadata;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.CodecException;
import org.apache.hadoop.hdds.utils.db.RocksDatabaseException;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfoList;
import org.apache.hadoop.ozone.container.metadata.DatanodeTable;

public class SchemaOneDeletedBlocksTable
extends DatanodeTable<String, ChunkInfoList> {
    public static final String DELETED_KEY_PREFIX = "#deleted#";
    private static final MetadataKeyFilters.KeyPrefixFilter DELETED_FILTER = MetadataKeyFilters.KeyPrefixFilter.newFilter((String)"#deleted#");

    public SchemaOneDeletedBlocksTable(Table<String, ChunkInfoList> table) {
        super(table);
    }

    @Override
    public void put(String key, ChunkInfoList value) throws RocksDatabaseException, CodecException {
        super.put(SchemaOneDeletedBlocksTable.prefix(key), value);
    }

    @Override
    public void putWithBatch(BatchOperation batch, String key, ChunkInfoList value) throws RocksDatabaseException, CodecException {
        super.putWithBatch(batch, SchemaOneDeletedBlocksTable.prefix(key), value);
    }

    @Override
    public void delete(String key) throws RocksDatabaseException, CodecException {
        super.delete(SchemaOneDeletedBlocksTable.prefix(key));
    }

    @Override
    public void deleteWithBatch(BatchOperation batch, String key) throws CodecException {
        super.deleteWithBatch(batch, SchemaOneDeletedBlocksTable.prefix(key));
    }

    @Override
    public void deleteRange(String beginKey, String endKey) throws RocksDatabaseException, CodecException {
        super.deleteRange(SchemaOneDeletedBlocksTable.prefix(beginKey), SchemaOneDeletedBlocksTable.prefix(endKey));
    }

    @Override
    public boolean isExist(String key) throws RocksDatabaseException, CodecException {
        return super.isExist(SchemaOneDeletedBlocksTable.prefix(key));
    }

    @Override
    public ChunkInfoList get(String key) throws RocksDatabaseException, CodecException {
        return (ChunkInfoList)super.get(SchemaOneDeletedBlocksTable.prefix(key));
    }

    @Override
    public ChunkInfoList getIfExist(String key) throws RocksDatabaseException, CodecException {
        return (ChunkInfoList)super.getIfExist(SchemaOneDeletedBlocksTable.prefix(key));
    }

    @Override
    public ChunkInfoList getReadCopy(String key) throws RocksDatabaseException, CodecException {
        return (ChunkInfoList)super.getReadCopy(SchemaOneDeletedBlocksTable.prefix(key));
    }

    @Override
    public List<Table.KeyValue<String, ChunkInfoList>> getRangeKVs(String startKey, int count, String prefix, MetadataKeyFilters.KeyPrefixFilter filter, boolean isSequential) throws RocksDatabaseException, CodecException {
        return SchemaOneDeletedBlocksTable.unprefix(super.getRangeKVs(SchemaOneDeletedBlocksTable.prefix(startKey), count, prefix, DELETED_FILTER, isSequential));
    }

    private static String prefix(String key) {
        String result = null;
        if (key != null) {
            result = DELETED_KEY_PREFIX + key;
        }
        return result;
    }

    private static String unprefix(String key) {
        String result = null;
        if (key != null && key.startsWith(DELETED_KEY_PREFIX)) {
            result = key.replaceFirst(DELETED_KEY_PREFIX, "");
        }
        return result;
    }

    private static List<Table.KeyValue<String, ChunkInfoList>> unprefix(List<Table.KeyValue<String, ChunkInfoList>> kvs) {
        return kvs.stream().map(kv -> Table.newKeyValue((Object)SchemaOneDeletedBlocksTable.unprefix((String)kv.getKey()), (Object)((ChunkInfoList)kv.getValue()))).collect(Collectors.toList());
    }
}

