/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.replication.AbstractReplicationTask;
import org.apache.hadoop.ozone.container.replication.ContainerDownloader;
import org.apache.hadoop.ozone.container.replication.ContainerImporter;
import org.apache.hadoop.ozone.container.replication.ContainerReplicator;
import org.apache.hadoop.ozone.container.replication.CopyContainerCompression;
import org.apache.hadoop.ozone.container.replication.ReplicationTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadAndImportReplicator
implements ContainerReplicator {
    private static final Logger LOG = LoggerFactory.getLogger(DownloadAndImportReplicator.class);
    private final ConfigurationSource conf;
    private final ContainerDownloader downloader;
    private final ContainerImporter containerImporter;
    private final ContainerSet containerSet;

    public DownloadAndImportReplicator(ConfigurationSource conf, ContainerSet containerSet, ContainerImporter containerImporter, ContainerDownloader downloader) {
        this.conf = conf;
        this.containerSet = containerSet;
        this.downloader = downloader;
        this.containerImporter = containerImporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replicate(ReplicationTask task) {
        long containerID = task.getContainerId();
        if (this.containerSet.getContainer(containerID) != null) {
            LOG.debug("Container {} has already been downloaded.", (Object)containerID);
            task.setStatus(AbstractReplicationTask.Status.SKIPPED);
            return;
        }
        List<DatanodeDetails> sourceDatanodes = task.getSources();
        CopyContainerCompression compression = CopyContainerCompression.getConf(this.conf);
        LOG.info("Starting replication of container {} from {} using {}", new Object[]{containerID, sourceDatanodes, compression});
        HddsVolume targetVolume = null;
        try {
            targetVolume = this.containerImporter.chooseNextVolume(this.containerImporter.getDefaultReplicationSpace());
            Path tarFilePath = this.downloader.getContainerDataFromReplicas(containerID, sourceDatanodes, ContainerImporter.getUntarDirectory(targetVolume), compression);
            if (tarFilePath == null) {
                task.setStatus(AbstractReplicationTask.Status.FAILED);
                return;
            }
            long bytes = Files.size(tarFilePath);
            LOG.info("Container {} is downloaded with size {}, starting to import.", (Object)containerID, (Object)bytes);
            task.setTransferredBytes(bytes);
            this.containerImporter.importContainer(containerID, tarFilePath, targetVolume, compression);
            LOG.info("Container {} is replicated successfully", (Object)containerID);
            task.setStatus(AbstractReplicationTask.Status.DONE);
        }
        catch (IOException e) {
            LOG.error("Container {} replication was unsuccessful.", (Object)containerID, (Object)e);
            task.setStatus(AbstractReplicationTask.Status.FAILED);
        }
        finally {
            if (targetVolume != null) {
                targetVolume.incCommittedBytes(-this.containerImporter.getDefaultReplicationSpace());
            }
        }
    }
}

