/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class ExpiredOpenKeys {
    private final Map<String, OzoneManagerProtocolProtos.OpenKeyBucket.Builder> openKeyBuckets = new HashMap<String, OzoneManagerProtocolProtos.OpenKeyBucket.Builder>();
    private final List<OzoneManagerProtocolProtos.CommitKeyRequest.Builder> hsyncKeys = new ArrayList<OzoneManagerProtocolProtos.CommitKeyRequest.Builder>();

    public Collection<OzoneManagerProtocolProtos.OpenKeyBucket.Builder> getOpenKeyBuckets() {
        return this.openKeyBuckets.values();
    }

    public List<OzoneManagerProtocolProtos.CommitKeyRequest.Builder> getHsyncKeys() {
        return this.hsyncKeys;
    }

    void addOpenKey(OmKeyInfo info, String dbOpenKeyName) {
        String mapKey = info.getVolumeName() + "/" + info.getBucketName();
        this.openKeyBuckets.computeIfAbsent(mapKey, k -> OzoneManagerProtocolProtos.OpenKeyBucket.newBuilder().setVolumeName(info.getVolumeName()).setBucketName(info.getBucketName())).addKeys(OzoneManagerProtocolProtos.OpenKey.newBuilder().setName(dbOpenKeyName));
    }

    void addHsyncKey(OzoneManagerProtocolProtos.KeyArgs.Builder keyArgs, long clientId) {
        this.hsyncKeys.add(OzoneManagerProtocolProtos.CommitKeyRequest.newBuilder().setKeyArgs(keyArgs).setClientID(clientId));
    }
}

