/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx;

import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.impl.BodyHandlerImpl;
import javax.ws.rs.core.Response;

public abstract class SimpleBodyHandler
extends BodyHandlerImpl {
    public void handle(RoutingContext context) {
        if (this.checkContentType(context)) {
            super.handle(context);
        }
    }

    protected boolean checkContentType(RoutingContext context) {
        String contentType = context.request().getHeader("Content-Type");
        if (this.contentTypeSupported(contentType)) {
            return true;
        }
        Response.Status status = Response.Status.UNSUPPORTED_MEDIA_TYPE;
        context.response().setStatusCode(status.getStatusCode()).setStatusMessage(status.getReasonPhrase());
        context.response().end(String.format("Content-Type %s is not supported", contentType));
        return false;
    }

    protected abstract boolean contentTypeSupported(String var1);
}

