/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.node.rule.tuple;

import com.google.common.base.CaseFormat;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.mode.node.rule.tuple.annotation.RuleNodeTupleEntity;
import org.apache.shardingsphere.mode.node.rule.tuple.annotation.RuleNodeTupleField;

public final class YamlRuleConfigurationReflectionEngine {
    public static Class<? extends YamlRuleConfiguration> findClass(String ruleType) {
        for (YamlRuleConfigurationSwapper each : ShardingSphereServiceLoader.getServiceInstances(YamlRuleConfigurationSwapper.class)) {
            Class<? extends YamlRuleConfiguration> yamlRuleConfigClass = YamlRuleConfigurationReflectionEngine.getYamlRuleConfigurationClass(each);
            RuleNodeTupleEntity entity = yamlRuleConfigClass.getAnnotation(RuleNodeTupleEntity.class);
            if (null == entity || !entity.value().equals(ruleType)) continue;
            return yamlRuleConfigClass;
        }
        throw new IllegalArgumentException(String.format("Can not find YAML rule configuration with type: %s", ruleType));
    }

    private static Class<? extends YamlRuleConfiguration> getYamlRuleConfigurationClass(YamlRuleConfigurationSwapper swapper) {
        return (Class)((ParameterizedType)swapper.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
    }

    public static Collection<Field> getFields(Class<? extends YamlRuleConfiguration> yamlRuleConfigClass) {
        return Arrays.stream(yamlRuleConfigClass.getDeclaredFields()).filter(each -> null != each.getAnnotation(RuleNodeTupleField.class)).sorted(Comparator.comparingInt(o -> o.getAnnotation(RuleNodeTupleField.class).type().ordinal())).collect(Collectors.toList());
    }

    public static String getRuleNodeItemName(Field field) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, field.getName());
    }

    @Generated
    private YamlRuleConfigurationReflectionEngine() {
    }
}

