/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.extractor;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ExpressionExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.RowExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex.CommonTableExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.DatetimeProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.IntervalExpressionProjection;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.join.OuterJoinExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.HavingSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.CollectionTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;

public final class ColumnExtractor {
    public static Collection<ColumnSegment> extract(ExpressionSegment expression) {
        LinkedHashSet<ColumnSegment> result = new LinkedHashSet<ColumnSegment>();
        if (expression instanceof ColumnSegment) {
            result.add((ColumnSegment)expression);
        }
        if (expression instanceof BinaryOperationExpression) {
            ColumnExtractor.extractColumnsInBinaryOperationExpression((BinaryOperationExpression)expression, result);
        }
        if (expression instanceof InExpression) {
            ColumnExtractor.extractColumnsInInExpression((InExpression)expression, result);
        }
        if (expression instanceof BetweenExpression) {
            ColumnExtractor.extractColumnsInBetweenExpression((BetweenExpression)expression, result);
        }
        if (expression instanceof AggregationProjectionSegment) {
            ColumnExtractor.extractColumnsInAggregationProjectionSegment((AggregationProjectionSegment)expression, result);
        }
        if (expression instanceof FunctionSegment) {
            ColumnExtractor.extractColumnsInFunctionSegment((FunctionSegment)expression, result);
        }
        return result;
    }

    private static void extractColumnsInInExpression(InExpression expression, Collection<ColumnSegment> result) {
        if (expression.getLeft() instanceof ColumnSegment) {
            result.add((ColumnSegment)expression.getLeft());
        }
        if (expression.getLeft() instanceof RowExpression) {
            ColumnExtractor.extractColumnsInRowExpression((RowExpression)expression.getLeft(), result);
        }
        if (expression.getLeft() instanceof FunctionSegment) {
            ColumnExtractor.extractColumnsInFunctionSegment((FunctionSegment)expression.getLeft(), result);
        }
        result.addAll(ColumnExtractor.extract(expression.getRight()));
    }

    private static void extractColumnsInBinaryOperationExpression(BinaryOperationExpression expression, Collection<ColumnSegment> result) {
        if (expression.getLeft() instanceof ColumnSegment) {
            result.add((ColumnSegment)expression.getLeft());
        }
        if (expression.getRight() instanceof ColumnSegment) {
            result.add((ColumnSegment)expression.getRight());
        }
        if (expression.getLeft() instanceof OuterJoinExpression) {
            result.add(((OuterJoinExpression)expression.getLeft()).getColumnName());
        }
        if (expression.getRight() instanceof OuterJoinExpression) {
            result.add(((OuterJoinExpression)expression.getRight()).getColumnName());
        }
        result.addAll(ColumnExtractor.extract(expression.getLeft()));
        result.addAll(ColumnExtractor.extract(expression.getRight()));
    }

    private static void extractColumnsInBetweenExpression(BetweenExpression expression, Collection<ColumnSegment> result) {
        if (expression.getLeft() instanceof ColumnSegment) {
            result.add((ColumnSegment)expression.getLeft());
        }
        if (expression.getBetweenExpr() instanceof ColumnSegment) {
            result.add((ColumnSegment)expression.getBetweenExpr());
        }
        if (expression.getAndExpr() instanceof ColumnSegment) {
            result.add((ColumnSegment)expression.getAndExpr());
        }
        result.addAll(ColumnExtractor.extract(expression.getLeft()));
        result.addAll(ColumnExtractor.extract(expression.getBetweenExpr()));
        result.addAll(ColumnExtractor.extract(expression.getAndExpr()));
    }

    private static void extractColumnsInRowExpression(RowExpression expression, Collection<ColumnSegment> result) {
        for (ExpressionSegment each : expression.getItems()) {
            if (!(each instanceof ColumnSegment)) continue;
            result.add((ColumnSegment)each);
        }
    }

    private static void extractColumnsInAggregationProjectionSegment(AggregationProjectionSegment expression, Collection<ColumnSegment> result) {
        for (ExpressionSegment each : expression.getParameters()) {
            if (each instanceof ColumnSegment) {
                result.add((ColumnSegment)each);
                continue;
            }
            result.addAll(ColumnExtractor.extract(each));
        }
    }

    private static void extractColumnsInFunctionSegment(FunctionSegment expression, Collection<ColumnSegment> result) {
        for (ExpressionSegment each : expression.getParameters()) {
            if (each instanceof ColumnSegment) {
                result.add((ColumnSegment)each);
                continue;
            }
            result.addAll(ColumnExtractor.extract(each));
        }
    }

    public static Collection<ColumnSegment> extractColumnSegments(Collection<WhereSegment> whereSegments) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        for (WhereSegment each : whereSegments) {
            for (ExpressionSegment expression : ExpressionExtractor.extractAllExpressions(each.getExpr())) {
                result.addAll(ColumnExtractor.extract(expression));
            }
        }
        return result;
    }

    public static void extractFromSelectStatement(Collection<ColumnSegment> columnSegments, SelectStatement statement, boolean containsSubQuery) {
        ColumnExtractor.extractFromProjections(columnSegments, statement.getProjections().getProjections(), containsSubQuery);
        ColumnExtractor.extractFromSelectStatementWithoutProjection(columnSegments, statement, containsSubQuery);
    }

    public static void extractFromSelectStatementWithoutProjection(Collection<ColumnSegment> columnSegments, SelectStatement statement, boolean containsSubQuery) {
        statement.getFrom().ifPresent(optional -> ColumnExtractor.extractFromTable(columnSegments, optional, containsSubQuery));
        statement.getWhere().ifPresent(optional -> ColumnExtractor.extractFromWhere(columnSegments, optional, containsSubQuery));
        statement.getGroupBy().ifPresent(optional -> ColumnExtractor.extractFromGroupBy(columnSegments, optional, containsSubQuery));
        statement.getHaving().ifPresent(optional -> ColumnExtractor.extractFromHaving(columnSegments, optional, containsSubQuery));
        statement.getOrderBy().ifPresent(optional -> ColumnExtractor.extractFromOrderBy(columnSegments, optional, containsSubQuery));
        statement.getCombine().ifPresent(optional -> ColumnExtractor.extractFromSelectStatement(columnSegments, optional.getLeft().getSelect(), containsSubQuery));
        statement.getCombine().ifPresent(optional -> ColumnExtractor.extractFromSelectStatement(columnSegments, optional.getRight().getSelect(), containsSubQuery));
    }

    public static void extractFromProjections(Collection<ColumnSegment> columnSegments, Collection<ProjectionSegment> projections, boolean containsSubQuery) {
        for (ProjectionSegment each : projections) {
            if (each instanceof ColumnProjectionSegment) {
                columnSegments.add(((ColumnProjectionSegment)each).getColumn());
            }
            if (each instanceof AggregationProjectionSegment) {
                for (ExpressionSegment parameter : ((AggregationProjectionSegment)each).getParameters()) {
                    columnSegments.addAll(ExpressionExtractor.extractColumns(parameter, containsSubQuery));
                }
            }
            if (each instanceof DatetimeProjectionSegment) {
                columnSegments.addAll(ExpressionExtractor.extractColumns(((DatetimeProjectionSegment)each).getLeft(), containsSubQuery));
                columnSegments.addAll(ExpressionExtractor.extractColumns(((DatetimeProjectionSegment)each).getRight(), containsSubQuery));
            }
            if (each instanceof ExpressionProjectionSegment) {
                columnSegments.addAll(ExpressionExtractor.extractColumns(((ExpressionProjectionSegment)each).getExpr(), containsSubQuery));
            }
            if (each instanceof IntervalExpressionProjection) {
                columnSegments.addAll(ExpressionExtractor.extractColumns(((IntervalExpressionProjection)each).getLeft(), containsSubQuery));
                columnSegments.addAll(ExpressionExtractor.extractColumns(((IntervalExpressionProjection)each).getRight(), containsSubQuery));
                columnSegments.addAll(ExpressionExtractor.extractColumns(((IntervalExpressionProjection)each).getMinus(), containsSubQuery));
            }
            if (!(each instanceof SubqueryProjectionSegment) || !containsSubQuery) continue;
            ColumnExtractor.extractFromSelectStatement(columnSegments, ((SubqueryProjectionSegment)each).getSubquery().getSelect(), true);
        }
    }

    private static void extractFromTable(Collection<ColumnSegment> columnSegments, TableSegment tableSegment, boolean containsSubQuery) {
        if (tableSegment instanceof CollectionTableSegment) {
            columnSegments.addAll(ExpressionExtractor.extractColumns(((CollectionTableSegment)tableSegment).getExpressionSegment(), containsSubQuery));
        }
        if (tableSegment instanceof JoinTableSegment) {
            ColumnExtractor.extractFromTable(columnSegments, ((JoinTableSegment)tableSegment).getLeft(), containsSubQuery);
            ColumnExtractor.extractFromTable(columnSegments, ((JoinTableSegment)tableSegment).getRight(), containsSubQuery);
            columnSegments.addAll(ExpressionExtractor.extractColumns(((JoinTableSegment)tableSegment).getCondition(), containsSubQuery));
            columnSegments.addAll(((JoinTableSegment)tableSegment).getUsing());
            columnSegments.addAll(((JoinTableSegment)tableSegment).getDerivedUsing());
        }
        if (tableSegment instanceof SubqueryTableSegment && containsSubQuery) {
            ColumnExtractor.extractFromSelectStatement(columnSegments, ((SubqueryTableSegment)tableSegment).getSubquery().getSelect(), true);
        }
        if (tableSegment instanceof CommonTableExpressionSegment && containsSubQuery) {
            ColumnExtractor.extractFromSelectStatement(columnSegments, ((CommonTableExpressionSegment)tableSegment).getSubquery().getSelect(), true);
        }
    }

    public static void extractFromWhere(Collection<ColumnSegment> columnSegments, WhereSegment whereSegment, boolean containsSubQuery) {
        columnSegments.addAll(ExpressionExtractor.extractColumns(whereSegment.getExpr(), containsSubQuery));
    }

    private static void extractFromGroupBy(Collection<ColumnSegment> columnSegments, GroupBySegment groupBySegment, boolean containsSubQuery) {
        for (OrderByItemSegment each : groupBySegment.getGroupByItems()) {
            if (each instanceof ColumnOrderByItemSegment) {
                columnSegments.add(((ColumnOrderByItemSegment)each).getColumn());
            }
            if (!(each instanceof ExpressionOrderByItemSegment)) continue;
            columnSegments.addAll(ExpressionExtractor.extractColumns(((ExpressionOrderByItemSegment)each).getExpr(), containsSubQuery));
        }
    }

    private static void extractFromHaving(Collection<ColumnSegment> columnSegments, HavingSegment havingSegment, boolean containsSubQuery) {
        columnSegments.addAll(ExpressionExtractor.extractColumns(havingSegment.getExpr(), containsSubQuery));
    }

    private static void extractFromOrderBy(Collection<ColumnSegment> columnSegments, OrderBySegment orderBySegment, boolean containsSubQuery) {
        for (OrderByItemSegment each : orderBySegment.getOrderByItems()) {
            if (each instanceof ColumnOrderByItemSegment) {
                columnSegments.add(((ColumnOrderByItemSegment)each).getColumn());
            }
            if (!(each instanceof ExpressionOrderByItemSegment)) continue;
            columnSegments.addAll(ExpressionExtractor.extractColumns(((ExpressionOrderByItemSegment)each).getExpr(), containsSubQuery));
        }
    }

    @Generated
    private ColumnExtractor() {
    }
}

