/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.from.impl;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.expression.ExpressionConverter;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.expression.impl.ColumnConverter;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.from.TableConverter;

public final class JoinTableConverter {
    public static Optional<SqlNode> convert(JoinTableSegment segment) {
        SqlNode left = TableConverter.convert(segment.getLeft()).orElseThrow(IllegalStateException::new);
        SqlNode right = TableConverter.convert(segment.getRight()).orElseThrow(IllegalStateException::new);
        Optional<SqlNode> condition = JoinTableConverter.convertJoinCondition(segment);
        SqlLiteral conditionType = JoinTableConverter.convertConditionType(segment);
        SqlLiteral joinType = JoinTableConverter.convertJoinType(segment);
        return Optional.of(new SqlJoin(SqlParserPos.ZERO, left, SqlLiteral.createBoolean((boolean)segment.isNatural(), (SqlParserPos)SqlParserPos.ZERO), joinType, right, conditionType, (SqlNode)condition.orElse(null)));
    }

    private static SqlLiteral convertJoinType(JoinTableSegment segment) {
        String joinTypeName = null == segment.getJoinType() ? JoinType.INNER.name() : segment.getJoinType();
        return JoinType.INNER.name().equals(joinTypeName) && !segment.isNatural() && null == segment.getCondition() && segment.getUsing().isEmpty() ? JoinType.COMMA.symbol(SqlParserPos.ZERO) : JoinType.valueOf((String)joinTypeName).symbol(SqlParserPos.ZERO);
    }

    private static SqlLiteral convertConditionType(JoinTableSegment segment) {
        if (!segment.getUsing().isEmpty()) {
            return JoinConditionType.USING.symbol(SqlParserPos.ZERO);
        }
        return null == segment.getCondition() ? JoinConditionType.NONE.symbol(SqlParserPos.ZERO) : JoinConditionType.ON.symbol(SqlParserPos.ZERO);
    }

    private static Optional<SqlNode> convertJoinCondition(JoinTableSegment segment) {
        if (null != segment.getCondition()) {
            return ExpressionConverter.convert(segment.getCondition());
        }
        if (segment.getUsing().isEmpty()) {
            return Optional.empty();
        }
        Collection sqlNodes = segment.getUsing().stream().map(ColumnConverter::convert).collect(Collectors.toList());
        return Optional.of(new SqlNodeList(sqlNodes, SqlParserPos.ZERO));
    }

    @Generated
    private JoinTableConverter() {
    }
}

