/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.checker.sql.schema;

import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.checker.SupportedSQLChecker;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.SchemaNotFoundException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.single.exception.DropNotEmptySchemaException;
import org.apache.shardingsphere.single.rule.SingleRule;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.schema.DropSchemaStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class SingleDropSchemaSupportedChecker
implements SupportedSQLChecker<SQLStatementContext, SingleRule> {
    public boolean isCheck(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext.getSqlStatement() instanceof DropSchemaStatement;
    }

    public void check(SingleRule rule, ShardingSphereDatabase database, ShardingSphereSchema currentSchema, SQLStatementContext sqlStatementContext) {
        DropSchemaStatement dropSchemaStatement = (DropSchemaStatement)sqlStatementContext.getSqlStatement();
        boolean containsCascade = dropSchemaStatement.isContainsCascade();
        for (IdentifierValue each : dropSchemaStatement.getSchemaNames()) {
            String schemaName = each.getValue();
            ShardingSphereSchema schema = database.getSchema(schemaName);
            ShardingSpherePreconditions.checkNotNull((Object)schema, () -> new SchemaNotFoundException(schemaName));
            ShardingSpherePreconditions.checkState((containsCascade || schema.getAllTables().isEmpty() ? 1 : 0) != 0, () -> new DropNotEmptySchemaException(schemaName));
        }
    }
}

