/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.sqlserver.visitor.statement;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.autogen.SQLServerStatementBaseVisitor;
import org.apache.shardingsphere.sql.parser.autogen.SQLServerStatementParser;
import org.apache.shardingsphere.sql.parser.statement.core.enums.AggregationType;
import org.apache.shardingsphere.sql.parser.statement.core.enums.JoinType;
import org.apache.shardingsphere.sql.parser.statement.core.enums.OrderDirection;
import org.apache.shardingsphere.sql.parser.statement.core.enums.ParameterMarkerType;
import org.apache.shardingsphere.sql.parser.statement.core.enums.ScanUnit;
import org.apache.shardingsphere.sql.parser.statement.core.enums.StatisticsDimension;
import org.apache.shardingsphere.sql.parser.statement.core.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.VariableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.routine.FunctionNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.ColumnAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.exec.ExecSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionWithParamsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.KeyValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ListExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.NotExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex.CommonTableExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.hint.OptionHintSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.hint.TableHintLimitedSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.hint.WithTableHintSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.AggregationDistinctProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.json.JsonNullClauseSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.merge.MergeWhenAndThenSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.limit.NumberLiteralLimitValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.limit.ParameterMarkerLimitValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.rownum.NumberLiteralRowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.rownum.ParameterMarkerRowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.rownum.RowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.top.TopProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.HavingSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.sample.SampleOptionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.sample.SampleStrategy;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.statistics.StatisticsOptionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.statistics.StatisticsStrategySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DataTypeLengthSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OutputSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.ParameterMarkerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.WithSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.DeleteMultiTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.FunctionTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.MergeStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.statement.core.util.SQLUtils;
import org.apache.shardingsphere.sql.parser.statement.core.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.keyword.KeywordValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.BooleanLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.NullLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.NumberLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.OtherLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.StringLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.parametermarker.ParameterMarkerValue;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.statistics.SQLServerUpdateStatisticsStatement;

public abstract class SQLServerStatementVisitor
extends SQLServerStatementBaseVisitor<ASTNode> {
    private final DatabaseType databaseType;
    private final Collection<ParameterMarkerSegment> parameterMarkerSegments = new LinkedList<ParameterMarkerSegment>();

    @Override
    public final ASTNode visitParameterMarker(SQLServerStatementParser.ParameterMarkerContext ctx) {
        return new ParameterMarkerValue(Integer.valueOf(this.parameterMarkerSegments.size()), ParameterMarkerType.QUESTION);
    }

    @Override
    public final ASTNode visitLiterals(SQLServerStatementParser.LiteralsContext ctx) {
        if (null != ctx.stringLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.stringLiterals());
        }
        if (null != ctx.numberLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.numberLiterals());
        }
        if (null != ctx.hexadecimalLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.hexadecimalLiterals());
        }
        if (null != ctx.bitValueLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.bitValueLiterals());
        }
        if (null != ctx.booleanLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.booleanLiterals());
        }
        if (null != ctx.nullValueLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.nullValueLiterals());
        }
        throw new IllegalStateException("Literals must have string, number, dateTime, hex, bit, boolean or null.");
    }

    @Override
    public final ASTNode visitStringLiterals(SQLServerStatementParser.StringLiteralsContext ctx) {
        if (null != ctx.STRING_()) {
            return new StringLiteralValue(ctx.getText());
        }
        return new StringLiteralValue(ctx.getText().substring(1));
    }

    @Override
    public final ASTNode visitNumberLiterals(SQLServerStatementParser.NumberLiteralsContext ctx) {
        return new NumberLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitHexadecimalLiterals(SQLServerStatementParser.HexadecimalLiteralsContext ctx) {
        return new OtherLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitBitValueLiterals(SQLServerStatementParser.BitValueLiteralsContext ctx) {
        return new OtherLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitBooleanLiterals(SQLServerStatementParser.BooleanLiteralsContext ctx) {
        return new BooleanLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitNullValueLiterals(SQLServerStatementParser.NullValueLiteralsContext ctx) {
        return new NullLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitIdentifier(SQLServerStatementParser.IdentifierContext ctx) {
        return null == ctx.regularIdentifier() ? (ASTNode)this.visit((ParseTree)ctx.delimitedIdentifier()) : (ASTNode)this.visit((ParseTree)ctx.regularIdentifier());
    }

    @Override
    public final ASTNode visitVariableName(SQLServerStatementParser.VariableNameContext ctx) {
        return new VariableSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ((IdentifierValue)this.visit((ParseTree)ctx.identifier())).getValue());
    }

    @Override
    public final ASTNode visitRegularIdentifier(SQLServerStatementParser.RegularIdentifierContext ctx) {
        SQLServerStatementParser.UnreservedWordContext unreservedWord = ctx.unreservedWord();
        return null == unreservedWord ? new IdentifierValue(ctx.getText()) : (IdentifierValue)this.visit((ParseTree)unreservedWord);
    }

    @Override
    public final ASTNode visitDelimitedIdentifier(SQLServerStatementParser.DelimitedIdentifierContext ctx) {
        return new IdentifierValue(ctx.getText());
    }

    @Override
    public final ASTNode visitUnreservedWord(SQLServerStatementParser.UnreservedWordContext ctx) {
        return new IdentifierValue(ctx.getText());
    }

    @Override
    public final ASTNode visitSchemaName(SQLServerStatementParser.SchemaNameContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.identifier());
    }

    @Override
    public final ASTNode visitTableName(SQLServerStatementParser.TableNameContext ctx) {
        SimpleTableSegment result = new SimpleTableSegment(new TableNameSegment(ctx.name().getStart().getStartIndex(), ctx.name().getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name())));
        SQLServerStatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            OwnerSegment ownerSegment = new OwnerSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)owner.identifier()));
            if (null != ctx.databaseName()) {
                SQLServerStatementParser.DatabaseNameContext databaseName = ctx.databaseName();
                OwnerSegment databaseSegment = new OwnerSegment(databaseName.getStart().getStartIndex(), databaseName.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)databaseName.identifier()));
                ownerSegment.setOwner(databaseSegment);
                this.setLinkedServerForDatabase(databaseSegment, ctx);
            }
            result.setOwner(ownerSegment);
        } else if (null != ctx.databaseName()) {
            SQLServerStatementParser.DatabaseNameContext databaseName = ctx.databaseName();
            result.setOwner(new OwnerSegment(databaseName.getStart().getStartIndex(), databaseName.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)databaseName.identifier())));
        }
        return result;
    }

    private void setLinkedServerForDatabase(OwnerSegment databaseSegment, SQLServerStatementParser.TableNameContext ctx) {
        if (null != ctx.linkedServerName()) {
            SQLServerStatementParser.LinkedServerNameContext linkedServerName = ctx.linkedServerName();
            OwnerSegment linkedServerSegment = new OwnerSegment(linkedServerName.getStart().getStartIndex(), linkedServerName.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)linkedServerName.identifier()));
            databaseSegment.setOwner(linkedServerSegment);
        }
    }

    @Override
    public final ASTNode visitColumnName(SQLServerStatementParser.ColumnNameContext ctx) {
        ColumnSegment result = null != ctx.name() ? new ColumnSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name())) : new ColumnSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.scriptVariableName()));
        SQLServerStatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            OwnerSegment ownerSegment = new OwnerSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)owner.identifier()));
            if (null != ctx.databaseName()) {
                ownerSegment.setOwner(new OwnerSegment(ctx.databaseName().getStart().getStartIndex(), ctx.databaseName().getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.databaseName().identifier())));
            }
            result.setOwner(ownerSegment);
        }
        return result;
    }

    @Override
    public ASTNode visitScriptVariableName(SQLServerStatementParser.ScriptVariableNameContext ctx) {
        return new IdentifierValue(ctx.getText());
    }

    @Override
    public final ASTNode visitIndexName(SQLServerStatementParser.IndexNameContext ctx) {
        IndexNameSegment indexName = new IndexNameSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
        return new IndexSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), indexName);
    }

    @Override
    public final ASTNode visitConstraintName(SQLServerStatementParser.ConstraintNameContext ctx) {
        return new ConstraintSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public final ASTNode visitTableNames(SQLServerStatementParser.TableNamesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (SQLServerStatementParser.TableNameContext each : ctx.tableName()) {
            result.getValue().add((SimpleTableSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public final ASTNode visitColumnNames(SQLServerStatementParser.ColumnNamesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (SQLServerStatementParser.ColumnNameContext each : ctx.columnName()) {
            result.getValue().add((ColumnSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitColumnNamesWithSort(SQLServerStatementParser.ColumnNamesWithSortContext ctx) {
        CollectionValue result = new CollectionValue();
        for (SQLServerStatementParser.ColumnNameWithSortContext each : ctx.columnNameWithSort()) {
            result.getValue().add((ColumnSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public final ASTNode visitExpr(SQLServerStatementParser.ExprContext ctx) {
        if (null != ctx.booleanPrimary()) {
            return (ASTNode)this.visit((ParseTree)ctx.booleanPrimary());
        }
        if (null != ctx.LP_()) {
            return (ASTNode)this.visit((ParseTree)ctx.expr(0));
        }
        if (null != ctx.andOperator()) {
            return this.createBinaryOperationExpression(ctx, ctx.andOperator().getText());
        }
        if (null != ctx.orOperator()) {
            return this.createBinaryOperationExpression(ctx, ctx.orOperator().getText());
        }
        if (null != ctx.distinctFrom()) {
            return this.createBinaryOperationExpression(ctx, ctx.distinctFrom().getText());
        }
        if (null != ctx.AT() && null != ctx.TIME() && null != ctx.ZONE()) {
            ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.expr(0));
            ExpressionSegment right = (ExpressionSegment)this.visit((ParseTree)ctx.expr(1));
            String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
            return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, "AT TIME ZONE", text);
        }
        return new NotExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (ExpressionSegment)this.visit((ParseTree)ctx.expr(0)), Boolean.valueOf(false));
    }

    private ASTNode createBinaryOperationExpression(SQLServerStatementParser.ExprContext ctx, String operator) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.expr(0));
        ExpressionSegment right = (ExpressionSegment)this.visit((ParseTree)ctx.expr(1));
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
    }

    @Override
    public final ASTNode visitBooleanPrimary(SQLServerStatementParser.BooleanPrimaryContext ctx) {
        if (null != ctx.IS()) {
            String rightText = "";
            if (null != ctx.NOT()) {
                rightText = rightText + ctx.start.getInputStream().getText(new Interval(ctx.NOT().getSymbol().getStartIndex(), ctx.NOT().getSymbol().getStopIndex())) + " ";
            }
            Token operatorToken = null;
            if (null != ctx.NULL()) {
                operatorToken = ctx.NULL().getSymbol();
            }
            if (null != ctx.TRUE()) {
                operatorToken = ctx.TRUE().getSymbol();
            }
            if (null != ctx.FALSE()) {
                operatorToken = ctx.FALSE().getSymbol();
            }
            int startIndex = null == operatorToken ? ctx.IS().getSymbol().getStopIndex() + 2 : operatorToken.getStartIndex();
            rightText = rightText + ctx.start.getInputStream().getText(new Interval(startIndex, ctx.stop.getStopIndex()));
            LiteralExpressionSegment right = new LiteralExpressionSegment(ctx.IS().getSymbol().getStopIndex() + 2, ctx.stop.getStopIndex(), (Object)rightText);
            String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
            ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.booleanPrimary());
            String operator = "IS";
            return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, (ExpressionSegment)right, operator, text);
        }
        if (null != ctx.comparisonOperator() || null != ctx.SAFE_EQ_()) {
            return this.createCompareSegment(ctx);
        }
        return (ASTNode)this.visit((ParseTree)ctx.predicate());
    }

    private ASTNode createCompareSegment(SQLServerStatementParser.BooleanPrimaryContext ctx) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.booleanPrimary());
        ExpressionSegment right = null != ctx.predicate() ? (ExpressionSegment)this.visit((ParseTree)ctx.predicate()) : (ExpressionSegment)this.visit((ParseTree)ctx.subquery());
        String operator = null == ctx.SAFE_EQ_() ? ctx.comparisonOperator().getText() : ctx.SAFE_EQ_().getText();
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
    }

    @Override
    public final ASTNode visitPredicate(SQLServerStatementParser.PredicateContext ctx) {
        if (null != ctx.IN()) {
            return this.createInSegment(ctx);
        }
        if (null != ctx.BETWEEN()) {
            return this.createBetweenSegment(ctx);
        }
        if (null != ctx.LIKE()) {
            return this.createBinaryOperationExpressionFromLike(ctx);
        }
        return (ASTNode)this.visit((ParseTree)ctx.bitExpr(0));
    }

    private BinaryOperationExpression createBinaryOperationExpressionFromLike(SQLServerStatementParser.PredicateContext ctx) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(0));
        ListExpression right = new ListExpression(ctx.simpleExpr((int)0).start.getStartIndex(), ctx.simpleExpr().get((int)(ctx.simpleExpr().size() - 1)).stop.getStopIndex());
        for (SQLServerStatementParser.SimpleExprContext each : ctx.simpleExpr()) {
            right.getItems().add((ExpressionSegment)this.visit((ParseTree)each));
        }
        String operator = null == ctx.NOT() ? "LIKE" : "NOT LIKE";
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, (ExpressionSegment)right, operator, text);
    }

    private InExpression createInSegment(SQLServerStatementParser.PredicateContext ctx) {
        ListExpression right;
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(0));
        if (null == ctx.subquery()) {
            ListExpression listExpression = new ListExpression(ctx.LP_().getSymbol().getStartIndex(), ctx.RP_().getSymbol().getStopIndex());
            for (SQLServerStatementParser.ExprContext each : ctx.expr()) {
                listExpression.getItems().add((ExpressionSegment)this.visit((ParseTree)each));
            }
            right = listExpression;
        } else {
            right = new SubqueryExpressionSegment(new SubquerySegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), (SelectStatement)this.visit((ParseTree)ctx.subquery()), this.getOriginalText(ctx.subquery())));
        }
        boolean not = null != ctx.NOT();
        return new InExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, (ExpressionSegment)right, not);
    }

    private BetweenExpression createBetweenSegment(SQLServerStatementParser.PredicateContext ctx) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(0));
        ExpressionSegment between = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(1));
        ExpressionSegment and = (ExpressionSegment)this.visit((ParseTree)ctx.predicate());
        boolean not = null != ctx.NOT();
        return new BetweenExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, between, and, not);
    }

    @Override
    public final ASTNode visitBitExpr(SQLServerStatementParser.BitExprContext ctx) {
        if (null != ctx.simpleExpr()) {
            return this.createExpressionSegment((ASTNode)this.visit((ParseTree)ctx.simpleExpr()), ctx);
        }
        ExpressionSegment left = (ExpressionSegment)this.visit(ctx.getChild(0));
        ExpressionSegment right = (ExpressionSegment)this.visit(ctx.getChild(2));
        String operator = ctx.getChild(1).getText();
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
    }

    private ASTNode createExpressionSegment(ASTNode astNode, ParserRuleContext context) {
        if (astNode instanceof StringLiteralValue) {
            return new LiteralExpressionSegment(context.start.getStartIndex(), context.stop.getStopIndex(), (Object)((StringLiteralValue)astNode).getValue());
        }
        if (astNode instanceof NumberLiteralValue) {
            return new LiteralExpressionSegment(context.start.getStartIndex(), context.stop.getStopIndex(), (Object)((NumberLiteralValue)astNode).getValue());
        }
        if (astNode instanceof BooleanLiteralValue) {
            return new LiteralExpressionSegment(context.start.getStartIndex(), context.stop.getStopIndex(), (Object)((BooleanLiteralValue)astNode).getValue());
        }
        if (astNode instanceof ParameterMarkerValue) {
            ParameterMarkerValue parameterMarker = (ParameterMarkerValue)astNode;
            ParameterMarkerExpressionSegment segment = new ParameterMarkerExpressionSegment(context.start.getStartIndex(), context.stop.getStopIndex(), parameterMarker.getValue().intValue(), parameterMarker.getType());
            this.parameterMarkerSegments.add((ParameterMarkerSegment)segment);
            return segment;
        }
        if (astNode instanceof SubquerySegment) {
            return new SubqueryExpressionSegment((SubquerySegment)astNode);
        }
        if (astNode instanceof OtherLiteralValue) {
            return new CommonExpressionSegment(context.getStart().getStartIndex(), context.getStop().getStopIndex(), context.getText());
        }
        return astNode;
    }

    @Override
    public final ASTNode visitSimpleExpr(SQLServerStatementParser.SimpleExprContext ctx) {
        int startIndex = ctx.getStart().getStartIndex();
        int stopIndex = ctx.getStop().getStopIndex();
        if (null != ctx.subquery()) {
            return new SubquerySegment(startIndex, stopIndex, (SelectStatement)this.visit((ParseTree)ctx.subquery()), this.getOriginalText(ctx.subquery()));
        }
        if (null != ctx.parameterMarker()) {
            ParameterMarkerValue parameterMarker = (ParameterMarkerValue)this.visit((ParseTree)ctx.parameterMarker());
            ParameterMarkerExpressionSegment result = new ParameterMarkerExpressionSegment(startIndex, stopIndex, parameterMarker.getValue().intValue(), parameterMarker.getType());
            this.parameterMarkerSegments.add((ParameterMarkerSegment)result);
            return result;
        }
        if (null != ctx.literals()) {
            return SQLUtils.createLiteralExpression((ASTNode)((ASTNode)this.visit((ParseTree)ctx.literals())), (int)startIndex, (int)stopIndex, (String)ctx.literals().start.getInputStream().getText(new Interval(startIndex, stopIndex)));
        }
        if (null != ctx.functionCall()) {
            return (ASTNode)this.visit((ParseTree)ctx.functionCall());
        }
        if (null != ctx.columnName()) {
            return (ASTNode)this.visit((ParseTree)ctx.columnName());
        }
        if (null != ctx.xmlMethodCall()) {
            return (ASTNode)this.visit((ParseTree)ctx.xmlMethodCall());
        }
        if (null != ctx.LP_() && 1 == ctx.expr().size()) {
            return (ASTNode)this.visit((ParseTree)ctx.expr(0));
        }
        return this.visitRemainSimpleExpr(ctx);
    }

    private ASTNode visitRemainSimpleExpr(SQLServerStatementParser.SimpleExprContext ctx) {
        if (null != ctx.caseExpression()) {
            this.visit((ParseTree)ctx.caseExpression());
            String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
            return new OtherLiteralValue(text);
        }
        for (SQLServerStatementParser.ExprContext exprContext : ctx.expr()) {
            this.visit((ParseTree)exprContext);
        }
        for (SQLServerStatementParser.SimpleExprContext simpleExprContext : ctx.simpleExpr()) {
            this.visit((ParseTree)simpleExprContext);
        }
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), text);
    }

    @Override
    public final ASTNode visitFunctionCall(SQLServerStatementParser.FunctionCallContext ctx) {
        if (null != ctx.aggregationFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.aggregationFunction());
        }
        if (null != ctx.specialFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.specialFunction());
        }
        if (null != ctx.regularFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.regularFunction());
        }
        throw new IllegalStateException("FunctionCallContext must have aggregationFunction, regularFunction or specialFunction.");
    }

    @Override
    public final ASTNode visitAggregationFunction(SQLServerStatementParser.AggregationFunctionContext ctx) {
        String aggregationType = ctx.aggregationFunctionName().getText();
        if (AggregationType.isAggregationType((String)aggregationType)) {
            return this.createAggregationSegment(ctx, aggregationType);
        }
        FunctionSegment functionSegment = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), aggregationType, this.getOriginalText(ctx));
        if (null != ctx.expr()) {
            for (SQLServerStatementParser.ExprContext each : ctx.expr()) {
                functionSegment.getParameters().add((ExpressionSegment)this.visit((ParseTree)each));
            }
        }
        return functionSegment;
    }

    private ASTNode createAggregationSegment(SQLServerStatementParser.AggregationFunctionContext ctx, String aggregationType) {
        AggregationType type = AggregationType.valueOf((String)aggregationType.toUpperCase());
        if (null != ctx.distinct()) {
            AggregationDistinctProjectionSegment result = new AggregationDistinctProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), type, this.getOriginalText(ctx), this.getDistinctExpression(ctx));
            result.getParameters().addAll(this.getExpressions(ctx));
            return result;
        }
        AggregationProjectionSegment result = new AggregationProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), type, this.getOriginalText(ctx));
        result.getParameters().addAll(this.getExpressions(ctx));
        return result;
    }

    private Collection<ExpressionSegment> getExpressions(SQLServerStatementParser.AggregationFunctionContext ctx) {
        if (null == ctx.expr()) {
            return Collections.emptyList();
        }
        LinkedList<ExpressionSegment> result = new LinkedList<ExpressionSegment>();
        for (SQLServerStatementParser.ExprContext each : ctx.expr()) {
            result.add((ExpressionSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    private String getDistinctExpression(SQLServerStatementParser.AggregationFunctionContext ctx) {
        StringBuilder result = new StringBuilder();
        for (int i = 3; i < ctx.getChildCount() - 1; ++i) {
            result.append(ctx.getChild(i).getText());
        }
        return result.toString();
    }

    @Override
    public final ASTNode visitSpecialFunction(SQLServerStatementParser.SpecialFunctionContext ctx) {
        if (null != ctx.conversionFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.conversionFunction());
        }
        if (null != ctx.charFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.charFunction());
        }
        if (null != ctx.openJsonFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.openJsonFunction());
        }
        if (null != ctx.openRowSetFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.openRowSetFunction());
        }
        if (null != ctx.jsonFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.jsonFunction());
        }
        if (null != ctx.windowFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.windowFunction());
        }
        if (null != ctx.approxFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.approxFunction());
        }
        if (null != ctx.graphFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.graphFunction());
        }
        if (null != ctx.trimFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.trimFunction());
        }
        if (null != ctx.changeTableFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.changeTableFunction());
        }
        if (null != ctx.aiFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.aiFunction());
        }
        if (null != ctx.freetextTableFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.freetextTableFunction());
        }
        if (null != ctx.currentUserFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.currentUserFunction());
        }
        if (null != ctx.vectorSearchFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.vectorSearchFunction());
        }
        return new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getChild(0).getChild(0).getText(), this.getOriginalText(ctx));
    }

    @Override
    public ASTNode visitVectorSearchFunction(SQLServerStatementParser.VectorSearchFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.VECTOR_SEARCH().getText(), this.getOriginalText(ctx));
        SQLServerStatementParser.VectorSearchParametersContext params = ctx.vectorSearchParameters();
        if (null != params.vectorSearchTable()) {
            String tableText = params.vectorSearchTable().getText();
            result.getParameters().add(new LiteralExpressionSegment(params.vectorSearchTable().getStart().getStartIndex(), params.vectorSearchTable().getStop().getStopIndex(), (Object)tableText));
        }
        if (null != params.columnName()) {
            String columnText = params.columnName().getText();
            result.getParameters().add(new LiteralExpressionSegment(params.columnName().getStart().getStartIndex(), params.columnName().getStop().getStopIndex(), (Object)columnText));
        }
        if (null != params.expr() && !params.expr().isEmpty()) {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)params.expr(0)));
        }
        if (null != params.vectorSearchMetric() && null != params.vectorSearchMetric().stringLiterals()) {
            String metricText = params.vectorSearchMetric().stringLiterals().getText();
            result.getParameters().add(new LiteralExpressionSegment(params.vectorSearchMetric().stringLiterals().getStart().getStartIndex(), params.vectorSearchMetric().stringLiterals().getStop().getStopIndex(), (Object)metricText));
        }
        if (null != params.expr() && params.expr().size() > 1) {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)params.expr(1)));
        }
        return result;
    }

    @Override
    public ASTNode visitCurrentUserFunction(SQLServerStatementParser.CurrentUserFunctionContext ctx) {
        return new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.CURRENT_USER().getText(), this.getOriginalText(ctx));
    }

    @Override
    public ASTNode visitFreetextTableFunction(SQLServerStatementParser.FreetextTableFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.FREETEXTTABLE().getText(), this.getOriginalText(ctx));
        for (SQLServerStatementParser.ExprContext each : ctx.expr()) {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitAiFunction(SQLServerStatementParser.AiFunctionContext ctx) {
        if (null != ctx.aiGenerateEmbeddingsFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.aiGenerateEmbeddingsFunction());
        }
        return new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getChild(0).getChild(0).getText(), this.getOriginalText(ctx));
    }

    @Override
    public ASTNode visitAiGenerateEmbeddingsFunction(SQLServerStatementParser.AiGenerateEmbeddingsFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.AI_GENERATE_EMBEDDINGS().getText(), this.getOriginalText(ctx));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr(0)));
        result.getParameters().add(new LiteralExpressionSegment(ctx.identifier().getStart().getStartIndex(), ctx.identifier().getStop().getStopIndex(), (Object)ctx.identifier().getText()));
        if (ctx.expr().size() > 1) {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr(1)));
        }
        return result;
    }

    @Override
    public ASTNode visitChangeTableFunction(SQLServerStatementParser.ChangeTableFunctionContext ctx) {
        return new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.CHANGETABLE().getText(), this.getOriginalText(ctx));
    }

    @Override
    public ASTNode visitXmlMethodCall(SQLServerStatementParser.XmlMethodCallContext ctx) {
        String fullMethodName = null == ctx.alias() ? ctx.columnName().getText() + "." + ctx.xmlMethodName().getText() : ctx.alias().getText() + "." + ctx.columnName().getText() + "." + ctx.xmlMethodName().getText();
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), fullMethodName, this.getOriginalText(ctx));
        if (null == ctx.alias()) {
            OwnerSegment owner = new OwnerSegment(ctx.columnName().getStart().getStartIndex(), ctx.columnName().getStop().getStopIndex(), new IdentifierValue(ctx.columnName().getText()));
            result.setOwner(owner);
        } else {
            String ownerName = ctx.alias().getText() + "." + ctx.columnName().getText();
            OwnerSegment owner = new OwnerSegment(ctx.alias().getStart().getStartIndex(), ctx.columnName().getStop().getStopIndex(), new IdentifierValue(ownerName));
            result.setOwner(owner);
        }
        if (null != ctx.expr()) {
            for (SQLServerStatementParser.ExprContext each : ctx.expr()) {
                result.getParameters().add((ExpressionSegment)this.visit((ParseTree)each));
            }
        }
        return result;
    }

    private ASTNode getFunctionSegment(int startIndex, int stopIndex, String functionName, String text, List<SQLServerStatementParser.ExprContext> exprList) {
        FunctionSegment result = new FunctionSegment(startIndex, stopIndex, functionName, text);
        if (null != exprList) {
            for (SQLServerStatementParser.ExprContext each : exprList) {
                result.getParameters().add((ExpressionSegment)this.visit((ParseTree)each));
            }
        }
        return result;
    }

    @Override
    public ASTNode visitTrimFunction(SQLServerStatementParser.TrimFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.TRIM().getText(), this.getOriginalText(ctx));
        if (null != ctx.BOTH()) {
            result.getParameters().add(new LiteralExpressionSegment(ctx.BOTH().getSymbol().getStartIndex(), ctx.BOTH().getSymbol().getStopIndex(), (Object)new OtherLiteralValue(ctx.BOTH().getSymbol().getText()).getValue()));
        }
        if (null != ctx.TRAILING()) {
            result.getParameters().add(new LiteralExpressionSegment(ctx.TRAILING().getSymbol().getStartIndex(), ctx.TRAILING().getSymbol().getStopIndex(), (Object)new OtherLiteralValue(ctx.TRAILING().getSymbol().getText()).getValue()));
        }
        if (null != ctx.LEADING()) {
            result.getParameters().add(new LiteralExpressionSegment(ctx.LEADING().getSymbol().getStartIndex(), ctx.LEADING().getSymbol().getStopIndex(), (Object)new OtherLiteralValue(ctx.LEADING().getSymbol().getText()).getValue()));
        }
        for (SQLServerStatementParser.ExprContext each : ctx.expr()) {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitGraphFunction(SQLServerStatementParser.GraphFunctionContext ctx) {
        if (null != ctx.graphAggFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.graphAggFunction());
        }
        return new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getChild(0).getChild(0).getText(), this.getOriginalText(ctx));
    }

    @Override
    public ASTNode visitGraphAggFunction(SQLServerStatementParser.GraphAggFunctionContext ctx) {
        return this.getFunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.graphAggFunctionName().getText(), this.getOriginalText(ctx), ctx.expr());
    }

    @Override
    public final ASTNode visitApproxFunction(SQLServerStatementParser.ApproxFunctionContext ctx) {
        return this.getFunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.funcName.getText(), this.getOriginalText(ctx), ctx.expr());
    }

    @Override
    public final ASTNode visitConversionFunction(SQLServerStatementParser.ConversionFunctionContext ctx) {
        if (null != ctx.castFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.castFunction());
        }
        if (null != ctx.convertFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.convertFunction());
        }
        if (null != ctx.parseFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.parseFunction());
        }
        if (null != ctx.tryParseFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.tryParseFunction());
        }
        return new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getChild(0).getChild(0).getText(), this.getOriginalText(ctx));
    }

    @Override
    public ASTNode visitParseFunction(SQLServerStatementParser.ParseFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.PARSE().getText(), this.getOriginalText(ctx));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr(0)));
        result.getParameters().add((DataTypeSegment)this.visit((ParseTree)ctx.dataType()));
        if (null != ctx.USING() && ctx.expr().size() > 1) {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr(1)));
        }
        return result;
    }

    @Override
    public ASTNode visitTryParseFunction(SQLServerStatementParser.TryParseFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.TRY_PARSE().getText(), this.getOriginalText(ctx));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr(0)));
        result.getParameters().add((DataTypeSegment)this.visit((ParseTree)ctx.dataType()));
        if (null != ctx.USING() && ctx.expr().size() > 1) {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr(1)));
        }
        return result;
    }

    @Override
    public final ASTNode visitWindowFunction(SQLServerStatementParser.WindowFunctionContext ctx) {
        if (null != ctx.lagLeadFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.lagLeadFunction());
        }
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.funcName.getText(), this.getOriginalText(ctx));
        if (null != ctx.NTILE() || null != ctx.FIRST_VALUE() || null != ctx.LAST_VALUE() || null != ctx.PERCENTILE_CONT() || null != ctx.PERCENTILE_DISC()) {
            result.getParameters().add((ExpressionSegment)this.visit(ctx.getChild(2)));
        }
        return result;
    }

    @Override
    public final ASTNode visitLagLeadFunction(SQLServerStatementParser.LagLeadFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.funcName.getText(), this.getOriginalText(ctx));
        Collection<ExpressionSegment> parameters = this.getLagLeadFunctionParameters(ctx);
        result.getParameters().addAll(parameters);
        return result;
    }

    private Collection<ExpressionSegment> getLagLeadFunctionParameters(SQLServerStatementParser.LagLeadFunctionContext ctx) {
        LinkedList<ExpressionSegment> result = new LinkedList<ExpressionSegment>();
        boolean insideParentheses = false;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            String childText = ctx.getChild(i).getText();
            if ("(".equals(childText)) {
                insideParentheses = true;
                continue;
            }
            if (")".equals(childText) && insideParentheses) break;
            if (!insideParentheses || !(ctx.getChild(i) instanceof SQLServerStatementParser.ExprContext)) continue;
            result.add((ExpressionSegment)this.visit(ctx.getChild(i)));
        }
        return result;
    }

    @Override
    public final ASTNode visitJsonFunction(SQLServerStatementParser.JsonFunctionContext ctx) {
        if (null != ctx.jsonArrayFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.jsonArrayFunction());
        }
        if (null != ctx.jsonObjectFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.jsonObjectFunction());
        }
        return new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText(), this.getOriginalText(ctx));
    }

    @Override
    public final ASTNode visitJsonArrayFunction(SQLServerStatementParser.JsonArrayFunctionContext ctx) {
        FunctionSegment result = (FunctionSegment)this.getFunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.JSON_ARRAY().getText(), this.getOriginalText(ctx), ctx.expr());
        if (null != ctx.jsonNullClause()) {
            result.getParameters().add(new LiteralExpressionSegment(ctx.jsonNullClause().start.getStartIndex(), ctx.jsonNullClause().stop.getStopIndex(), (Object)ctx.jsonNullClause().getText()));
        }
        return result;
    }

    @Override
    public final ASTNode visitJsonObjectFunction(SQLServerStatementParser.JsonObjectFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.JSON_OBJECT().getText(), this.getOriginalText(ctx));
        if (null != ctx.jsonKeyValue()) {
            for (SQLServerStatementParser.JsonKeyValueContext each : ctx.jsonKeyValue()) {
                result.getParameters().add((ExpressionSegment)this.visit((ParseTree)each));
            }
        }
        if (null != ctx.jsonNullClause()) {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.jsonNullClause()));
        }
        return result;
    }

    @Override
    public final ASTNode visitJsonNullClause(SQLServerStatementParser.JsonNullClauseContext ctx) {
        return new JsonNullClauseSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), this.getOriginalText(ctx));
    }

    @Override
    public final ASTNode visitJsonKeyValue(SQLServerStatementParser.JsonKeyValueContext ctx) {
        KeyValueSegment result = new KeyValueSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.getText());
        if (null != ctx.expr()) {
            result.setKey((ExpressionSegment)this.visit((ParseTree)ctx.expr(0)));
            result.setValue((ExpressionSegment)this.visit((ParseTree)ctx.expr(1)));
        }
        return result;
    }

    @Override
    public final ASTNode visitCastFunction(SQLServerStatementParser.CastFunctionContext ctx) {
        String functionName = null == ctx.CAST() ? ctx.TRY_CAST().getText() : ctx.CAST().getText();
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), functionName, this.getOriginalText(ctx));
        ASTNode exprSegment = (ASTNode)this.visit((ParseTree)ctx.expr());
        if (exprSegment instanceof ColumnSegment) {
            result.getParameters().add((ColumnSegment)exprSegment);
        } else if (exprSegment instanceof LiteralExpressionSegment) {
            result.getParameters().add((LiteralExpressionSegment)exprSegment);
        } else if (exprSegment instanceof FunctionSegment) {
            result.getParameters().add((FunctionSegment)exprSegment);
        }
        result.getParameters().add((DataTypeSegment)this.visit((ParseTree)ctx.dataType()));
        return result;
    }

    @Override
    public ASTNode visitConvertFunction(SQLServerStatementParser.ConvertFunctionContext ctx) {
        String functionName = null == ctx.CONVERT() ? ctx.TRY_CONVERT().getText() : ctx.CONVERT().getText();
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), functionName, this.getOriginalText(ctx));
        result.getParameters().add((DataTypeSegment)this.visit((ParseTree)ctx.dataType()));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr()));
        if (null != ctx.NUMBER_()) {
            result.getParameters().add(new LiteralExpressionSegment(ctx.NUMBER_().getSymbol().getStartIndex(), ctx.NUMBER_().getSymbol().getStopIndex(), (Object)ctx.NUMBER_().getText()));
        }
        return result;
    }

    @Override
    public final ASTNode visitCharFunction(SQLServerStatementParser.CharFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.CHAR().getText(), this.getOriginalText(ctx));
        if (null != ctx.expr()) {
            for (SQLServerStatementParser.ExprContext each : ctx.expr()) {
                result.getParameters().add((ExpressionSegment)this.visit((ParseTree)each));
            }
        }
        return result;
    }

    @Override
    public final ASTNode visitOpenJsonFunction(SQLServerStatementParser.OpenJsonFunctionContext ctx) {
        return this.getFunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.OPENJSON().getText(), this.getOriginalText(ctx), ctx.expr());
    }

    @Override
    public final ASTNode visitOpenRowSetFunction(SQLServerStatementParser.OpenRowSetFunctionContext ctx) {
        FunctionSegment result = (FunctionSegment)this.getFunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.OPENROWSET().getText(), this.getOriginalText(ctx), ctx.expr());
        if (null != ctx.tableName()) {
            result.getParameters().add(new LiteralExpressionSegment(ctx.tableName().getStart().getStartIndex(), ctx.tableName().getStop().getStopIndex(), (Object)ctx.tableName().getText()));
        }
        return result;
    }

    @Override
    public ASTNode visitOpenQueryFunction(SQLServerStatementParser.OpenQueryFunctionContext ctx) {
        return this.getFunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.OPENQUERY().getText(), this.getOriginalText(ctx), ctx.expr());
    }

    @Override
    public ASTNode visitOpenDatasourceFunction(SQLServerStatementParser.OpenDatasourceFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.OPENDATASOURCE().getText(), this.getOriginalText(ctx));
        for (SQLServerStatementParser.ExprContext each : ctx.expr()) {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)each));
        }
        if (null != ctx.tableName()) {
            result.getParameters().add(new LiteralExpressionSegment(ctx.tableName().getStart().getStartIndex(), ctx.tableName().getStop().getStopIndex(), (Object)ctx.tableName().getText()));
        }
        return result;
    }

    @Override
    public final ASTNode visitRegularFunction(SQLServerStatementParser.RegularFunctionContext ctx) {
        return this.getFunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.regularFunctionName().getText(), this.getOriginalText(ctx), ctx.expr());
    }

    @Override
    public final ASTNode visitDataTypeName(SQLServerStatementParser.DataTypeNameContext ctx) {
        return new KeywordValue(ctx.getText());
    }

    @Override
    public final ASTNode visitOrderByItem(SQLServerStatementParser.OrderByItemContext ctx) {
        OrderDirection orderDirection;
        OrderDirection orderDirection2 = orderDirection = null == ctx.DESC() ? OrderDirection.ASC : OrderDirection.DESC;
        if (null != ctx.columnName()) {
            ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
            return new ColumnOrderByItemSegment(column, orderDirection, null);
        }
        if (null != ctx.numberLiterals()) {
            return new IndexOrderByItemSegment(ctx.numberLiterals().getStart().getStartIndex(), ctx.numberLiterals().getStop().getStopIndex(), SQLUtils.getExactlyNumber((String)ctx.numberLiterals().getText(), (int)10).intValue(), orderDirection, null);
        }
        return new ExpressionOrderByItemSegment(ctx.expr().getStart().getStartIndex(), ctx.expr().getStop().getStopIndex(), this.getOriginalText(ctx.expr()), orderDirection, null, (ExpressionSegment)this.visit((ParseTree)ctx.expr()));
    }

    @Override
    public final ASTNode visitDataType(SQLServerStatementParser.DataTypeContext ctx) {
        DataTypeSegment result = new DataTypeSegment();
        result.setDataTypeName(((KeywordValue)this.visit((ParseTree)ctx.dataTypeName())).getValue());
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        if (null != ctx.dataTypeLength()) {
            DataTypeLengthSegment dataTypeLengthSegment = (DataTypeLengthSegment)this.visit((ParseTree)ctx.dataTypeLength());
            result.setDataLength(dataTypeLengthSegment);
        }
        return result;
    }

    @Override
    public final ASTNode visitDataTypeLength(SQLServerStatementParser.DataTypeLengthContext ctx) {
        DataTypeLengthSegment result = new DataTypeLengthSegment();
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStartIndex());
        List<TerminalNode> numbers = ctx.NUMBER_();
        if (numbers.size() == 1) {
            result.setPrecision(Integer.parseInt(numbers.get(0).getText()));
        }
        if (numbers.size() == 2) {
            result.setPrecision(Integer.parseInt(numbers.get(0).getText()));
            result.setScale(Integer.parseInt(numbers.get(1).getText()));
        }
        return result;
    }

    @Override
    public final ASTNode visitViewName(SQLServerStatementParser.ViewNameContext ctx) {
        SimpleTableSegment result = new SimpleTableSegment(new TableNameSegment(ctx.name().getStart().getStartIndex(), ctx.name().getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name())));
        SQLServerStatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            result.setOwner(new OwnerSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)owner.identifier())));
        }
        return result;
    }

    @Override
    public ASTNode visitSelect(SQLServerStatementParser.SelectContext ctx) {
        SelectStatement result = (SelectStatement)this.visit((ParseTree)ctx.aggregationClause());
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitAggregationClause(SQLServerStatementParser.AggregationClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.selectClause(0));
    }

    @Override
    public ASTNode visitSelectClause(SQLServerStatementParser.SelectClauseContext ctx) {
        SelectStatement result = new SelectStatement(this.databaseType);
        result.setProjections((ProjectionsSegment)this.visit((ParseTree)ctx.projections()));
        if (null != ctx.selectWithClause() && null != ctx.selectWithClause().cteClauseSet()) {
            Collection<CommonTableExpressionSegment> commonTableExpressionSegments = this.getCommonTableExpressionSegmentsUsingCteClauseSet(ctx.selectWithClause().cteClauseSet());
            WithSegment withSegment = new WithSegment(ctx.selectWithClause().start.getStartIndex(), ctx.selectWithClause().stop.getStopIndex(), commonTableExpressionSegments);
            result.setWith(withSegment);
        }
        if (null != ctx.duplicateSpecification()) {
            result.getProjections().setDistinctRow(this.isDistinct(ctx));
        }
        if (null != ctx.intoClause()) {
            result.setInto((TableSegment)this.visit((ParseTree)ctx.intoClause()));
        }
        if (null != ctx.fromClause()) {
            TableSegment tableSource = (TableSegment)this.visit((ParseTree)ctx.fromClause().tableReferences());
            result.setFrom(tableSource);
        }
        if (null != ctx.withTableHint()) {
            result.setWithTableHint((WithTableHintSegment)this.visit((ParseTree)ctx.withTableHint()));
        }
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        if (null != ctx.groupByClause()) {
            result.setGroupBy((GroupBySegment)this.visit((ParseTree)ctx.groupByClause()));
        }
        if (null != ctx.havingClause()) {
            result.setHaving((HavingSegment)this.visit((ParseTree)ctx.havingClause()));
        }
        if (null != ctx.orderByClause()) {
            result.setOrderBy(this.getOrderBySegment(ctx.orderByClause()));
            result.setLimit(this.getLimitSegment(ctx.orderByClause()));
        }
        return result;
    }

    private Collection<CommonTableExpressionSegment> getCommonTableExpressionSegmentsUsingCteClauseSet(SQLServerStatementParser.CteClauseSetContext ctx) {
        LinkedList<CommonTableExpressionSegment> result = new LinkedList<CommonTableExpressionSegment>();
        for (SQLServerStatementParser.CteClauseContext each : ctx.cteClause()) {
            SubquerySegment subquery = new SubquerySegment(each.subquery().aggregationClause().start.getStartIndex(), each.subquery().aggregationClause().stop.getStopIndex(), (SelectStatement)this.visit((ParseTree)each.subquery()), this.getOriginalText(each.subquery()));
            CommonTableExpressionSegment commonTableExpression = new CommonTableExpressionSegment(each.start.getStartIndex(), each.stop.getStopIndex(), (AliasSegment)this.visit((ParseTree)each.alias()), subquery);
            if (null != each.columnNames()) {
                SQLServerStatementParser.ColumnNamesContext columnNames = each.columnNames();
                CollectionValue columns = (CollectionValue)this.visit((ParseTree)columnNames);
                commonTableExpression.getColumns().addAll(columns.getValue());
            }
            result.add(commonTableExpression);
        }
        return result;
    }

    @Override
    public ASTNode visitHavingClause(SQLServerStatementParser.HavingClauseContext ctx) {
        ExpressionSegment expr = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
        return new HavingSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), expr);
    }

    private LimitSegment getLimitSegment(SQLServerStatementParser.OrderByClauseContext ctx) {
        ASTNode astNode;
        LimitSegment result = null;
        ParameterMarkerLimitValueSegment offset = null;
        ParameterMarkerLimitValueSegment rowCount = null;
        if (null != ctx.OFFSET()) {
            astNode = (ASTNode)this.visit((ParseTree)ctx.expr(0));
            if (astNode instanceof LiteralExpressionSegment && ((LiteralExpressionSegment)astNode).getLiterals() instanceof Number) {
                offset = new NumberLiteralLimitValueSegment(ctx.expr((int)0).start.getStartIndex(), ctx.expr((int)0).stop.getStopIndex(), Long.valueOf(((Number)((LiteralExpressionSegment)astNode).getLiterals()).longValue()));
            } else if (astNode instanceof ParameterMarkerExpressionSegment) {
                offset = new ParameterMarkerLimitValueSegment(ctx.expr((int)0).start.getStartIndex(), ctx.expr((int)0).stop.getStopIndex(), this.parameterMarkerSegments.size() - 1);
            }
        }
        if (null != ctx.FETCH()) {
            astNode = (ASTNode)this.visit((ParseTree)ctx.expr(1));
            if (astNode instanceof LiteralExpressionSegment && ((LiteralExpressionSegment)astNode).getLiterals() instanceof Number) {
                rowCount = new NumberLiteralLimitValueSegment(ctx.expr((int)1).start.getStartIndex(), ctx.expr((int)1).stop.getStopIndex(), Long.valueOf(((Number)((LiteralExpressionSegment)astNode).getLiterals()).longValue()));
            } else if (astNode instanceof ParameterMarkerExpressionSegment) {
                rowCount = new ParameterMarkerLimitValueSegment(ctx.expr((int)1).start.getStartIndex(), ctx.expr((int)1).stop.getStopIndex(), this.parameterMarkerSegments.size() - 1);
            }
        }
        if (null != offset) {
            result = new LimitSegment(ctx.OFFSET().getSymbol().getStartIndex(), ctx.stop.getStopIndex(), offset, rowCount);
        }
        return result;
    }

    private OrderBySegment getOrderBySegment(SQLServerStatementParser.OrderByClauseContext ctx) {
        LinkedList<OrderByItemSegment> items = new LinkedList<OrderByItemSegment>();
        int orderByStartIndex = ctx.start.getStartIndex();
        int orderByStopIndex = ctx.start.getStartIndex();
        for (SQLServerStatementParser.OrderByItemContext each : ctx.orderByItem()) {
            items.add((OrderByItemSegment)this.visit((ParseTree)each));
            orderByStopIndex = each.stop.getStopIndex();
        }
        return new OrderBySegment(orderByStartIndex, orderByStopIndex, items);
    }

    private boolean isDistinct(SQLServerStatementParser.SelectClauseContext ctx) {
        return ((BooleanLiteralValue)this.visit((ParseTree)ctx.duplicateSpecification())).getValue();
    }

    @Override
    public ASTNode visitProjections(SQLServerStatementParser.ProjectionsContext ctx) {
        LinkedList<ProjectionSegment> projections = new LinkedList<ProjectionSegment>();
        if (null != ctx.top()) {
            projections.add((ProjectionSegment)this.visit((ParseTree)ctx.top()));
        }
        for (SQLServerStatementParser.ProjectionContext each : ctx.projection()) {
            projections.add((ProjectionSegment)this.visit((ParseTree)each));
        }
        ProjectionsSegment result = new ProjectionsSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        result.getProjections().addAll(projections);
        return result;
    }

    @Override
    public ASTNode visitTableReferences(SQLServerStatementParser.TableReferencesContext ctx) {
        TableSegment result = (TableSegment)this.visit((ParseTree)ctx.tableReference(0));
        if (ctx.tableReference().size() > 1) {
            for (int i = 1; i < ctx.tableReference().size(); ++i) {
                result = this.generateJoinTableSourceFromTableReference(ctx.tableReference(i), result);
            }
        }
        return result;
    }

    private JoinTableSegment generateJoinTableSourceFromTableReference(SQLServerStatementParser.TableReferenceContext ctx, TableSegment tableSegment) {
        JoinTableSegment result = new JoinTableSegment();
        result.setStartIndex(tableSegment.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        result.setLeft(tableSegment);
        result.setRight((TableSegment)this.visit((ParseTree)ctx));
        result.setJoinType(JoinType.COMMA.name());
        return result;
    }

    @Override
    public ASTNode visitWhereClause(SQLServerStatementParser.WhereClauseContext ctx) {
        return new WhereSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ExpressionSegment)this.visit((ParseTree)ctx.expr()));
    }

    @Override
    public ASTNode visitGroupByClause(SQLServerStatementParser.GroupByClauseContext ctx) {
        LinkedList<OrderByItemSegment> items;
        block3: {
            block2: {
                items = new LinkedList<OrderByItemSegment>();
                if (ctx.groupByItem().isEmpty()) break block2;
                for (SQLServerStatementParser.GroupByItemContext each : ctx.groupByItem()) {
                    items.addAll(this.generateOrderByItemsFromGroupByItem(each));
                }
                break block3;
            }
            if (ctx.orderByItem().isEmpty()) break block3;
            for (SQLServerStatementParser.OrderByItemContext each : ctx.orderByItem()) {
                items.add((OrderByItemSegment)this.visit((ParseTree)each));
            }
        }
        return new GroupBySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), items);
    }

    private Collection<OrderByItemSegment> generateOrderByItemsFromGroupByItem(SQLServerStatementParser.GroupByItemContext ctx) {
        LinkedList<OrderByItemSegment> result = new LinkedList<OrderByItemSegment>();
        if (null != ctx.expr()) {
            OrderByItemSegment item = (OrderByItemSegment)this.extractValueFromGroupByItemExpression(ctx.expr());
            result.add(item);
        } else if (null != ctx.rollupCubeClause()) {
            result.addAll(this.generateOrderByItemSegmentsFromRollupCubeClause(ctx.rollupCubeClause()));
        } else {
            result.addAll(this.generateOrderByItemSegmentsFromGroupingSetsClause(ctx.groupingSetsClause()));
        }
        return result;
    }

    private ASTNode extractValueFromGroupByItemExpression(SQLServerStatementParser.ExprContext ctx) {
        ASTNode expression = (ASTNode)this.visit((ParseTree)ctx);
        if (expression instanceof ColumnSegment) {
            ColumnSegment column = (ColumnSegment)expression;
            return new ColumnOrderByItemSegment(column, OrderDirection.ASC, null);
        }
        if (expression instanceof LiteralExpressionSegment) {
            LiteralExpressionSegment literalExpression = (LiteralExpressionSegment)expression;
            return new IndexOrderByItemSegment(literalExpression.getStartIndex(), literalExpression.getStopIndex(), SQLUtils.getExactlyNumber((String)literalExpression.getLiterals().toString(), (int)10).intValue(), OrderDirection.ASC, null);
        }
        return new ExpressionOrderByItemSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), this.getOriginalText(ctx), OrderDirection.ASC, null, (ExpressionSegment)expression);
    }

    private Collection<OrderByItemSegment> generateOrderByItemSegmentsFromRollupCubeClause(SQLServerStatementParser.RollupCubeClauseContext ctx) {
        return new LinkedList<OrderByItemSegment>(this.generateOrderByItemSegmentsFromGroupingExprList(ctx.groupingExprList()));
    }

    private Collection<OrderByItemSegment> generateOrderByItemSegmentsFromGroupingSetsClause(SQLServerStatementParser.GroupingSetsClauseContext ctx) {
        LinkedList<OrderByItemSegment> result = new LinkedList<OrderByItemSegment>();
        if (null != ctx.rollupCubeClause()) {
            for (SQLServerStatementParser.RollupCubeClauseContext rollupCubeClauseContext : ctx.rollupCubeClause()) {
                result.addAll(this.generateOrderByItemSegmentsFromRollupCubeClause(rollupCubeClauseContext));
            }
        }
        if (null != ctx.groupingExprList()) {
            for (SQLServerStatementParser.GroupingExprListContext groupingExprListContext : ctx.groupingExprList()) {
                result.addAll(this.generateOrderByItemSegmentsFromGroupingExprList(groupingExprListContext));
            }
        }
        return result;
    }

    private Collection<OrderByItemSegment> generateOrderByItemSegmentsFromGroupingExprList(SQLServerStatementParser.GroupingExprListContext ctx) {
        LinkedList<OrderByItemSegment> result = new LinkedList<OrderByItemSegment>();
        for (SQLServerStatementParser.ExpressionListContext each : ctx.expressionList()) {
            result.addAll(this.generateOrderByItemSegmentsFromExpressionList(each));
        }
        return result;
    }

    private Collection<OrderByItemSegment> generateOrderByItemSegmentsFromExpressionList(SQLServerStatementParser.ExpressionListContext ctx) {
        LinkedList<OrderByItemSegment> result = new LinkedList<OrderByItemSegment>();
        if (null != ctx.expr()) {
            for (SQLServerStatementParser.ExprContext each : ctx.expr()) {
                result.add((OrderByItemSegment)this.extractValueFromGroupByItemExpression(each));
            }
        }
        return result;
    }

    protected String getOriginalText(ParserRuleContext ctx) {
        return ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
    }

    @Override
    public ASTNode visitInsert(SQLServerStatementParser.InsertContext ctx) {
        InsertStatement result = null != ctx.insertDefaultValue() ? (InsertStatement)this.visit((ParseTree)ctx.insertDefaultValue()) : (null != ctx.insertValuesClause() ? (InsertStatement)this.visit((ParseTree)ctx.insertValuesClause()) : (null != ctx.insertExecClause() ? (InsertStatement)this.visit((ParseTree)ctx.insertExecClause()) : (InsertStatement)this.visit((ParseTree)ctx.insertSelectClause())));
        if (null != ctx.withClause()) {
            result.setWith((WithSegment)this.visit((ParseTree)ctx.withClause()));
        }
        if (null != ctx.withTableHint()) {
            result.setWithTableHint((WithTableHintSegment)this.visit((ParseTree)ctx.withTableHint()));
        }
        if (null != ctx.tableName()) {
            result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        }
        if (null != ctx.rowSetFunction()) {
            result.setRowSetFunction((FunctionSegment)this.visit((ParseTree)ctx.rowSetFunction()));
        }
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitRowSetFunction(SQLServerStatementParser.RowSetFunctionContext ctx) {
        if (null != ctx.openRowSetFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.openRowSetFunction());
        }
        if (null != ctx.openQueryFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.openQueryFunction());
        }
        if (null != ctx.predictFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.predictFunction());
        }
        return (ASTNode)this.visit((ParseTree)ctx.openDatasourceFunction());
    }

    @Override
    public ASTNode visitPredictFunction(SQLServerStatementParser.PredictFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.PREDICT().getText(), this.getOriginalText(ctx));
        if (null != ctx.variableName()) {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.variableName()));
        } else if (null != ctx.literals()) {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.literals()));
        }
        result.getParameters().add(new LiteralExpressionSegment(ctx.tableName().getStart().getStartIndex(), ctx.tableName().getStop().getStopIndex(), (Object)ctx.tableName().getText()));
        if (null != ctx.alias()) {
            result.getParameters().add(new LiteralExpressionSegment(ctx.alias().getStart().getStartIndex(), ctx.alias().getStop().getStopIndex(), (Object)ctx.alias().getText()));
        }
        if (null != ctx.ONNX()) {
            result.getParameters().add(new LiteralExpressionSegment(ctx.ONNX().getSymbol().getStartIndex(), ctx.ONNX().getSymbol().getStopIndex(), (Object)ctx.ONNX().getText()));
        }
        return result;
    }

    @Override
    public ASTNode visitWithTableHint(SQLServerStatementParser.WithTableHintContext ctx) {
        WithTableHintSegment result = new WithTableHintSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        LinkedList<TableHintLimitedSegment> tableHintLimitedSegments = new LinkedList<TableHintLimitedSegment>();
        if (null != ctx.tableHintLimited()) {
            for (SQLServerStatementParser.TableHintLimitedContext tableHintLimitedContext : ctx.tableHintLimited()) {
                tableHintLimitedSegments.add((TableHintLimitedSegment)this.visit((ParseTree)tableHintLimitedContext));
            }
        }
        if (null != ctx.tableHintExtended()) {
            for (SQLServerStatementParser.TableHintExtendedContext tableHintExtendedContext : ctx.tableHintExtended()) {
                TableHintLimitedSegment segment = new TableHintLimitedSegment(tableHintExtendedContext.start.getStartIndex(), tableHintExtendedContext.stop.getStopIndex());
                segment.setValue(tableHintExtendedContext.getText());
                tableHintLimitedSegments.add(segment);
            }
        }
        result.getTableHintLimitedSegments().addAll(tableHintLimitedSegments);
        return result;
    }

    @Override
    public ASTNode visitTableHintLimited(SQLServerStatementParser.TableHintLimitedContext ctx) {
        TableHintLimitedSegment result = new TableHintLimitedSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setValue(ctx.getText());
        return result;
    }

    @Override
    public ASTNode visitInsertDefaultValue(SQLServerStatementParser.InsertDefaultValueContext ctx) {
        InsertStatement result = new InsertStatement(this.databaseType);
        result.setInsertColumns(this.createInsertColumns(ctx.columnNames(), ctx.start.getStartIndex()));
        if (null != ctx.outputClause()) {
            result.setOutput((OutputSegment)this.visit((ParseTree)ctx.outputClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitInsertExecClause(SQLServerStatementParser.InsertExecClauseContext ctx) {
        InsertStatement result = new InsertStatement(this.databaseType);
        result.setInsertColumns(this.createInsertColumns(ctx.columnNames(), ctx.start.getStartIndex()));
        result.setExec((ExecSegment)this.visit((ParseTree)ctx.exec()));
        return result;
    }

    @Override
    public ASTNode visitExec(SQLServerStatementParser.ExecContext ctx) {
        ExecSegment result = new ExecSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.procedureName()) {
            result.setProcedureName((FunctionNameSegment)this.visitProcedureName(ctx.procedureName()));
        }
        if (null != ctx.expr()) {
            LinkedList<ExpressionSegment> items = new LinkedList<ExpressionSegment>();
            for (SQLServerStatementParser.ExprContext each : ctx.expr()) {
                items.add((ExpressionSegment)this.visit((ParseTree)each));
            }
            result.getExpressionSegments().addAll(items);
        }
        return result;
    }

    @Override
    public ASTNode visitProcedureName(SQLServerStatementParser.ProcedureNameContext ctx) {
        FunctionNameSegment result = new FunctionNameSegment(ctx.name().start.getStartIndex(), ctx.name().stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name()));
        if (null != ctx.owner()) {
            result.setOwner(new OwnerSegment(ctx.owner().start.getStartIndex(), ctx.owner().stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.owner())));
        }
        return result;
    }

    @Override
    public ASTNode visitOutputClause(SQLServerStatementParser.OutputClauseContext ctx) {
        OutputSegment result = new OutputSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        if (null != ctx.outputWithColumns()) {
            SQLServerStatementParser.OutputWithColumnsContext outputWithColumnsContext = ctx.outputWithColumns();
            ProjectionsSegment outputColumns = new ProjectionsSegment(outputWithColumnsContext.start.getStartIndex(), outputWithColumnsContext.stop.getStopIndex());
            for (int i = 0; i < outputWithColumnsContext.getChildCount(); i += 2) {
                ParseTree each = outputWithColumnsContext.getChild(i);
                if (each instanceof SQLServerStatementParser.OutputWithColumnContext) {
                    outputColumns.getProjections().add(this.createColumnProjectionSegment((SQLServerStatementParser.OutputWithColumnContext)each));
                }
                if (!(each instanceof SQLServerStatementParser.ScalarExpressionContext)) continue;
                outputColumns.getProjections().add(this.createScalarExpressionContext((SQLServerStatementParser.ScalarExpressionContext)each));
            }
            result.setOutputColumns(outputColumns);
        }
        if (null != ctx.outputTableName()) {
            if (null != ctx.outputTableName().tableName()) {
                result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.outputTableName().tableName()));
            }
            if (null != ctx.columnNames()) {
                SQLServerStatementParser.ColumnNamesContext columnNames = ctx.columnNames();
                CollectionValue columns = (CollectionValue)this.visit((ParseTree)columnNames);
                result.getTableColumns().addAll(columns.getValue());
            }
        }
        return result;
    }

    private ProjectionSegment createScalarExpressionContext(SQLServerStatementParser.ScalarExpressionContext context) {
        ExpressionProjectionSegment result = new ExpressionProjectionSegment(context.start.getStartIndex(), context.stop.getStopIndex(), this.getOriginalText(context), (ExpressionSegment)this.visit((ParseTree)context.expr()));
        if (null != context.alias()) {
            result.setAlias(new AliasSegment(context.alias().start.getStartIndex(), context.alias().stop.getStopIndex(), new IdentifierValue(context.alias().getText())));
        }
        return result;
    }

    private ProjectionSegment createColumnProjectionSegment(SQLServerStatementParser.OutputWithColumnContext context) {
        ColumnSegment column = new ColumnSegment(context.start.getStartIndex(), context.stop.getStopIndex(), new IdentifierValue(context.name().getText()));
        ColumnProjectionSegment result = new ColumnProjectionSegment(column);
        if (null != context.alias()) {
            result.setAlias(new AliasSegment(context.alias().start.getStartIndex(), context.alias().stop.getStopIndex(), new IdentifierValue(context.alias().getText())));
        }
        return result;
    }

    @Override
    public ASTNode visitInsertValuesClause(SQLServerStatementParser.InsertValuesClauseContext ctx) {
        InsertStatement result = new InsertStatement(this.databaseType);
        result.setInsertColumns(this.createInsertColumns(ctx.columnNames(), ctx.start.getStartIndex()));
        result.getValues().addAll(this.createInsertValuesSegments(ctx.assignmentValues()));
        if (null != ctx.outputClause()) {
            result.setOutput((OutputSegment)this.visit((ParseTree)ctx.outputClause()));
        }
        return result;
    }

    private Collection<InsertValuesSegment> createInsertValuesSegments(Collection<SQLServerStatementParser.AssignmentValuesContext> assignmentValuesContexts) {
        LinkedList<InsertValuesSegment> result = new LinkedList<InsertValuesSegment>();
        for (SQLServerStatementParser.AssignmentValuesContext each : assignmentValuesContexts) {
            result.add((InsertValuesSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitInsertSelectClause(SQLServerStatementParser.InsertSelectClauseContext ctx) {
        InsertStatement result = new InsertStatement(this.databaseType);
        result.setInsertColumns(this.createInsertColumns(ctx.columnNames(), ctx.start.getStartIndex()));
        result.setInsertSelect(this.createInsertSelectSegment(ctx));
        if (null != ctx.outputClause()) {
            result.setOutput((OutputSegment)this.visit((ParseTree)ctx.outputClause()));
        }
        return result;
    }

    private InsertColumnsSegment createInsertColumns(SQLServerStatementParser.ColumnNamesContext columnNames, int startIndex) {
        if (null == columnNames) {
            return new InsertColumnsSegment(startIndex - 1, startIndex - 1, Collections.emptyList());
        }
        CollectionValue columnSegments = (CollectionValue)this.visit((ParseTree)columnNames);
        return new InsertColumnsSegment(columnNames.start.getStartIndex(), columnNames.stop.getStopIndex(), columnSegments.getValue());
    }

    private SubquerySegment createInsertSelectSegment(SQLServerStatementParser.InsertSelectClauseContext ctx) {
        SelectStatement selectStatement = (SelectStatement)this.visit((ParseTree)ctx.select());
        return new SubquerySegment(ctx.select().start.getStartIndex(), ctx.select().stop.getStopIndex(), selectStatement, this.getOriginalText(ctx.select()));
    }

    @Override
    public ASTNode visitWithClause(SQLServerStatementParser.WithClauseContext ctx) {
        Collection<CommonTableExpressionSegment> commonTableExpressionSegments = this.getCommonTableExpressionSegmentsUsingCteClauseSet(ctx.cteClauseSet());
        return new WithSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), commonTableExpressionSegments);
    }

    @Override
    public ASTNode visitUpdate(SQLServerStatementParser.UpdateContext ctx) {
        UpdateStatement result = new UpdateStatement(this.databaseType);
        if (null != ctx.withClause()) {
            result.setWith((WithSegment)this.visit((ParseTree)ctx.withClause()));
        }
        result.setTable((TableSegment)this.visit((ParseTree)ctx.tableReferences()));
        result.setSetAssignment((SetAssignmentSegment)this.visit((ParseTree)ctx.setAssignmentsClause()));
        if (null != ctx.fromClause()) {
            result.setFrom((TableSegment)this.visit((ParseTree)ctx.fromClause()));
        }
        if (null != ctx.withTableHint()) {
            result.setWithTableHint((WithTableHintSegment)this.visit((ParseTree)ctx.withTableHint()));
        }
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        if (null != ctx.optionHint()) {
            result.setOptionHint((OptionHintSegment)this.visit((ParseTree)ctx.optionHint()));
        }
        if (null != ctx.outputClause()) {
            result.setOutput((OutputSegment)this.visit((ParseTree)ctx.outputClause()));
        }
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitOptionHint(SQLServerStatementParser.OptionHintContext ctx) {
        return new OptionHintSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), this.getOriginalText(ctx));
    }

    @Override
    public ASTNode visitSetAssignmentsClause(SQLServerStatementParser.SetAssignmentsClauseContext ctx) {
        LinkedList<ColumnAssignmentSegment> assignments = new LinkedList<ColumnAssignmentSegment>();
        for (SQLServerStatementParser.AssignmentContext each : ctx.assignment()) {
            assignments.add((ColumnAssignmentSegment)this.visit((ParseTree)each));
        }
        return new SetAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), assignments);
    }

    @Override
    public ASTNode visitAssignmentValues(SQLServerStatementParser.AssignmentValuesContext ctx) {
        LinkedList<ExpressionSegment> segments = new LinkedList<ExpressionSegment>();
        for (SQLServerStatementParser.AssignmentValueContext each : ctx.assignmentValue()) {
            segments.add((ExpressionSegment)this.visit((ParseTree)each));
        }
        return new InsertValuesSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), segments);
    }

    @Override
    public ASTNode visitAssignment(SQLServerStatementParser.AssignmentContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visitColumnName(ctx.columnName());
        LinkedList<ColumnSegment> columnSegments = new LinkedList<ColumnSegment>();
        columnSegments.add(column);
        ExpressionSegment value = (ExpressionSegment)this.visit((ParseTree)ctx.assignmentValue());
        return new ColumnAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnSegments, value);
    }

    @Override
    public ASTNode visitAssignmentValue(SQLServerStatementParser.AssignmentValueContext ctx) {
        SQLServerStatementParser.ExprContext expr = ctx.expr();
        if (null != expr) {
            return (ASTNode)this.visit((ParseTree)expr);
        }
        return new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public ASTNode visitDelete(SQLServerStatementParser.DeleteContext ctx) {
        DeleteStatement result = new DeleteStatement(this.databaseType);
        if (null != ctx.withClause()) {
            result.setWith((WithSegment)this.visit((ParseTree)ctx.withClause()));
        }
        if (null != ctx.multipleTablesClause()) {
            result.setTable((TableSegment)this.visit((ParseTree)ctx.multipleTablesClause()));
        } else {
            result.setTable((TableSegment)this.visit((ParseTree)ctx.singleTableClause()));
        }
        if (null != ctx.outputClause()) {
            result.setOutput((OutputSegment)this.visit((ParseTree)ctx.outputClause()));
        }
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        if (null != ctx.outputClause()) {
            result.setOutput((OutputSegment)this.visit((ParseTree)ctx.outputClause()));
        }
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitSingleTableClause(SQLServerStatementParser.SingleTableClauseContext ctx) {
        if (null != ctx.tableName()) {
            SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        if (null != ctx.rowSetFunction()) {
            FunctionSegment functionSegment = (FunctionSegment)this.visit((ParseTree)ctx.rowSetFunction());
            FunctionTableSegment result = new FunctionTableSegment(functionSegment.getStartIndex(), functionSegment.getStopIndex(), (ExpressionSegment)functionSegment);
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        return null;
    }

    @Override
    public ASTNode visitMultipleTablesClause(SQLServerStatementParser.MultipleTablesClauseContext ctx) {
        DeleteMultiTableSegment result = new DeleteMultiTableSegment();
        TableSegment relateTableSource = (TableSegment)this.visit((ParseTree)ctx.tableReferences());
        result.setRelationTable(relateTableSource);
        result.setActualDeleteTables(this.generateTablesFromTableMultipleTableNames(ctx.multipleTableNames()));
        return result;
    }

    private List<SimpleTableSegment> generateTablesFromTableMultipleTableNames(SQLServerStatementParser.MultipleTableNamesContext ctx) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (SQLServerStatementParser.TableNameContext each : ctx.tableName()) {
            result.add((SimpleTableSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitDuplicateSpecification(SQLServerStatementParser.DuplicateSpecificationContext ctx) {
        return new BooleanLiteralValue(null != ctx.DISTINCT());
    }

    @Override
    public ASTNode visitProjection(SQLServerStatementParser.ProjectionContext ctx) {
        AliasSegment alias;
        if (null != ctx.qualifiedShorthand()) {
            SQLServerStatementParser.QualifiedShorthandContext shorthand = ctx.qualifiedShorthand();
            ShorthandProjectionSegment result = new ShorthandProjectionSegment(shorthand.getStart().getStartIndex(), shorthand.getStop().getStopIndex());
            IdentifierValue identifier = new IdentifierValue(shorthand.identifier().getText());
            result.setOwner(new OwnerSegment(shorthand.identifier().getStart().getStartIndex(), shorthand.identifier().getStop().getStopIndex(), identifier));
            return result;
        }
        if (null != ctx.unqualifiedShorthand()) {
            return new ShorthandProjectionSegment(ctx.unqualifiedShorthand().getStart().getStartIndex(), ctx.unqualifiedShorthand().getStop().getStopIndex());
        }
        AliasSegment aliasSegment = alias = null == ctx.alias() ? null : (AliasSegment)this.visit((ParseTree)ctx.alias());
        if (null != ctx.columnName()) {
            ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
            ColumnProjectionSegment result = new ColumnProjectionSegment(column);
            result.setAlias(alias);
            return result;
        }
        return this.createProjection(ctx, alias);
    }

    @Override
    public ASTNode visitTop(SQLServerStatementParser.TopContext ctx) {
        int startIndex = ctx.topNum().getStart().getStartIndex();
        int stopIndex = ctx.topNum().getStop().getStopIndex();
        ASTNode topNum = (ASTNode)this.visit((ParseTree)ctx.topNum());
        if (topNum instanceof NumberLiteralValue) {
            NumberLiteralRowNumberValueSegment rowNumberSegment = new NumberLiteralRowNumberValueSegment(startIndex, stopIndex, Long.valueOf(((NumberLiteralValue)topNum).getValue().longValue()), false);
            return new TopProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (RowNumberValueSegment)rowNumberSegment, null != ctx.alias() ? ctx.alias().getText() : null);
        }
        ParameterMarkerRowNumberValueSegment parameterSegment = new ParameterMarkerRowNumberValueSegment(startIndex, stopIndex, ((ParameterMarkerValue)topNum).getValue().intValue(), false);
        this.parameterMarkerSegments.add((ParameterMarkerSegment)parameterSegment);
        return new TopProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (RowNumberValueSegment)parameterSegment, null != ctx.alias() ? ctx.alias().getText() : null);
    }

    @Override
    public ASTNode visitAlias(SQLServerStatementParser.AliasContext ctx) {
        if (null != ctx.identifier()) {
            return new AliasSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
        }
        if (null != ctx.NCHAR_TEXT()) {
            return new AliasSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), new IdentifierValue(ctx.NCHAR_TEXT().getText().substring(1)));
        }
        return new AliasSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), new IdentifierValue(ctx.STRING_().getText()));
    }

    private ASTNode createProjection(SQLServerStatementParser.ProjectionContext ctx, AliasSegment alias) {
        ASTNode projection = (ASTNode)this.visit((ParseTree)ctx.expr());
        if (projection instanceof AggregationProjectionSegment) {
            ((AggregationProjectionSegment)projection).setAlias(alias);
            return projection;
        }
        if (projection instanceof ExpressionProjectionSegment) {
            ((ExpressionProjectionSegment)projection).setAlias(alias);
            return projection;
        }
        if (projection instanceof FunctionSegment) {
            FunctionSegment segment = (FunctionSegment)projection;
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getText(), (ExpressionSegment)segment);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof CommonExpressionSegment) {
            CommonExpressionSegment segment = (CommonExpressionSegment)projection;
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getText(), (ExpressionSegment)segment);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof ColumnSegment) {
            ColumnProjectionSegment result = new ColumnProjectionSegment((ColumnSegment)projection);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof SubqueryExpressionSegment) {
            SubqueryExpressionSegment subqueryExpressionSegment = (SubqueryExpressionSegment)projection;
            String text = ctx.start.getInputStream().getText(new Interval(subqueryExpressionSegment.getStartIndex(), subqueryExpressionSegment.getStopIndex()));
            SubqueryProjectionSegment result = new SubqueryProjectionSegment(((SubqueryExpressionSegment)projection).getSubquery(), text);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof BinaryOperationExpression) {
            BinaryOperationExpression binaryExpression = (BinaryOperationExpression)projection;
            int startIndex = this.getStartIndexWithAlias((SQLSegment)binaryExpression, alias);
            int stopIndex = this.getStopIndexWithAlias((SQLSegment)binaryExpression, alias);
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(startIndex, stopIndex, binaryExpression.getText(), (ExpressionSegment)binaryExpression);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof ParameterMarkerExpressionSegment) {
            ParameterMarkerExpressionSegment result = (ParameterMarkerExpressionSegment)projection;
            result.setAlias(alias);
            return projection;
        }
        ExpressionSegment column = (ExpressionSegment)projection;
        ExpressionProjectionSegment result = new ExpressionProjectionSegment(this.getStartIndexWithAlias((SQLSegment)column, alias), this.getStopIndexWithAlias((SQLSegment)column, alias), String.valueOf(column.getText()), column);
        result.setAlias(alias);
        return result;
    }

    private int getStartIndexWithAlias(SQLSegment sqlSegment, AliasSegment alias) {
        return null != alias && alias.getStartIndex() < sqlSegment.getStartIndex() ? alias.getStartIndex() : sqlSegment.getStartIndex();
    }

    private int getStopIndexWithAlias(SQLSegment sqlSegment, AliasSegment alias) {
        return null != alias && alias.getStopIndex() > sqlSegment.getStopIndex() ? alias.getStopIndex() : sqlSegment.getStopIndex();
    }

    @Override
    public ASTNode visitIntoClause(SQLServerStatementParser.IntoClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableName());
    }

    @Override
    public ASTNode visitFromClause(SQLServerStatementParser.FromClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableReferences());
    }

    @Override
    public ASTNode visitTableReference(SQLServerStatementParser.TableReferenceContext ctx) {
        TableSegment left = (TableSegment)this.visit((ParseTree)ctx.tableFactor());
        if (!ctx.joinedTable().isEmpty()) {
            for (SQLServerStatementParser.JoinedTableContext each : ctx.joinedTable()) {
                left = this.visitJoinedTable(each, left);
            }
        }
        TableSegment result = left;
        return result;
    }

    @Override
    public ASTNode visitTableFactor(SQLServerStatementParser.TableFactorContext ctx) {
        if (null != ctx.subquery()) {
            SubquerySegment subquerySegment = new SubquerySegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), this.getOriginalText(ctx.subquery()));
            if (null != ctx.subquery().merge()) {
                subquerySegment.setMerge((MergeStatement)this.visit((ParseTree)ctx.subquery()));
            } else {
                subquerySegment.setSelect((SelectStatement)this.visit((ParseTree)ctx.subquery()));
            }
            SubqueryTableSegment result = new SubqueryTableSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), subquerySegment);
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        if (null != ctx.tableName()) {
            SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        if (null != ctx.expr()) {
            ExpressionSegment exprSegment = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
            FunctionTableSegment result = new FunctionTableSegment(exprSegment.getStartIndex(), exprSegment.getStopIndex(), exprSegment);
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        if (null != ctx.xmlMethodCall()) {
            FunctionSegment functionSegment = (FunctionSegment)this.visit((ParseTree)ctx.xmlMethodCall());
            FunctionTableSegment result = new FunctionTableSegment(functionSegment.getStartIndex(), functionSegment.getStopIndex(), (ExpressionSegment)functionSegment);
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        if (null != ctx.pivotTable()) {
            return (ASTNode)this.visit((ParseTree)ctx.pivotTable());
        }
        if (null != ctx.rowSetFunction()) {
            FunctionSegment functionSegment = (FunctionSegment)this.visit((ParseTree)ctx.rowSetFunction());
            FunctionTableSegment result = new FunctionTableSegment(functionSegment.getStartIndex(), functionSegment.getStopIndex(), (ExpressionSegment)functionSegment);
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        return (ASTNode)this.visit((ParseTree)ctx.tableReferences());
    }

    @Override
    public ASTNode visitPivotTable(SQLServerStatementParser.PivotTableContext ctx) {
        FunctionSegment pivotFunction = (FunctionSegment)this.visit((ParseTree)ctx.pivotClause());
        FunctionTableSegment result = new FunctionTableSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (ExpressionSegment)pivotFunction);
        if (null != ctx.alias()) {
            result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
        }
        return result;
    }

    @Override
    public ASTNode visitPivotClause(SQLServerStatementParser.PivotClauseContext ctx) {
        CollectionValue pivotValues;
        String pivotType = null == ctx.PIVOT() ? "UNPIVOT" : "PIVOT";
        String functionText = this.getOriginalText(ctx);
        FunctionSegment result = new FunctionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), pivotType, functionText);
        if (null != ctx.tableName()) {
            SimpleTableSegment tableSegment = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
            result.getParameters().add(new LiteralExpressionSegment(tableSegment.getStartIndex(), tableSegment.getStopIndex(), (Object)tableSegment.getTableName().getIdentifier().getValue()));
        } else if (null != ctx.subquery()) {
            SubquerySegment subquerySegment = new SubquerySegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), (SelectStatement)this.visit((ParseTree)ctx.subquery()), this.getOriginalText(ctx.subquery()));
            if (null == ctx.alias()) {
                result.getParameters().add(new SubqueryExpressionSegment(subquerySegment));
            } else {
                AliasSegment aliasSegment = (AliasSegment)this.visit((ParseTree)ctx.alias());
                SubqueryTableSegment subqueryTableSegment = new SubqueryTableSegment(subquerySegment.getStartIndex(), subquerySegment.getStopIndex(), subquerySegment);
                subqueryTableSegment.setAlias(aliasSegment);
                result.getParameters().add(new SubqueryExpressionSegment(subquerySegment));
            }
        }
        if (null == ctx.PIVOT()) {
            result.getParameters().add((ColumnSegment)this.visit((ParseTree)ctx.columnName(0)));
            result.getParameters().add((ColumnSegment)this.visit((ParseTree)ctx.columnName(1)));
            pivotValues = (CollectionValue)this.visit((ParseTree)ctx.pivotValueList());
            result.getParameters().addAll(pivotValues.getValue());
        } else {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.aggregationFunction()));
            result.getParameters().add((ColumnSegment)this.visit((ParseTree)ctx.columnName(0)));
            pivotValues = (CollectionValue)this.visit((ParseTree)ctx.pivotValueList());
            result.getParameters().addAll(pivotValues.getValue());
        }
        return result;
    }

    @Override
    public ASTNode visitPivotValueList(SQLServerStatementParser.PivotValueListContext ctx) {
        CollectionValue result = new CollectionValue();
        for (SQLServerStatementParser.PivotValueContext pivotValueContext : ctx.pivotValue()) {
            result.getValue().add((ExpressionSegment)this.visit((ParseTree)pivotValueContext));
        }
        return result;
    }

    @Override
    public ASTNode visitPivotValue(SQLServerStatementParser.PivotValueContext ctx) {
        if (null != ctx.expr()) {
            return (ASTNode)this.visit((ParseTree)ctx.expr());
        }
        return new LiteralExpressionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (Object)this.getOriginalText(ctx));
    }

    private JoinTableSegment visitJoinedTable(SQLServerStatementParser.JoinedTableContext ctx, TableSegment tableSegment) {
        JoinTableSegment result = new JoinTableSegment();
        result.setLeft(tableSegment);
        result.setStartIndex(tableSegment.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        TableSegment right = (TableSegment)this.visit((ParseTree)ctx.tableFactor());
        result.setRight(right);
        result.setJoinType(this.getJoinType(ctx));
        if (null != ctx.joinSpecification()) {
            this.visitJoinSpecification(ctx.joinSpecification(), result);
        }
        if (null != ctx.joinHint()) {
            result.setJoinHint(ctx.joinHint().getChild(0).getText());
        }
        return result;
    }

    private String getJoinType(SQLServerStatementParser.JoinedTableContext ctx) {
        if (null != ctx.LEFT()) {
            return JoinType.LEFT.name();
        }
        if (null != ctx.RIGHT()) {
            return JoinType.RIGHT.name();
        }
        if (null != ctx.FULL()) {
            return JoinType.FULL.name();
        }
        if (null != ctx.INNER()) {
            return JoinType.INNER.name();
        }
        if (null != ctx.CROSS()) {
            return JoinType.CROSS.name();
        }
        return JoinType.INNER.name();
    }

    private void visitJoinSpecification(SQLServerStatementParser.JoinSpecificationContext ctx, JoinTableSegment joinTableSource) {
        if (null != ctx.expr()) {
            ExpressionSegment condition = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
            joinTableSource.setCondition(condition);
        }
        if (null != ctx.USING()) {
            joinTableSource.setUsing(ctx.columnNames().columnName().stream().map(each -> (ColumnSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
        }
    }

    @Override
    public ASTNode visitSubquery(SQLServerStatementParser.SubqueryContext ctx) {
        if (null != ctx.merge()) {
            return (ASTNode)this.visit((ParseTree)ctx.merge());
        }
        return (ASTNode)this.visit((ParseTree)ctx.aggregationClause());
    }

    @Override
    public ASTNode visitCreateTableAsSelectClause(SQLServerStatementParser.CreateTableAsSelectClauseContext ctx) {
        CreateTableStatement result = new CreateTableStatement(this.databaseType);
        if (null != ctx.createTableAsSelect()) {
            result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.createTableAsSelect().tableName()));
            result.setSelectStatement((SelectStatement)this.visit((ParseTree)ctx.createTableAsSelect().select()));
            if (null != ctx.createTableAsSelect().columnNames()) {
                CollectionValue columnSegments = (CollectionValue)this.visit((ParseTree)ctx.createTableAsSelect().columnNames());
                for (ColumnSegment each : columnSegments.getValue()) {
                    result.getColumns().add(each);
                }
            }
        } else {
            result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.createRemoteTableAsSelect().tableName()));
            result.setSelectStatement((SelectStatement)this.visit((ParseTree)ctx.createRemoteTableAsSelect().select()));
        }
        return result;
    }

    @Override
    public ASTNode visitUpdateStatistics(SQLServerStatementParser.UpdateStatisticsContext ctx) {
        LinkedList<IndexSegment> indexSegments = null;
        if (null != ctx.indexName() && !ctx.indexName().isEmpty()) {
            indexSegments = new LinkedList<IndexSegment>();
            for (SQLServerStatementParser.IndexNameContext indexNameContext : ctx.indexName()) {
                indexSegments.add((IndexSegment)this.visit((ParseTree)indexNameContext));
            }
        }
        return new SQLServerUpdateStatisticsStatement(this.databaseType, null == ctx.tableName() ? null : (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()), indexSegments, null == ctx.statisticsWithClause() ? null : (StatisticsStrategySegment)this.visit((ParseTree)ctx.statisticsWithClause()));
    }

    @Override
    public ASTNode visitStatisticsWithClause(SQLServerStatementParser.StatisticsWithClauseContext ctx) {
        StatisticsStrategySegment result = new StatisticsStrategySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.sampleOption()) {
            result.setSampleOption((SampleOptionSegment)this.visit((ParseTree)ctx.sampleOption()));
        }
        if (null != ctx.statisticsOptions()) {
            result.setStatisticsOptions((StatisticsOptionSegment)this.visit((ParseTree)ctx.statisticsOptions()));
        }
        return result;
    }

    @Override
    public ASTNode visitSampleOption(SQLServerStatementParser.SampleOptionContext ctx) {
        SampleOptionSegment result = new SampleOptionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.FULLSCAN()) {
            result.setStrategy(SampleStrategy.FULLSCAN);
        } else if (null != ctx.SAMPLE()) {
            result.setStrategy(SampleStrategy.SAMPLE);
            if (null != ctx.NUMBER_()) {
                List<TerminalNode> number = ctx.NUMBER_();
                result.setSampleNumber(number.get(0).getText());
            }
            if (null != ctx.PERCENT()) {
                result.setScanUnit(ScanUnit.PERCENT);
            } else if (null != ctx.ROWS()) {
                result.setScanUnit(ScanUnit.ROWS);
            }
        } else if (null != ctx.RESAMPLE()) {
            result.setStrategy(SampleStrategy.RESAMPLE);
            if (null != ctx.NUMBER_()) {
                LinkedList<String> partitions = new LinkedList<String>();
                for (TerminalNode terminalNode : ctx.NUMBER_()) {
                    partitions.add(terminalNode.getText());
                }
                result.setPartitions(partitions);
            }
        }
        if (null != ctx.PERSIST_SAMPLE_PERCENT()) {
            result.setPersistSamplePercent(null != ctx.ON());
        }
        return result;
    }

    @Override
    public ASTNode visitStatisticsOptions(SQLServerStatementParser.StatisticsOptionsContext ctx) {
        StatisticsOptionSegment result = new StatisticsOptionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        for (SQLServerStatementParser.StatisticsOptionContext option : ctx.statisticsOption()) {
            if (null != option.ALL()) {
                result.setStatisticsDimension(StatisticsDimension.ALL);
            } else if (null != option.COLUMNS()) {
                result.setStatisticsDimension(StatisticsDimension.COLUMNS);
            } else if (null != option.INDEX()) {
                result.setStatisticsDimension(StatisticsDimension.INDEX);
            }
            if (null != option.NORECOMPUTE()) {
                result.setNoRecompute(true);
            }
            if (null != option.INCREMENTAL()) {
                result.setIncremental(null != option.ON());
            }
            if (null != option.MAXDOP()) {
                result.setMaxDegreeOfParallelism(option.NUMBER_().getText());
            }
            if (null == option.AUTO_DROP()) continue;
            result.setAutoDrop(null != option.ON());
        }
        return result;
    }

    @Override
    public ASTNode visitMerge(SQLServerStatementParser.MergeContext ctx) {
        MergeStatement result = new MergeStatement(this.databaseType);
        result.setTarget((TableSegment)this.visit((ParseTree)ctx.mergeIntoClause().tableReferences()));
        if (null != ctx.withClause()) {
            result.setWith((WithSegment)this.visit((ParseTree)ctx.withClause()));
        }
        if (null != ctx.withMergeHint()) {
            result.setWithTableHint((WithTableHintSegment)this.visit((ParseTree)ctx.withMergeHint().withTableHint()));
            if (null != ctx.withMergeHint().indexName()) {
                LinkedList<IndexSegment> indexSegments = new LinkedList<IndexSegment>();
                for (SQLServerStatementParser.IndexNameContext each : ctx.withMergeHint().indexName()) {
                    indexSegments.add((IndexSegment)this.visit((ParseTree)each));
                }
                result.setIndexes(indexSegments);
            }
        }
        if (null != ctx.mergeUsingClause()) {
            result.setSource((TableSegment)this.visit((ParseTree)ctx.mergeUsingClause().tableReferences()));
            ExpressionWithParamsSegment onExpression = new ExpressionWithParamsSegment(ctx.mergeUsingClause().expr().start.getStartIndex(), ctx.mergeUsingClause().expr().stop.getStopIndex(), (ExpressionSegment)this.visit((ParseTree)ctx.mergeUsingClause().expr()));
            result.setExpression(onExpression);
        }
        if (null != ctx.mergeWhenClause()) {
            for (SQLServerStatementParser.MergeWhenClauseContext each : ctx.mergeWhenClause()) {
                result.getWhenAndThens().add((MergeWhenAndThenSegment)this.visit((ParseTree)each));
            }
        }
        if (null != ctx.outputClause()) {
            result.setOutput((OutputSegment)this.visit((ParseTree)ctx.outputClause()));
        }
        if (null != ctx.optionHint()) {
            result.setOptionHint((OptionHintSegment)this.visit((ParseTree)ctx.optionHint()));
        }
        return result;
    }

    @Override
    public ASTNode visitMergeWhenClause(SQLServerStatementParser.MergeWhenClauseContext ctx) {
        MergeWhenAndThenSegment result = new MergeWhenAndThenSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), this.getOriginalText(ctx));
        if (null != ctx.mergeDeleteClause() && null != ctx.mergeDeleteClause().expr()) {
            result.setAndExpr((ExpressionSegment)this.visit((ParseTree)ctx.mergeDeleteClause().expr()));
        }
        if (null != ctx.mergeUpdateClause()) {
            result.setUpdate((UpdateStatement)this.visit((ParseTree)ctx.mergeUpdateClause()));
            if (null != ctx.mergeUpdateClause().expr()) {
                result.setAndExpr((ExpressionSegment)this.visit((ParseTree)ctx.mergeUpdateClause().expr()));
            }
        }
        if (null != ctx.mergeInsertClause()) {
            result.setInsert((InsertStatement)this.visit((ParseTree)ctx.mergeInsertClause()));
            if (null != ctx.mergeInsertClause().expr()) {
                result.setAndExpr((ExpressionSegment)this.visit((ParseTree)ctx.mergeInsertClause().expr()));
            }
        }
        return result;
    }

    @Override
    public ASTNode visitMergeInsertClause(SQLServerStatementParser.MergeInsertClauseContext ctx) {
        InsertStatement result = null != ctx.insertDefaultValue() ? (InsertStatement)this.visit((ParseTree)ctx.insertDefaultValue()) : (InsertStatement)this.visit((ParseTree)ctx.insertValuesClause());
        return result;
    }

    @Override
    public ASTNode visitMergeUpdateClause(SQLServerStatementParser.MergeUpdateClauseContext ctx) {
        UpdateStatement result = new UpdateStatement(this.databaseType);
        result.setSetAssignment((SetAssignmentSegment)this.visit((ParseTree)ctx.setAssignmentsClause()));
        return result;
    }

    @Generated
    public SQLServerStatementVisitor(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    @Generated
    protected DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    protected Collection<ParameterMarkerSegment> getParameterMarkerSegments() {
        return this.parameterMarkerSegments;
    }
}

