/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.generic;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.generic.DialectToBeRemovedSegmentsProvider;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.RemoveToken;
import org.apache.shardingsphere.sql.parser.statement.core.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.IndexSQLStatementAttribute;

public final class RemoveTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext> {
    @Override
    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        if (DatabaseTypedSPILoader.findService(DialectToBeRemovedSegmentsProvider.class, (DatabaseType)sqlStatementContext.getSqlStatement().getDatabaseType()).map(optional -> !optional.getToBeRemovedSQLSegments(sqlStatementContext.getSqlStatement()).isEmpty()).orElse(false).booleanValue()) {
            return true;
        }
        if (!sqlStatementContext.getTablesContext().getSimpleTables().isEmpty()) {
            return true;
        }
        return sqlStatementContext.getSqlStatement().getAttributes().findAttribute(IndexSQLStatementAttribute.class).map(optional -> !optional.getIndexes().isEmpty()).orElse(false);
    }

    @Override
    public Collection<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        Collection toBeRemovedSQLSegments = DatabaseTypedSPILoader.findService(DialectToBeRemovedSegmentsProvider.class, (DatabaseType)sqlStatementContext.getSqlStatement().getDatabaseType()).map(optional -> optional.getToBeRemovedSQLSegments(sqlStatementContext.getSqlStatement())).orElse(Collections.emptyList());
        if (!toBeRemovedSQLSegments.isEmpty()) {
            result.addAll(this.generateRemoveAvailableSQLTokens(toBeRemovedSQLSegments));
        }
        if (!sqlStatementContext.getTablesContext().getSimpleTables().isEmpty()) {
            result.addAll(this.generateTableAvailableSQLTokens(sqlStatementContext));
        }
        if (sqlStatementContext.getSqlStatement().getAttributes().findAttribute(IndexSQLStatementAttribute.class).map(optional -> !optional.getIndexes().isEmpty()).orElse(false).booleanValue()) {
            result.addAll(this.generateIndexContextAvailableSQLTokens(sqlStatementContext));
        }
        return result;
    }

    private Collection<RemoveToken> generateRemoveAvailableSQLTokens(Collection<SQLSegment> removeSegments) {
        return removeSegments.stream().map(each -> new RemoveToken(each.getStartIndex(), each.getStopIndex())).collect(Collectors.toList());
    }

    private Collection<RemoveToken> generateTableAvailableSQLTokens(SQLStatementContext sqlStatementContext) {
        LinkedList<RemoveToken> result = new LinkedList<RemoveToken>();
        for (SimpleTableSegment each : sqlStatementContext.getTablesContext().getSimpleTables()) {
            if (!each.getOwner().isPresent()) continue;
            DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(sqlStatementContext.getSqlStatement().getDatabaseType()).getDialectDatabaseMetaData();
            OwnerSegment ownerSegment = (OwnerSegment)each.getOwner().get();
            if (dialectDatabaseMetaData.getSchemaOption().getDefaultSchema().isPresent()) {
                ownerSegment.getOwner().ifPresent(optional -> result.add(new RemoveToken(optional.getStartIndex(), ownerSegment.getStartIndex() - 1)));
                continue;
            }
            result.add(new RemoveToken(ownerSegment.getStartIndex(), each.getTableName().getStartIndex() - 1));
        }
        return result;
    }

    private Collection<RemoveToken> generateIndexContextAvailableSQLTokens(SQLStatementContext sqlStatementContext) {
        LinkedList<RemoveToken> result = new LinkedList<RemoveToken>();
        for (IndexSegment each : (Collection)sqlStatementContext.getSqlStatement().getAttributes().findAttribute(IndexSQLStatementAttribute.class).map(IndexSQLStatementAttribute::getIndexes).orElse(Collections.emptyList())) {
            if (!each.getOwner().isPresent()) continue;
            OwnerSegment owner = (OwnerSegment)each.getOwner().get();
            int startIndex = owner.getOwner().isPresent() ? ((OwnerSegment)owner.getOwner().get()).getStartIndex() : owner.getStartIndex();
            int stopIndex = owner.getOwner().isPresent() ? owner.getStartIndex() - 1 : each.getStartIndex() - 1;
            result.add(new RemoveToken(startIndex, stopIndex));
        }
        return result;
    }
}

