/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.manager.rule;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.checker.DatabaseRuleConfigurationEmptyChecker;
import org.apache.shardingsphere.infra.config.rule.scope.DatabaseRuleConfiguration;
import org.apache.shardingsphere.infra.exception.external.sql.type.wrapper.SQLWrapperException;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.manager.rule.DatabaseRuleConfigurationManager;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistFacade;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.rule.DatabaseRuleNodePath;
import org.apache.shardingsphere.mode.node.path.version.VersionNodePath;
import org.apache.shardingsphere.mode.spi.rule.RuleChangedItemType;
import org.apache.shardingsphere.mode.spi.rule.RuleItemConfigurationChangedProcessor;

public final class DatabaseRuleItemManager {
    private final MetaDataContexts metaDataContexts;
    private final DatabaseRuleConfigurationManager databaseRuleConfigManager;
    private final MetaDataPersistFacade metaDataPersistFacade;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alter(DatabaseRuleNodePath databaseRuleNodePath) {
        RuleItemConfigurationChangedProcessor processor = (RuleItemConfigurationChangedProcessor)TypedSPILoader.getService(RuleItemConfigurationChangedProcessor.class, (Object)new RuleChangedItemType(databaseRuleNodePath.getRuleType(), databaseRuleNodePath.getDatabaseRuleItem().getType()));
        String yamlContent = this.metaDataPersistFacade.getVersionService().loadContent(new VersionNodePath((NodePath)databaseRuleNodePath));
        String databaseName = databaseRuleNodePath.getDatabase().getDatabaseName();
        RuleConfiguration currentRuleConfig = processor.findRuleConfiguration(this.metaDataContexts.getMetaData().getDatabase(databaseName));
        String itemName = databaseRuleNodePath.getDatabaseRuleItem().getName();
        DatabaseRuleItemManager databaseRuleItemManager = this;
        synchronized (databaseRuleItemManager) {
            processor.changeRuleItemConfiguration(itemName, currentRuleConfig, processor.swapRuleItemConfiguration(itemName, yamlContent));
            try {
                this.databaseRuleConfigManager.refresh(databaseName, currentRuleConfig, true);
            }
            catch (SQLException ex) {
                throw new SQLWrapperException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(DatabaseRuleNodePath databaseRuleNodePath) {
        String databaseName = databaseRuleNodePath.getDatabase().getDatabaseName();
        Preconditions.checkState((boolean)this.metaDataContexts.getMetaData().containsDatabase(databaseName), (String)"No database '%s' exists.", (Object)databaseName);
        RuleItemConfigurationChangedProcessor processor = (RuleItemConfigurationChangedProcessor)TypedSPILoader.getService(RuleItemConfigurationChangedProcessor.class, (Object)new RuleChangedItemType(databaseRuleNodePath.getRuleType(), null == databaseRuleNodePath.getDatabaseRuleItem() ? null : databaseRuleNodePath.getDatabaseRuleItem().getType()));
        RuleConfiguration currentRuleConfig = processor.findRuleConfiguration(this.metaDataContexts.getMetaData().getDatabase(databaseName));
        String itemName = null == databaseRuleNodePath.getDatabaseRuleItem() ? null : databaseRuleNodePath.getDatabaseRuleItem().getName();
        DatabaseRuleItemManager databaseRuleItemManager = this;
        synchronized (databaseRuleItemManager) {
            processor.dropRuleItemConfiguration(itemName, currentRuleConfig);
            try {
                this.databaseRuleConfigManager.refresh(databaseName, currentRuleConfig, !((DatabaseRuleConfigurationEmptyChecker)TypedSPILoader.getService(DatabaseRuleConfigurationEmptyChecker.class, currentRuleConfig.getClass())).isEmpty((DatabaseRuleConfiguration)currentRuleConfig));
            }
            catch (SQLException ex) {
                throw new SQLWrapperException(ex);
            }
        }
    }

    @Generated
    public DatabaseRuleItemManager(MetaDataContexts metaDataContexts, DatabaseRuleConfigurationManager databaseRuleConfigManager, MetaDataPersistFacade metaDataPersistFacade) {
        this.metaDataContexts = metaDataContexts;
        this.databaseRuleConfigManager = databaseRuleConfigManager;
        this.metaDataPersistFacade = metaDataPersistFacade;
    }
}

