/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.version;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.mode.node.path.version.VersionNodePath;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionPersistService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VersionPersistService.class);
    private final PersistRepository repository;

    public int persist(VersionNodePath versionNodePath, String content) {
        int nextVersion = this.getNextVersion(versionNodePath.getVersionsPath());
        this.repository.persist(versionNodePath.getVersionPath(nextVersion), content);
        this.switchActiveVersion(versionNodePath, nextVersion);
        return nextVersion;
    }

    private void switchActiveVersion(VersionNodePath versionNodePath, int currentVersion) {
        this.repository.persist(versionNodePath.getActiveVersionPath(), String.valueOf(currentVersion));
        if (0 != currentVersion) {
            this.getVersions(versionNodePath.getVersionsPath()).stream().filter(version -> version < currentVersion).forEach(version -> this.repository.delete(versionNodePath.getVersionPath(version.intValue())));
        }
    }

    public int getNextVersion(String path) {
        List<Integer> versions = this.getVersions(path);
        return versions.isEmpty() ? 0 : versions.get(0) + 1;
    }

    private List<Integer> getVersions(String path) {
        List<Integer> result = this.repository.getChildrenKeys(path).stream().map(Integer::parseInt).collect(Collectors.toList());
        if (result.size() > 2) {
            log.warn("There are multiple versions of: {}, please check the configuration.", (Object)path);
            result.sort(Collections.reverseOrder());
        }
        return result;
    }

    public String loadContent(VersionNodePath versionNodePath) {
        String version = this.repository.query(versionNodePath.getActiveVersionPath());
        return null == version ? null : this.repository.query(versionNodePath.getVersionPath(Integer.parseInt(version)));
    }

    @Generated
    public VersionPersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

