/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.statement.dml;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.combine.CombineSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.TableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.type.SimpleTableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.lock.LockSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.order.GroupBySegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.order.OrderBySegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.predicate.HavingSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.predicate.WhereSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.projection.ProjectionsSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.with.WithSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.util.SubqueryTableBindUtils;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementCopyUtils;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TableSourceType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.combine.CombineSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.HavingSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.LockSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.WithSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class SelectStatementBinder
implements SQLStatementBinder<SelectStatement> {
    private final Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> outerTableBinderContexts;

    public SelectStatementBinder() {
        this.outerTableBinderContexts = LinkedHashMultimap.create();
    }

    @Override
    public SelectStatement bind(SelectStatement sqlStatement, SQLStatementBinderContext binderContext) {
        LinkedHashMultimap tableBinderContexts = LinkedHashMultimap.create();
        WithSegment boundWith = sqlStatement.getWith().map(optional -> WithSegmentBinder.bind(optional, binderContext, binderContext.getExternalTableBinderContexts())).orElse(null);
        Optional<TableSegment> boundFrom = sqlStatement.getFrom().map(arg_0 -> this.lambda$bind$1(binderContext, (Multimap)tableBinderContexts, arg_0));
        ProjectionsSegment boundProjections = ProjectionsSegmentBinder.bind(sqlStatement.getProjections(), binderContext, (TableSegment)boundFrom.orElse(null), (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts, this.outerTableBinderContexts);
        WhereSegment boundWhere = sqlStatement.getWhere().map(arg_0 -> this.lambda$bind$2(binderContext, (Multimap)tableBinderContexts, arg_0)).orElse(null);
        CombineSegment boundCombine = sqlStatement.getCombine().map(optional -> CombineSegmentBinder.bind(optional, binderContext, this.outerTableBinderContexts)).orElse(null);
        LockSegment boundLock = sqlStatement.getLock().map(arg_0 -> this.lambda$bind$4(binderContext, (Multimap)tableBinderContexts, arg_0)).orElse(null);
        Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> currentTableBinderContexts = this.createCurrentTableBinderContexts(binderContext, boundProjections);
        GroupBySegment boundGroupBy = sqlStatement.getGroupBy().map(arg_0 -> this.lambda$bind$5(binderContext, currentTableBinderContexts, (Multimap)tableBinderContexts, arg_0)).orElse(null);
        OrderBySegment boundOrderBy = sqlStatement.getOrderBy().map(arg_0 -> this.lambda$bind$6(binderContext, currentTableBinderContexts, (Multimap)tableBinderContexts, arg_0)).orElse(null);
        HavingSegment boundHaving = sqlStatement.getHaving().map(arg_0 -> this.lambda$bind$7(binderContext, currentTableBinderContexts, (Multimap)tableBinderContexts, arg_0)).orElse(null);
        return this.copy(sqlStatement, boundWith, boundFrom.orElse(null), boundProjections, boundWhere, boundCombine, boundLock, boundGroupBy, boundOrderBy, boundHaving);
    }

    private Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> createCurrentTableBinderContexts(SQLStatementBinderContext binderContext, ProjectionsSegment boundProjections) {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        Collection<ProjectionSegment> subqueryProjections = SubqueryTableBindUtils.createSubqueryProjections(boundProjections.getProjections(), new IdentifierValue(""), binderContext.getSqlStatement().getDatabaseType(), TableSourceType.MIXED_TABLE);
        result.put((Object)CaseInsensitiveMap.CaseInsensitiveString.of((String)""), (Object)new SimpleTableSegmentBinderContext(subqueryProjections, TableSourceType.MIXED_TABLE));
        return result;
    }

    private SelectStatement copy(SelectStatement sqlStatement, WithSegment boundWith, TableSegment boundFrom, ProjectionsSegment boundProjections, WhereSegment boundWhere, CombineSegment boundCombine, LockSegment boundLock, GroupBySegment boundGroupBy, OrderBySegment boundOrderBy, HavingSegment boundHaving) {
        SelectStatement result = new SelectStatement(sqlStatement.getDatabaseType());
        result.setWith(boundWith);
        result.setFrom(boundFrom);
        result.setProjections(boundProjections);
        result.setWhere(boundWhere);
        result.setCombine(boundCombine);
        result.setLock(boundLock);
        result.setGroupBy(boundGroupBy);
        result.setOrderBy(boundOrderBy);
        result.setHaving(boundHaving);
        sqlStatement.getLimit().ifPresent(arg_0 -> ((SelectStatement)result).setLimit(arg_0));
        sqlStatement.getWindow().ifPresent(arg_0 -> ((SelectStatement)result).setWindow(arg_0));
        sqlStatement.getModel().ifPresent(arg_0 -> ((SelectStatement)result).setModel(arg_0));
        sqlStatement.getSubqueryType().ifPresent(arg_0 -> ((SelectStatement)result).setSubqueryType(arg_0));
        SQLStatementCopyUtils.copyAttributes((SQLStatement)sqlStatement, (SQLStatement)result);
        return result;
    }

    @Generated
    public SelectStatementBinder(Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> outerTableBinderContexts) {
        this.outerTableBinderContexts = outerTableBinderContexts;
    }

    private /* synthetic */ HavingSegment lambda$bind$7(SQLStatementBinderContext binderContext, Multimap currentTableBinderContexts, Multimap tableBinderContexts, HavingSegment optional) {
        return HavingSegmentBinder.bind(optional, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)currentTableBinderContexts, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts, this.outerTableBinderContexts);
    }

    private /* synthetic */ OrderBySegment lambda$bind$6(SQLStatementBinderContext binderContext, Multimap currentTableBinderContexts, Multimap tableBinderContexts, OrderBySegment optional) {
        return OrderBySegmentBinder.bind(optional, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)currentTableBinderContexts, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts, this.outerTableBinderContexts);
    }

    private /* synthetic */ GroupBySegment lambda$bind$5(SQLStatementBinderContext binderContext, Multimap currentTableBinderContexts, Multimap tableBinderContexts, GroupBySegment optional) {
        return GroupBySegmentBinder.bind(optional, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)currentTableBinderContexts, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts, this.outerTableBinderContexts);
    }

    private /* synthetic */ LockSegment lambda$bind$4(SQLStatementBinderContext binderContext, Multimap tableBinderContexts, LockSegment optional) {
        return LockSegmentBinder.bind(optional, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts, this.outerTableBinderContexts);
    }

    private /* synthetic */ WhereSegment lambda$bind$2(SQLStatementBinderContext binderContext, Multimap tableBinderContexts, WhereSegment optional) {
        return WhereSegmentBinder.bind(optional, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts, this.outerTableBinderContexts);
    }

    private /* synthetic */ TableSegment lambda$bind$1(SQLStatementBinderContext binderContext, Multimap tableBinderContexts, TableSegment optional) {
        return TableSegmentBinder.bind(optional, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts, this.outerTableBinderContexts);
    }
}

