/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.builder;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.ExecutorJDBCStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.JDBCDriverType;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.builder.JDBCExecutionUnitBuilder;

public final class PreparedStatementExecutionUnitBuilder
implements JDBCExecutionUnitBuilder {
    @Override
    public JDBCExecutionUnit build(ExecutionUnit executionUnit, ExecutorJDBCStatementManager statementManager, Connection connection, int connectionOffset, ConnectionMode connectionMode, StatementOption option, DatabaseType databaseType) throws SQLException {
        PreparedStatement preparedStatement = this.createPreparedStatement(executionUnit, statementManager, connection, connectionOffset, connectionMode, option, databaseType);
        return new JDBCExecutionUnit(executionUnit, connectionMode, preparedStatement);
    }

    private PreparedStatement createPreparedStatement(ExecutionUnit executionUnit, ExecutorJDBCStatementManager statementManager, Connection connection, int connectionOffset, ConnectionMode connectionMode, StatementOption option, DatabaseType databaseType) throws SQLException {
        return (PreparedStatement)statementManager.createStorageResource(executionUnit, connection, connectionOffset, connectionMode, option, databaseType);
    }

    public JDBCDriverType getType() {
        return JDBCDriverType.PREPARED_STATEMENT;
    }
}

