/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.checker.sql.dml;

import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.checker.SupportedSQLChecker;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sharding.exception.syntax.UnsupportedShardingOperationException;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.TableSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.UnsupportedDistributeSQLStatementAttribute;

public final class ShardingTableSupportedChecker
implements SupportedSQLChecker<SQLStatementContext, ShardingRule> {
    public boolean isCheck(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext.getSqlStatement().getAttributes().findAttribute(UnsupportedDistributeSQLStatementAttribute.class).isPresent();
    }

    public void check(ShardingRule rule, ShardingSphereDatabase database, ShardingSphereSchema currentSchema, SQLStatementContext sqlStatementContext) {
        for (SimpleTableSegment each : ((TableSQLStatementAttribute)sqlStatementContext.getSqlStatement().getAttributes().getAttribute(TableSQLStatementAttribute.class)).getTables()) {
            String tableName = each.getTableName().getIdentifier().getValue();
            ShardingSpherePreconditions.checkState((!rule.isShardingTable(tableName) ? 1 : 0) != 0, () -> new UnsupportedShardingOperationException(sqlStatementContext.getSqlStatement().getClass().getSimpleName(), tableName));
        }
    }
}

