/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;

public final class ShardingValueTypeConvertUtils {
    public static Collection<Comparable<?>> convertCollectionType(Collection<Comparable<?>> sourceCollection, Class<?> targetType) {
        LinkedList result = new LinkedList();
        for (Comparable<?> value : sourceCollection) {
            result.add((Comparable)ShardingValueTypeConvertUtils.convertToTargetType(value, targetType));
        }
        return result;
    }

    public static <T> T convertToTargetType(Comparable<?> value, Class<?> targetType) {
        if (null == value) {
            return null;
        }
        if (targetType.isInstance(value)) {
            return (T)value;
        }
        if (Integer.class == targetType) {
            return (T)ShardingValueTypeConvertUtils.convertToInteger(value);
        }
        if (Long.class == targetType) {
            return (T)ShardingValueTypeConvertUtils.convertToLong(value);
        }
        if (Short.class == targetType) {
            return (T)ShardingValueTypeConvertUtils.convertToShort(value);
        }
        if (Byte.class == targetType) {
            return (T)ShardingValueTypeConvertUtils.convertToByte(value);
        }
        if (Double.class == targetType) {
            return (T)ShardingValueTypeConvertUtils.convertToDouble(value);
        }
        if (Float.class == targetType) {
            return (T)ShardingValueTypeConvertUtils.convertToFloat(value);
        }
        if (BigDecimal.class == targetType) {
            return (T)ShardingValueTypeConvertUtils.convertToBigDecimal(value);
        }
        if (BigInteger.class == targetType) {
            return (T)ShardingValueTypeConvertUtils.convertToBigInteger(value);
        }
        if (Boolean.class == targetType) {
            return (T)ShardingValueTypeConvertUtils.convertToBoolean(value);
        }
        if (Character.class == targetType) {
            return (T)ShardingValueTypeConvertUtils.convertToCharacter(value);
        }
        if (String.class == targetType) {
            return (T)value.toString();
        }
        if (java.util.Date.class == targetType) {
            return (T)ShardingValueTypeConvertUtils.convertToDate(value);
        }
        if (Date.class == targetType) {
            return (T)ShardingValueTypeConvertUtils.convertToSqlDate(value);
        }
        if (Time.class == targetType) {
            return (T)ShardingValueTypeConvertUtils.convertToSqlTime(value);
        }
        if (Timestamp.class == targetType) {
            return (T)ShardingValueTypeConvertUtils.convertToTimestamp(value);
        }
        if (LocalDate.class == targetType) {
            return (T)ShardingValueTypeConvertUtils.convertToLocalDate(value);
        }
        if (LocalTime.class == targetType) {
            return (T)ShardingValueTypeConvertUtils.convertToLocalTime(value);
        }
        if (LocalDateTime.class == targetType) {
            return (T)ShardingValueTypeConvertUtils.convertToLocalDateTime(value);
        }
        if (Instant.class == targetType) {
            return (T)ShardingValueTypeConvertUtils.convertToInstant(value);
        }
        if (Year.class == targetType) {
            return (T)ShardingValueTypeConvertUtils.convertToYear(value);
        }
        if (YearMonth.class == targetType) {
            return (T)ShardingValueTypeConvertUtils.convertToYearMonth(value);
        }
        if (MonthDay.class == targetType) {
            return (T)ShardingValueTypeConvertUtils.convertToMonthDay(value);
        }
        if (Duration.class == targetType) {
            return (T)ShardingValueTypeConvertUtils.convertToDuration(value);
        }
        throw new ClassCastException("Unsupported type conversion from " + value.getClass().getName() + " to " + targetType.getName());
    }

    private static Integer convertToInteger(Comparable<?> value) {
        if (value instanceof Number) {
            return ((Number)((Object)value)).intValue();
        }
        return Integer.parseInt(value.toString());
    }

    private static Long convertToLong(Comparable<?> value) {
        if (value instanceof Number) {
            return ((Number)((Object)value)).longValue();
        }
        return Long.parseLong(value.toString());
    }

    private static Short convertToShort(Comparable<?> value) {
        if (value instanceof Number) {
            return ((Number)((Object)value)).shortValue();
        }
        return Short.parseShort(value.toString());
    }

    private static Byte convertToByte(Comparable<?> value) {
        if (value instanceof Number) {
            return ((Number)((Object)value)).byteValue();
        }
        return Byte.parseByte(value.toString());
    }

    private static Double convertToDouble(Comparable<?> value) {
        if (value instanceof Number) {
            return ((Number)((Object)value)).doubleValue();
        }
        return Double.parseDouble(value.toString());
    }

    private static Float convertToFloat(Comparable<?> value) {
        if (value instanceof Number) {
            return Float.valueOf(((Number)((Object)value)).floatValue());
        }
        return Float.valueOf(Float.parseFloat(value.toString()));
    }

    private static BigDecimal convertToBigDecimal(Comparable<?> value) {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Number) {
            return BigDecimal.valueOf(((Number)((Object)value)).doubleValue());
        }
        return new BigDecimal(value.toString());
    }

    private static BigInteger convertToBigInteger(Comparable<?> value) {
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toBigInteger();
        }
        if (value instanceof Number) {
            return BigInteger.valueOf(((Number)((Object)value)).longValue());
        }
        return new BigInteger(value.toString());
    }

    private static Boolean convertToBoolean(Comparable<?> value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)((Object)value)).intValue() != 0;
        }
        String strValue = value.toString().trim();
        if ("true".equalsIgnoreCase(strValue) || "1".equals(strValue)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(strValue) || "0".equals(strValue)) {
            return Boolean.FALSE;
        }
        return Boolean.parseBoolean(strValue);
    }

    private static Character convertToCharacter(Comparable<?> value) {
        if (value instanceof Character) {
            return (Character)value;
        }
        if (value instanceof Number) {
            return Character.valueOf((char)((Number)((Object)value)).intValue());
        }
        String strValue = value.toString();
        return Character.valueOf(strValue.isEmpty() ? (char)'\u0000' : strValue.charAt(0));
    }

    private static java.util.Date convertToDate(Comparable<?> value) {
        if (value instanceof java.util.Date) {
            return (java.util.Date)value;
        }
        if (value instanceof LocalDateTime) {
            return java.util.Date.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant());
        }
        if (value instanceof LocalDate) {
            return java.util.Date.from(((LocalDate)value).atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
        if (value instanceof Instant) {
            return java.util.Date.from((Instant)value);
        }
        if (value instanceof Number) {
            return new java.util.Date(((Number)((Object)value)).longValue());
        }
        return java.util.Date.from(ShardingValueTypeConvertUtils.parseInstant(value.toString()));
    }

    private static Date convertToSqlDate(Comparable<?> value) {
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof java.util.Date) {
            return new Date(((java.util.Date)value).getTime());
        }
        if (value instanceof LocalDate) {
            return Date.valueOf((LocalDate)value);
        }
        if (value instanceof LocalDateTime) {
            return Date.valueOf(((LocalDateTime)value).toLocalDate());
        }
        if (value instanceof Number) {
            return new Date(((Number)((Object)value)).longValue());
        }
        return new Date(ShardingValueTypeConvertUtils.parseInstant(value.toString()).toEpochMilli());
    }

    private static Time convertToSqlTime(Comparable<?> value) {
        if (value instanceof Time) {
            return (Time)value;
        }
        if (value instanceof java.util.Date) {
            return new Time(((java.util.Date)value).getTime());
        }
        if (value instanceof LocalTime) {
            return Time.valueOf((LocalTime)value);
        }
        if (value instanceof LocalDateTime) {
            return Time.valueOf(((LocalDateTime)value).toLocalTime());
        }
        if (value instanceof Number) {
            return new Time(((Number)((Object)value)).longValue());
        }
        return Time.valueOf(ShardingValueTypeConvertUtils.parseLocalTime(value.toString()));
    }

    private static Timestamp convertToTimestamp(Comparable<?> value) {
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        if (value instanceof LocalDateTime) {
            return Timestamp.valueOf((LocalDateTime)value);
        }
        if (value instanceof Instant) {
            return Timestamp.from((Instant)value);
        }
        if (value instanceof Number) {
            return new Timestamp(((Number)((Object)value)).longValue());
        }
        return Timestamp.from(ShardingValueTypeConvertUtils.parseInstant(value.toString()));
    }

    private static LocalDate convertToLocalDate(Comparable<?> value) {
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toLocalDate();
        }
        if (value instanceof Date) {
            return ((Date)value).toLocalDate();
        }
        if (value instanceof java.util.Date) {
            return ((java.util.Date)value).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        if (value instanceof Instant) {
            return ((Instant)value).atZone(ZoneId.systemDefault()).toLocalDate();
        }
        if (value instanceof Number) {
            return Instant.ofEpochMilli(((Number)((Object)value)).longValue()).atZone(ZoneId.systemDefault()).toLocalDate();
        }
        return ShardingValueTypeConvertUtils.parseLocalDate(value.toString());
    }

    private static LocalTime convertToLocalTime(Comparable<?> value) {
        if (value instanceof LocalTime) {
            return (LocalTime)value;
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toLocalTime();
        }
        if (value instanceof Time) {
            return ((Time)value).toLocalTime();
        }
        if (value instanceof java.util.Date) {
            return ((java.util.Date)value).toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
        }
        if (value instanceof Number) {
            return Instant.ofEpochMilli(((Number)((Object)value)).longValue()).atZone(ZoneId.systemDefault()).toLocalTime();
        }
        return LocalTime.parse(value.toString());
    }

    private static LocalDateTime convertToLocalDateTime(Comparable<?> value) {
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        if (value instanceof LocalDate) {
            return ((LocalDate)value).atStartOfDay();
        }
        if (value instanceof java.util.Date) {
            return ((java.util.Date)value).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        if (value instanceof Timestamp) {
            return ((Timestamp)value).toLocalDateTime();
        }
        if (value instanceof Instant) {
            return LocalDateTime.ofInstant((Instant)value, ZoneId.systemDefault());
        }
        if (value instanceof Number) {
            return Instant.ofEpochMilli(((Number)((Object)value)).longValue()).atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        return ShardingValueTypeConvertUtils.parseLocalDateTime(value.toString());
    }

    private static Instant convertToInstant(Comparable<?> value) {
        if (value instanceof Instant) {
            return (Instant)value;
        }
        if (value instanceof java.util.Date) {
            return ((java.util.Date)value).toInstant();
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant();
        }
        if (value instanceof Number) {
            return Instant.ofEpochMilli(((Number)((Object)value)).longValue());
        }
        return ShardingValueTypeConvertUtils.parseInstant(value.toString());
    }

    private static Year convertToYear(Comparable<?> value) {
        if (value instanceof Year) {
            return (Year)value;
        }
        if (value instanceof Number) {
            return Year.of(((Number)((Object)value)).intValue());
        }
        if (value instanceof LocalDate) {
            return Year.of(((LocalDate)value).getYear());
        }
        if (value instanceof LocalDateTime) {
            return Year.of(((LocalDateTime)value).getYear());
        }
        return Year.parse(value.toString());
    }

    private static YearMonth convertToYearMonth(Comparable<?> value) {
        if (value instanceof YearMonth) {
            return (YearMonth)value;
        }
        if (value instanceof LocalDate) {
            return YearMonth.of(((LocalDate)value).getYear(), ((LocalDate)value).getMonth());
        }
        if (value instanceof LocalDateTime) {
            return YearMonth.of(((LocalDateTime)value).getYear(), ((LocalDateTime)value).getMonth());
        }
        return YearMonth.parse(value.toString());
    }

    private static MonthDay convertToMonthDay(Comparable<?> value) {
        if (value instanceof MonthDay) {
            return (MonthDay)value;
        }
        if (value instanceof LocalDate) {
            return MonthDay.of(((LocalDate)value).getMonth(), ((LocalDate)value).getDayOfMonth());
        }
        if (value instanceof LocalDateTime) {
            return MonthDay.of(((LocalDateTime)value).getMonth(), ((LocalDateTime)value).getDayOfMonth());
        }
        return MonthDay.parse(value.toString());
    }

    private static Instant parseInstant(String value) {
        try {
            return Instant.parse(value);
        }
        catch (Exception ignored) {
            return ShardingValueTypeConvertUtils.parseInstantByLocalDateTime(value);
        }
    }

    private static Instant parseInstantByLocalDateTime(String value) {
        try {
            return LocalDateTime.parse(value).atZone(ZoneId.systemDefault()).toInstant();
        }
        catch (Exception ignored) {
            return LocalDate.parse(value).atStartOfDay(ZoneId.systemDefault()).toInstant();
        }
    }

    private static LocalDate parseLocalDate(String value) {
        try {
            return LocalDate.parse(value);
        }
        catch (Exception ignored) {
            return LocalDateTime.parse(value).toLocalDate();
        }
    }

    private static LocalDateTime parseLocalDateTime(String value) {
        try {
            return LocalDateTime.parse(value);
        }
        catch (Exception ignored) {
            return Instant.parse(value).atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
    }

    private static LocalTime parseLocalTime(String value) {
        try {
            return LocalTime.parse(value);
        }
        catch (Exception ignored) {
            return LocalDateTime.parse(value).toLocalTime();
        }
    }

    private static Duration convertToDuration(Comparable<?> value) {
        if (value instanceof Duration) {
            return (Duration)value;
        }
        if (value instanceof Number) {
            return Duration.ofMillis(((Number)((Object)value)).longValue());
        }
        return Duration.parse(value.toString());
    }

    @Generated
    private ShardingValueTypeConvertUtils() {
    }
}

