/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.resource.node;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.exception.UnrecognizedDatabaseURLException;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionProperties;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionPropertiesParser;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeFactory;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNode;

public final class StorageNodeAggregator {
    public static Map<StorageNode, DataSource> aggregateDataSources(Map<String, DataSource> dataSourceMap) {
        return dataSourceMap.entrySet().stream().collect(Collectors.toMap(entry -> new StorageNode((String)entry.getKey()), Map.Entry::getValue, (oldValue, currentValue) -> currentValue, () -> new LinkedHashMap(dataSourceMap.size(), 1.0f)));
    }

    public static Map<StorageNode, DataSourcePoolProperties> aggregateDataSourcePoolProperties(Map<String, DataSourcePoolProperties> storageUnitDataSourcePoolPropsMap, boolean isInstanceConnectionEnabled) {
        LinkedHashMap<StorageNode, DataSourcePoolProperties> result = new LinkedHashMap<StorageNode, DataSourcePoolProperties>(storageUnitDataSourcePoolPropsMap.size(), 1.0f);
        for (Map.Entry<String, DataSourcePoolProperties> entry : storageUnitDataSourcePoolPropsMap.entrySet()) {
            Map standardProps = entry.getValue().getConnectionPropertySynonyms().getStandardProperties();
            String url = standardProps.get("url").toString();
            String username = standardProps.get("username").toString();
            DatabaseType databaseType = DatabaseTypeFactory.get((String)url);
            StorageNode storageNode = StorageNodeAggregator.getStorageNode(entry.getKey(), url, username, databaseType, isInstanceConnectionEnabled);
            result.putIfAbsent(storageNode, entry.getValue());
        }
        return result;
    }

    private static StorageNode getStorageNode(String dataSourceName, String url, String username, DatabaseType databaseType, boolean isInstanceConnectionEnabled) {
        try {
            ConnectionProperties connectionProps = ((ConnectionPropertiesParser)DatabaseTypedSPILoader.getService(ConnectionPropertiesParser.class, (DatabaseType)databaseType)).parse(url, username, null);
            boolean isInstanceConnectionAvailable = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().getConnectionOption().isInstanceConnectionAvailable();
            return isInstanceConnectionEnabled && isInstanceConnectionAvailable ? new StorageNode(connectionProps.getHostname(), connectionProps.getPort(), username) : new StorageNode(dataSourceName);
        }
        catch (UnrecognizedDatabaseURLException ex) {
            return new StorageNode(dataSourceName);
        }
    }

    @Generated
    private StorageNodeAggregator() {
    }
}

