/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.version;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Optional;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import lombok.Generated;

public final class ShardingSphereVersion {
    public static final String VERSION = ShardingSphereVersion.loadVersion();
    public static final boolean IS_SNAPSHOT = VERSION.endsWith("SNAPSHOT");
    public static final String BUILD_BRANCH;
    public static final String BUILD_TIME;
    public static final String BUILD_COMMIT_ID;
    public static final String BUILD_COMMIT_ID_ABBREV;
    public static final String BUILD_COMMIT_MESSAGE_SHORT;
    public static final String BUILD_TAG;
    public static final boolean BUILD_DIRTY;

    public static void main(String[] args) {
        System.out.print(ShardingSphereVersion.getVerboseVersion());
    }

    private static String getVerboseVersion() {
        String result = "";
        result = result + String.format("ShardingSphere-%s%n", VERSION);
        if (IS_SNAPSHOT && !BUILD_COMMIT_ID.isEmpty()) {
            result = result + String.format("Commit ID: %s%s%n", BUILD_DIRTY ? "dirty-" : "", BUILD_COMMIT_ID);
            result = result + String.format("Commit Message: %s%n", BUILD_COMMIT_MESSAGE_SHORT);
            result = result + (BUILD_TAG.isEmpty() ? String.format("Branch: %s%n", BUILD_BRANCH) : String.format("Tag: %s%n", BUILD_TAG));
            result = result + String.format("Build time: %s%n", BUILD_TIME);
        }
        return result;
    }

    private static String loadVersion() {
        Optional<String> versionFromGeneratedPropsFile = ShardingSphereVersion.loadVersionFromGeneratedPropertiesFile();
        if (versionFromGeneratedPropsFile.isPresent()) {
            return versionFromGeneratedPropsFile.get();
        }
        Optional<String> versionFromManifest = ShardingSphereVersion.loadVersionFromManifest();
        return versionFromManifest.orElse("");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<String> loadVersionFromGeneratedPropertiesFile() {
        try (InputStream inputStream = ShardingSphereVersion.class.getResourceAsStream("/shardingsphere-version.properties");){
            if (null == inputStream) {
                Optional<String> optional = Optional.empty();
                return optional;
            }
            Properties props = new Properties();
            props.load(inputStream);
            String version = props.getProperty("version");
            if (Strings.isNullOrEmpty((String)version)) return Optional.empty();
            Optional<String> optional = Optional.of(version);
            return optional;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<String> loadVersionFromManifest() {
        try {
            ClassLoader classLoader = ShardingSphereVersion.class.getClassLoader();
            Enumeration<URL> resources = classLoader.getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                InputStream inputStream = resource.openStream();
                try {
                    String version;
                    String vendor;
                    Manifest manifest = new Manifest(inputStream);
                    Attributes attributes = manifest.getMainAttributes();
                    String title = attributes.getValue("Implementation-Title");
                    if (!ShardingSphereVersion.isShardingSphereManifest(title, vendor = attributes.getValue("Implementation-Vendor")) || Strings.isNullOrEmpty((String)(version = attributes.getValue("Implementation-Version")))) continue;
                    Optional<String> optional = Optional.of(version);
                    return optional;
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            return Optional.empty();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Optional.empty();
    }

    private static boolean isShardingSphereManifest(String title, String vendor) {
        return null != title && title.toLowerCase().contains("shardingsphere") || null != vendor && vendor.toLowerCase().contains("apache");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties loadGitProperties() {
        try (InputStream inputStream = ShardingSphereVersion.class.getResourceAsStream("/current-git-commit.properties");){
            if (null == inputStream) return new Properties();
            Properties props = new Properties();
            props.load(inputStream);
            Properties properties = props;
            return properties;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new Properties();
    }

    @Generated
    private ShardingSphereVersion() {
    }

    static {
        Properties gitProps = ShardingSphereVersion.loadGitProperties();
        BUILD_BRANCH = gitProps.getProperty("git.branch", "");
        BUILD_TIME = gitProps.getProperty("git.build.time", "");
        BUILD_COMMIT_ID = gitProps.getProperty("git.commit.id", "");
        BUILD_COMMIT_ID_ABBREV = gitProps.getProperty("git.commit.id.abbrev", "");
        BUILD_COMMIT_MESSAGE_SHORT = gitProps.getProperty("git.commit.message.short", "");
        BUILD_TAG = gitProps.getProperty("git.tags", "");
        BUILD_DIRTY = Boolean.parseBoolean(gitProps.getProperty("git.dirty", "false"));
    }
}

