/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.postgresql.sqlbuilder.ddl.column;

import java.sql.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.postgresql.sqlbuilder.ddl.PostgreSQLDDLTemplateExecutor;
import org.apache.shardingsphere.data.pipeline.postgresql.sqlbuilder.ddl.column.PostgreSQLColumnType;

public final class PostgreSQLColumnPropertiesAppender {
    private static final Collection<String> TIME_TYPE_NAMES = new HashSet<String>(Arrays.asList("time", "timetz", "time without time zone", "time with time zone", "timestamp", "timestamptz", "timestamp without time zone", "timestamp with time zone"));
    private static final Collection<String> BIT_TYPE_NAMES = new HashSet<String>(Arrays.asList("bit", "bit varying", "varbit"));
    private static final Pattern LENGTH_PRECISION_PATTERN = Pattern.compile("(\\d+),(\\d+)");
    private static final Pattern LENGTH_PATTERN = Pattern.compile("(\\d+)");
    private static final Pattern BRACKETS_PATTERN = Pattern.compile("(\\(\\d+\\))");
    private static final Pattern SIGNED_NUMBER_WITH_GROUPING_PATTERN = Pattern.compile("^([+-])?\\s*[0-9][0-9,\\s]*$");
    private static final Pattern NON_DIGIT_PATTERN = Pattern.compile("[^0-9]");
    private static final String ATT_OPTION_SPLIT = "=";
    private final PostgreSQLDDLTemplateExecutor templateExecutor;

    public PostgreSQLColumnPropertiesAppender(Connection connection, int majorVersion, int minorVersion) {
        this.templateExecutor = new PostgreSQLDDLTemplateExecutor(connection, majorVersion, minorVersion);
    }

    public void append(Map<String, Object> context) {
        Collection<Map<String, Object>> typeAndInheritedColumns = this.getTypeAndInheritedColumns(context);
        Collection<Map<String, Object>> allColumns = this.templateExecutor.executeByTemplate(context, "component/columns/%s/properties.ftl");
        for (Map<String, Object> each : allColumns) {
            for (Map<String, Object> column : typeAndInheritedColumns) {
                if (!each.get("name").equals(column.get("name"))) continue;
                each.put(this.getInheritedFromTableOrType(context), column.get("inheritedfrom"));
            }
        }
        if (!allColumns.isEmpty()) {
            Map<String, Collection<String>> editTypes = this.getEditTypes(allColumns);
            for (Map<String, Object> each : allColumns) {
                this.columnFormatter(each, editTypes.getOrDefault(each.get("atttypid").toString(), new LinkedList()));
            }
        }
        context.put("columns", allColumns);
    }

    private Collection<Map<String, Object>> getTypeAndInheritedColumns(Map<String, Object> context) throws SQLException {
        if (null != context.get("typoid")) {
            return this.getColumnFromType(context);
        }
        if (null == context.get("coll_inherits")) {
            return Collections.emptyList();
        }
        Collection<String> collInherits = this.toCollection((Array)context.get("coll_inherits"));
        context.put("coll_inherits", collInherits);
        return collInherits.isEmpty() ? Collections.emptyList() : this.getColumnFromInherits(collInherits);
    }

    private Collection<Map<String, Object>> getColumnFromType(Map<String, Object> context) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("tid", context.get("typoid"));
        return this.templateExecutor.executeByTemplate(params, "component/table/%s/get_columns_for_table.ftl");
    }

    private Collection<String> toCollection(Array array) throws SQLException {
        return Arrays.stream((String[])array.getArray()).collect(Collectors.toList());
    }

    private Collection<Map<String, Object>> getColumnFromInherits(Collection<String> collInherits) {
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        for (Map<String, Object> each : this.templateExecutor.executeByTemplate(new LinkedHashMap<String, Object>(), "component/table/%s/get_inherits.ftl")) {
            if (!collInherits.contains((String)each.get("inherits"))) continue;
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("tid", each.get("oid"));
            result.addAll(this.templateExecutor.executeByTemplate(params, "table/%s/get_columns_for_table.ftl"));
        }
        return result;
    }

    private String getInheritedFromTableOrType(Map<String, Object> context) {
        String result = "inheritedfrom";
        result = result + (null == context.get("typoid") ? "table" : "type");
        return result;
    }

    private Map<String, Collection<String>> getEditTypes(Collection<Map<String, Object>> allColumns) throws SQLException {
        LinkedHashMap<String, Collection<String>> result = new LinkedHashMap<String, Collection<String>>();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("type_ids", allColumns.stream().map(each -> each.get("atttypid").toString()).collect(Collectors.joining(",")));
        for (Map<String, Object> each2 : this.templateExecutor.executeByTemplate(params, "component/columns/%s/edit_mode_types_multi.ftl")) {
            result.put(each2.get("main_oid").toString(), this.toCollectionAndSort((Array)each2.get("edit_types")));
        }
        return result;
    }

    private Collection<String> toCollectionAndSort(Array editTypes) throws SQLException {
        return Arrays.stream((String[])editTypes.getArray()).sorted(String::compareTo).collect(Collectors.toList());
    }

    private void columnFormatter(Map<String, Object> column, Collection<String> editTypes) throws SQLException {
        this.normalizeSequenceValues(column);
        this.handlePrimaryColumn(column);
        this.fetchLengthPrecision(column);
        this.formatColumnVariables(column);
        this.templateExecutor.formatSecurityLabels(column);
        editTypes.add(column.get("cltype").toString());
        column.put("edit_types", editTypes.stream().sorted().collect(Collectors.toList()));
        column.put("cltype", this.parseTypeName(column.get("cltype").toString()));
    }

    private void normalizeSequenceValues(Map<String, Object> column) {
        this.normalizeSequenceValue(column, "seqincrement");
        this.normalizeSequenceValue(column, "seqstart");
        this.normalizeSequenceValue(column, "seqmin");
        this.normalizeSequenceValue(column, "seqmax");
        this.normalizeSequenceValue(column, "seqcache");
    }

    private void normalizeSequenceValue(Map<String, Object> column, String key) {
        if (!column.containsKey(key)) {
            return;
        }
        Object value = column.get(key);
        if (null == value || value instanceof Number) {
            return;
        }
        String rawValue = value.toString().trim();
        Matcher matcher = SIGNED_NUMBER_WITH_GROUPING_PATTERN.matcher(rawValue);
        if (!matcher.matches()) {
            column.remove(key);
            return;
        }
        String digits = NON_DIGIT_PATTERN.matcher(rawValue).replaceAll("");
        if (digits.isEmpty()) {
            column.remove(key);
            return;
        }
        String sign = null == matcher.group(1) ? "" : matcher.group(1);
        String sanitized = sign + digits;
        try {
            column.put(key, Long.parseLong(sanitized));
        }
        catch (NumberFormatException ignored) {
            column.remove(key);
        }
    }

    private void handlePrimaryColumn(Map<String, Object> column) {
        if (null == column.get("attnum") || null == column.get("indkey")) {
            return;
        }
        if (Arrays.stream(column.get("indkey").toString().split(" ")).collect(Collectors.toList()).contains(column.get("attnum").toString())) {
            column.put("is_pk", true);
            column.put("is_primary_key", true);
        } else {
            column.put("is_pk", false);
            column.put("is_primary_key", false);
        }
    }

    private void fetchLengthPrecision(Map<String, Object> column) {
        String fullType = this.getFullDataType(column);
        if (column.containsKey("elemoid")) {
            this.handleLengthPrecision((Long)column.get("elemoid"), column, fullType);
        }
    }

    private void handleLengthPrecision(Long elemoid, Map<String, Object> column, String fullType) {
        switch (PostgreSQLColumnType.valueOf(elemoid)) {
            case NUMERIC: {
                this.setColumnPrecision(column, fullType);
                break;
            }
            case DATE: 
            case VARCHAR: {
                PostgreSQLColumnPropertiesAppender.setColumnLength(column, fullType);
                break;
            }
        }
    }

    private void setColumnPrecision(Map<String, Object> column, String fullType) {
        Matcher matcher = LENGTH_PRECISION_PATTERN.matcher(fullType);
        if (matcher.find()) {
            column.put("attlen", matcher.group(1));
            column.put("attprecision", matcher.group(2));
        }
    }

    private static void setColumnLength(Map<String, Object> column, String fullType) {
        Matcher matcher = LENGTH_PATTERN.matcher(fullType);
        if (matcher.find()) {
            column.put("attlen", matcher.group(1));
            column.put("attprecision", null);
        }
    }

    private String getFullDataType(Map<String, Object> column) {
        Integer typmod;
        String namespace = (String)column.get("typnspname");
        String typeName = (String)column.get("typname");
        Integer numdims = (Integer)column.get("attndims");
        String schema = null == namespace ? "" : namespace;
        String name = this.checkSchemaInName(typeName, schema);
        if (name.startsWith("_")) {
            if (null == numdims || 0 == numdims) {
                numdims = 1;
            }
            name = name.substring(1);
        }
        if (name.endsWith("[]")) {
            if (null == numdims || 0 == numdims) {
                numdims = 1;
            }
            name = name.substring(0, name.length() - 2);
        }
        if (name.startsWith("\"") && name.endsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        String length = -1 == (typmod = (Integer)column.get("atttypmod")) ? "" : this.checkTypmod(typmod, name);
        return this.getFullTypeValue(name, schema, length, numdims == 1 ? "[]" : "");
    }

    private String checkSchemaInName(String typname, String schema) {
        if (typname.contains(schema + "\".")) {
            return typname.substring(schema.length() + 3);
        }
        if (typname.contains(schema + ".")) {
            return typname.substring(schema.length() + 1);
        }
        return typname;
    }

    private String getFullTypeValue(String name, String schema, String length, String array) {
        if ("char".equals(name) && "pg_catalog".equals(schema)) {
            return "\"char\"" + array;
        }
        if ("time with time zone".equals(name)) {
            return "time" + length + " with time zone" + array;
        }
        if ("time without time zone".equals(name)) {
            return "time" + length + " without time zone" + array;
        }
        if ("timestamp with time zone".equals(name)) {
            return "timestamp" + length + " with time zone" + array;
        }
        if ("timestamp without time zone".equals(name)) {
            return "timestamp" + length + " without time zone" + array;
        }
        return name + length + array;
    }

    private String checkTypmod(Integer typmod, String name) {
        String result = "(";
        if ("numeric".equals(name)) {
            int len = typmod - 4 >> 16;
            int prec = typmod - 4 & 0xFFFF;
            result = result + String.valueOf(len);
            result = result + "," + prec;
        } else if (TIME_TYPE_NAMES.contains(name) || BIT_TYPE_NAMES.contains(name)) {
            int len = typmod;
            result = result + String.valueOf(len);
        } else if ("interval".equals(name)) {
            int len = typmod & 0xFFFF;
            result = result + (len > 6 ? "" : String.valueOf(len));
        } else if ("date".equals(name)) {
            result = "";
        } else {
            int len = typmod - 4;
            result = result + String.valueOf(len);
        }
        if (!result.isEmpty()) {
            result = result + ")";
        }
        return result;
    }

    private void formatColumnVariables(Map<String, Object> column) throws SQLException {
        if (null == column.get("attoptions")) {
            return;
        }
        LinkedList attOptions = new LinkedList();
        Collection columnVariables = Arrays.stream((String[])((Array)column.get("attoptions")).getArray()).collect(Collectors.toList());
        for (String each : columnVariables) {
            LinkedHashMap<String, String> columnVariable = new LinkedHashMap<String, String>();
            columnVariable.put("name", each.substring(0, each.indexOf(ATT_OPTION_SPLIT)));
            columnVariable.put("value", each.substring(each.indexOf(ATT_OPTION_SPLIT) + 1));
            attOptions.add(columnVariable);
        }
        column.put("attoptions", attOptions);
    }

    private String parseTypeName(String name) {
        int idx;
        String result = name;
        boolean isArray = false;
        if (result.endsWith("[]")) {
            isArray = true;
            result = result.substring(0, result.lastIndexOf("[]"));
        }
        if ((idx = result.indexOf(40)) > 0 && result.endsWith(")")) {
            result = result.substring(0, idx);
        } else if (idx > 0 && result.startsWith("time")) {
            Matcher matcher = BRACKETS_PATTERN.matcher(result);
            StringBuffer buffer = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(buffer, "");
            }
            matcher.appendTail(buffer);
            result = buffer.toString();
        } else if (result.startsWith("interval")) {
            result = "interval";
        }
        if (isArray) {
            result = result + "[]";
        }
        return result;
    }
}

