/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.connector;

import com.google.common.base.Strings;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.transaction.DialectTransactionOption;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.database.exception.core.exception.transaction.TableModifyInTransactionException;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorEngine;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.callback.RawSQLExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DatabaseConnectionManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.JDBCDriverType;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.raw.RawExecutionPrepareEngine;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.raw.RawExecutionRuleAttribute;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.session.connection.transaction.TransactionConnectionContext;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseProxyConnector;
import org.apache.shardingsphere.proxy.backend.connector.ProxyDatabaseConnectionManager;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.executor.ProxyJDBCExecutor;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.statement.JDBCBackendStatement;
import org.apache.shardingsphere.proxy.backend.connector.sane.DialectSaneQueryResultEngine;
import org.apache.shardingsphere.proxy.backend.context.BackendExecutorContext;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.session.transaction.TransactionStatus;
import org.apache.shardingsphere.proxy.backend.util.TransactionUtils;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TransactionIsolationLevel;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.CloseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.CursorStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.FetchStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.MoveStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.TruncateStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.InsertStatement;
import org.apache.shardingsphere.sqlfederation.engine.SQLFederationEngine;
import org.apache.shardingsphere.transaction.api.TransactionType;
import org.apache.shardingsphere.transaction.spi.TransactionHook;

public final class ProxySQLExecutor {
    private final JDBCDriverType type;
    private final ProxyDatabaseConnectionManager databaseConnectionManager;
    private final ProxyJDBCExecutor regularExecutor;
    private final RawExecutor rawExecutor;
    private final SQLFederationEngine sqlFederationEngine;
    private final Map<ShardingSphereRule, TransactionHook> transactionHooks = OrderedSPILoader.getServices(TransactionHook.class, (Collection)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getRules());

    public ProxySQLExecutor(JDBCDriverType type, ProxyDatabaseConnectionManager databaseConnectionManager, DatabaseProxyConnector databaseProxyConnector, SQLStatementContext sqlStatementContext) {
        this.type = type;
        this.databaseConnectionManager = databaseConnectionManager;
        ExecutorEngine executorEngine = BackendExecutorContext.getInstance().getExecutorEngine();
        ConnectionContext connectionContext = databaseConnectionManager.getConnectionSession().getConnectionContext();
        JDBCExecutor jdbcExecutor = new JDBCExecutor(executorEngine, connectionContext);
        this.regularExecutor = new ProxyJDBCExecutor(type, databaseConnectionManager.getConnectionSession(), databaseProxyConnector, jdbcExecutor);
        this.rawExecutor = new RawExecutor(executorEngine, connectionContext);
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        String currentDatabaseName = Strings.isNullOrEmpty((String)databaseConnectionManager.getConnectionSession().getCurrentDatabaseName()) ? databaseConnectionManager.getConnectionSession().getUsedDatabaseName() : databaseConnectionManager.getConnectionSession().getCurrentDatabaseName();
        ShardingSphereDatabase currentDatabase = metaDataContexts.getMetaData().getDatabase(currentDatabaseName);
        String currentSchemaName = this.getSchemaName(sqlStatementContext, currentDatabase);
        this.sqlFederationEngine = new SQLFederationEngine(currentDatabaseName, currentSchemaName, metaDataContexts.getMetaData(), metaDataContexts.getStatistics(), jdbcExecutor);
    }

    private String getSchemaName(SQLStatementContext sqlStatementContext, ShardingSphereDatabase database) {
        String defaultSchemaName = new DatabaseTypeRegistry(sqlStatementContext.getSqlStatement().getDatabaseType()).getDefaultSchemaName(database.getName());
        return sqlStatementContext.getTablesContext().getSchemaName().orElse(defaultSchemaName);
    }

    public void checkExecutePrerequisites(SQLStatementContext sqlStatementContext) {
        ShardingSpherePreconditions.checkState((boolean)this.isValidExecutePrerequisites(sqlStatementContext.getSqlStatement()), () -> new TableModifyInTransactionException(this.getTableName(sqlStatementContext.getTablesContext())));
    }

    private boolean isValidExecutePrerequisites(SQLStatement sqlStatement) {
        return !(sqlStatement instanceof DDLStatement) || this.isSupportDDLInTransaction(sqlStatement.getDatabaseType(), (DDLStatement)sqlStatement);
    }

    private boolean isSupportDDLInTransaction(DatabaseType databaseType, DDLStatement sqlStatement) {
        DialectTransactionOption transactionOption = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().getTransactionOption();
        boolean isDDLWithoutMetaDataChanged = this.isDDLWithoutMetaDataChanged(sqlStatement);
        if (this.isInXATransaction()) {
            return transactionOption.isSupportDDLInXATransaction() && (isDDLWithoutMetaDataChanged || transactionOption.isSupportMetaDataRefreshInTransaction());
        }
        if (this.isInLocalTransaction()) {
            return transactionOption.isSupportMetaDataRefreshInTransaction() || isDDLWithoutMetaDataChanged;
        }
        return true;
    }

    private boolean isInXATransaction() {
        TransactionType transactionType = TransactionUtils.getTransactionType(this.databaseConnectionManager.getConnectionSession().getConnectionContext().getTransactionContext());
        TransactionStatus transactionStatus = this.databaseConnectionManager.getConnectionSession().getTransactionStatus();
        return TransactionType.XA == transactionType && transactionStatus.isInTransaction();
    }

    private boolean isInLocalTransaction() {
        return this.databaseConnectionManager.getConnectionSession().getTransactionStatus().isInTransaction();
    }

    private boolean isDDLWithoutMetaDataChanged(DDLStatement sqlStatement) {
        return this.isCursorStatement(sqlStatement) || sqlStatement instanceof TruncateStatement;
    }

    private boolean isCursorStatement(DDLStatement sqlStatement) {
        return sqlStatement instanceof CursorStatement || sqlStatement instanceof CloseStatement || sqlStatement instanceof MoveStatement || sqlStatement instanceof FetchStatement;
    }

    private String getTableName(TablesContext tablesContext) {
        return tablesContext.getSimpleTables().isEmpty() ? "unknown_table" : ((SimpleTableSegment)tablesContext.getSimpleTables().iterator().next()).getTableName().getIdentifier().getValue();
    }

    public List<ExecuteResult> execute(ExecutionContext executionContext) throws SQLException {
        String databaseName = this.databaseConnectionManager.getConnectionSession().getUsedDatabaseName();
        Collection rules = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabase(databaseName).getRuleMetaData().getRules();
        int maxConnectionsSizePerQuery = (Integer)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(executionContext.getSqlStatementContext().getSqlStatement().getDatabaseType()).getDialectDatabaseMetaData();
        boolean isReturnGeneratedKeys = executionContext.getSqlStatementContext().getSqlStatement() instanceof InsertStatement && dialectDatabaseMetaData.getGeneratedKeyOption().isPresent();
        return this.hasRawExecutionRule(rules) ? this.rawExecute(executionContext, rules, maxConnectionsSizePerQuery) : this.useDriverToExecute(executionContext, rules, maxConnectionsSizePerQuery, isReturnGeneratedKeys, SQLExecutorExceptionHandler.isExceptionThrown());
    }

    private boolean hasRawExecutionRule(Collection<ShardingSphereRule> rules) {
        for (ShardingSphereRule each : rules) {
            if (!each.getAttributes().findAttribute(RawExecutionRuleAttribute.class).isPresent()) continue;
            return true;
        }
        return false;
    }

    private List<ExecuteResult> rawExecute(ExecutionContext executionContext, Collection<ShardingSphereRule> rules, int maxConnectionsSizePerQuery) throws SQLException {
        ExecutionGroupContext executionGroupContext;
        RawExecutionPrepareEngine prepareEngine = new RawExecutionPrepareEngine(maxConnectionsSizePerQuery, rules);
        try {
            String databaseName = this.databaseConnectionManager.getConnectionSession().getUsedDatabaseName();
            executionGroupContext = prepareEngine.prepare(databaseName, executionContext, executionContext.getExecutionUnits(), new ExecutionGroupReportContext(this.databaseConnectionManager.getConnectionSession().getProcessId(), databaseName, this.databaseConnectionManager.getConnectionSession().getConnectionContext().getGrantee()));
        }
        catch (SQLException ex) {
            return this.getSaneExecuteResults(executionContext, ex);
        }
        return this.rawExecutor.execute(executionGroupContext, executionContext.getQueryContext(), new RawSQLExecutorCallback());
    }

    private List<ExecuteResult> useDriverToExecute(ExecutionContext executionContext, Collection<ShardingSphereRule> rules, int maxConnectionsSizePerQuery, boolean isReturnGeneratedKeys, boolean isExceptionThrown) throws SQLException {
        ExecutionGroupContext executionGroupContext;
        JDBCBackendStatement statementManager = (JDBCBackendStatement)this.databaseConnectionManager.getConnectionSession().getStatementManager();
        String databaseName = this.databaseConnectionManager.getConnectionSession().getUsedDatabaseName();
        DriverExecutionPrepareEngine prepareEngine = new DriverExecutionPrepareEngine(this.type, maxConnectionsSizePerQuery, (DatabaseConnectionManager)this.databaseConnectionManager, (ExecutorStatementManager)statementManager, (StorageResourceOption)new StatementOption(isReturnGeneratedKeys), rules, ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData());
        try {
            executionGroupContext = prepareEngine.prepare(databaseName, executionContext, executionContext.getExecutionUnits(), new ExecutionGroupReportContext(this.databaseConnectionManager.getConnectionSession().getProcessId(), databaseName, this.databaseConnectionManager.getConnectionSession().getConnectionContext().getGrantee()));
        }
        catch (SQLException ex) {
            return this.getSaneExecuteResults(executionContext, ex);
        }
        this.executeTransactionHooksBeforeExecuteSQL(this.databaseConnectionManager.getConnectionSession());
        return this.regularExecutor.execute(executionContext.getQueryContext(), (ExecutionGroupContext<JDBCExecutionUnit>)executionGroupContext, isReturnGeneratedKeys, isExceptionThrown);
    }

    private void executeTransactionHooksBeforeExecuteSQL(ConnectionSession connectionSession) throws SQLException {
        if (!this.getTransactionContext(connectionSession).isInTransaction()) {
            return;
        }
        for (Map.Entry<ShardingSphereRule, TransactionHook> entry : this.transactionHooks.entrySet()) {
            entry.getValue().beforeExecuteSQL(entry.getKey(), ProxyContext.getInstance().getContextManager().getDatabaseType(), connectionSession.getDatabaseConnectionManager().getCachedConnections().values(), this.getTransactionContext(connectionSession), connectionSession.getIsolationLevel().orElse(TransactionIsolationLevel.READ_COMMITTED));
        }
    }

    private TransactionConnectionContext getTransactionContext(ConnectionSession connectionSession) {
        return connectionSession.getDatabaseConnectionManager().getConnectionSession().getConnectionContext().getTransactionContext();
    }

    private List<ExecuteResult> getSaneExecuteResults(ExecutionContext executionContext, SQLException originalException) throws SQLException {
        DatabaseType databaseType = ProxyContext.getInstance().getContextManager().getDatabase(this.databaseConnectionManager.getConnectionSession().getUsedDatabaseName()).getProtocolType();
        Optional<List> executeResult = DatabaseTypedSPILoader.findService(DialectSaneQueryResultEngine.class, (DatabaseType)databaseType).flatMap(optional -> optional.getSaneQueryResult(executionContext.getSqlStatementContext().getSqlStatement(), originalException));
        return executeResult.map(Collections::singletonList).orElseThrow(() -> originalException);
    }

    @Generated
    public SQLFederationEngine getSqlFederationEngine() {
        return this.sqlFederationEngine;
    }
}

