/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.distsql.statement.DistSQLStatement;
import org.apache.shardingsphere.distsql.statement.type.ral.queryable.QueryableRALStatement;
import org.apache.shardingsphere.distsql.statement.type.rql.RQLStatement;
import org.apache.shardingsphere.distsql.statement.type.rul.RULStatement;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.engine.SQLBindEngine;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.executor.checker.SQLExecutionChecker;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.session.connection.transaction.TransactionConnectionContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.state.ShardingSphereState;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.distsql.DistSQLStatementContext;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.admin.DatabaseAdminProxyBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.handler.data.DatabaseProxyBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.handler.database.DatabaseOperateProxyBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.handler.distsql.DistSQLProxyBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.handler.skip.SkipProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.tcl.TCLProxyBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.state.DialectProxyStateSupportedSQLProvider;
import org.apache.shardingsphere.proxy.backend.state.ProxyClusterStateChecker;
import org.apache.shardingsphere.proxy.backend.state.ProxySQLSupportedJudgeEngine;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.EmptyStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.DCLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.database.CreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.database.DropDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.RenameTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.CommitStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.RollbackStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.TCLStatement;
import org.apache.shardingsphere.transaction.util.AutoCommitUtils;

public final class ProxyBackendHandlerFactory {
    private static final Collection<Class<? extends SQLStatement>> UNSUPPORTED_STANDARD_SQL_STATEMENT_TYPES = Arrays.asList(DCLStatement.class, RenameTableStatement.class);

    public static ProxyBackendHandler newInstance(DatabaseType databaseType, String sql, SQLStatement sqlStatement, ConnectionSession connectionSession, HintValueContext hintValueContext) throws SQLException {
        if (sqlStatement instanceof EmptyStatement) {
            return new SkipProxyBackendHandler(sqlStatement);
        }
        ShardingSphereMetaData metaData = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData();
        DistSQLStatementContext sqlStatementContext = sqlStatement instanceof DistSQLStatement ? new DistSQLStatementContext((DistSQLStatement)sqlStatement) : new SQLBindEngine(metaData, connectionSession.getCurrentDatabaseName(), hintValueContext).bind(sqlStatement);
        QueryContext queryContext = new QueryContext((SQLStatementContext)sqlStatementContext, sql, Collections.emptyList(), hintValueContext, connectionSession.getConnectionContext(), metaData);
        return ProxyBackendHandlerFactory.newInstance(databaseType, queryContext, connectionSession, false);
    }

    public static ProxyBackendHandler newInstance(DatabaseType databaseType, QueryContext queryContext, ConnectionSession connectionSession, boolean preferPreparedStatement) throws SQLException {
        String databaseName;
        connectionSession.setQueryContext(queryContext);
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        ProxyBackendHandlerFactory.checkAllowedSQLStatementWhenTransactionFailed(databaseType, sqlStatement, connectionSession.getConnectionContext().getTransactionContext());
        ProxyBackendHandlerFactory.checkSupportedSQLStatement(databaseType, sqlStatement);
        ProxyBackendHandlerFactory.checkClusterState(databaseType, sqlStatement);
        if (sqlStatement instanceof EmptyStatement) {
            return new SkipProxyBackendHandler(sqlStatement);
        }
        if (sqlStatement instanceof DistSQLStatement) {
            ProxyBackendHandlerFactory.checkSupportedDistSQLStatementInTransaction(sqlStatement, connectionSession);
            return DistSQLProxyBackendHandlerFactory.newInstance((DistSQLStatement)sqlStatement, queryContext, connectionSession);
        }
        ProxyBackendHandlerFactory.handleAutoCommit(sqlStatement, connectionSession);
        if (sqlStatement instanceof TCLStatement) {
            return TCLProxyBackendHandlerFactory.newInstance(queryContext, connectionSession);
        }
        Optional<ProxyBackendHandler> databaseAdminHandler = DatabaseAdminProxyBackendHandlerFactory.newInstance(databaseType, sqlStatementContext, connectionSession, queryContext.getSql(), queryContext.getParameters());
        if (databaseAdminHandler.isPresent()) {
            return databaseAdminHandler.get();
        }
        Optional<ProxyBackendHandler> databaseOperateHandler = ProxyBackendHandlerFactory.findDatabaseOperateProxyBackendHandler(sqlStatement, connectionSession);
        if (databaseOperateHandler.isPresent()) {
            return databaseOperateHandler.get();
        }
        String string = databaseName = sqlStatementContext.getTablesContext().getDatabaseName().isPresent() ? (String)sqlStatementContext.getTablesContext().getDatabaseName().get() : connectionSession.getUsedDatabaseName();
        if (null != databaseName) {
            ProxyBackendHandlerFactory.checkSQLExecution(queryContext, connectionSession.getConnectionContext().getGrantee(), databaseName);
        }
        return DatabaseProxyBackendHandlerFactory.newInstance(queryContext, connectionSession, preferPreparedStatement);
    }

    private static void checkAllowedSQLStatementWhenTransactionFailed(DatabaseType databaseType, SQLStatement sqlStatement, TransactionConnectionContext transactionContext) throws SQLException {
        if (transactionContext.isExceptionOccur() && ((DialectDatabaseMetaData)DatabaseTypedSPILoader.getService(DialectDatabaseMetaData.class, (DatabaseType)databaseType)).getTransactionOption().isAllowCommitAndRollbackOnlyWhenTransactionFailed()) {
            ShardingSpherePreconditions.checkState((sqlStatement instanceof CommitStatement || sqlStatement instanceof RollbackStatement ? 1 : 0) != 0, () -> new SQLFeatureNotSupportedException("Current transaction is aborted, commands ignored until end of transaction block."));
        }
    }

    private static void checkSupportedSQLStatement(DatabaseType databaseType, SQLStatement sqlStatement) {
        ShardingSpherePreconditions.checkState((boolean)ProxyBackendHandlerFactory.isSupportedSQLStatement(databaseType, sqlStatement), () -> new UnsupportedSQLOperationException(String.format("unsupported SQL statement `%s`", sqlStatement.getClass().getSimpleName())));
    }

    private static boolean isSupportedSQLStatement(DatabaseType databaseType, SQLStatement sqlStatement) {
        Collection unsupportedDialectSQLStatementTypes = DatabaseTypedSPILoader.findService(DialectProxyStateSupportedSQLProvider.class, (DatabaseType)databaseType).map(DialectProxyStateSupportedSQLProvider::getUnsupportedSQLStatementTypesOnReadyState).orElse(Collections.emptyList());
        return new ProxySQLSupportedJudgeEngine(Collections.emptyList(), Collections.emptyList(), UNSUPPORTED_STANDARD_SQL_STATEMENT_TYPES, unsupportedDialectSQLStatementTypes).isSupported(sqlStatement);
    }

    private static void checkClusterState(DatabaseType databaseType, SQLStatement sqlStatement) {
        ShardingSphereState currentState = ProxyContext.getInstance().getContextManager().getStateContext().getState();
        TypedSPILoader.findService(ProxyClusterStateChecker.class, (Object)currentState).ifPresent(optional -> optional.check(sqlStatement, databaseType));
    }

    private static void checkSupportedDistSQLStatementInTransaction(SQLStatement sqlStatement, ConnectionSession connectionSession) {
        ShardingSpherePreconditions.checkState((!connectionSession.getTransactionStatus().isInTransaction() || ProxyBackendHandlerFactory.isSupportedDistSQLStatementInTransaction(sqlStatement) ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("Non-query DistSQL is not supported within a transaction"));
    }

    private static boolean isSupportedDistSQLStatementInTransaction(SQLStatement sqlStatement) {
        return sqlStatement instanceof RQLStatement || sqlStatement instanceof QueryableRALStatement || sqlStatement instanceof RULStatement;
    }

    private static void handleAutoCommit(SQLStatement sqlStatement, ConnectionSession connectionSession) {
        if (AutoCommitUtils.isNeedStartTransaction((SQLStatement)sqlStatement)) {
            connectionSession.getDatabaseConnectionManager().handleAutoCommit();
        }
    }

    private static Optional<ProxyBackendHandler> findDatabaseOperateProxyBackendHandler(SQLStatement sqlStatement, ConnectionSession connectionSession) {
        return sqlStatement instanceof CreateDatabaseStatement || sqlStatement instanceof DropDatabaseStatement ? Optional.of(DatabaseOperateProxyBackendHandlerFactory.newInstance(sqlStatement, connectionSession)) : Optional.empty();
    }

    private static void checkSQLExecution(QueryContext queryContext, Grantee grantee, String databaseName) {
        ShardingSphereDatabase database = queryContext.getMetaData().getDatabase(databaseName);
        ShardingSphereServiceLoader.getServiceInstances(SQLExecutionChecker.class).forEach(each -> each.check(grantee, queryContext, database));
    }

    @Generated
    private ProxyBackendHandlerFactory() {
    }
}

