/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable.computenode;

import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorClusterModeRequired;
import org.apache.shardingsphere.distsql.statement.type.ral.updatable.SetComputeNodeStateStatement;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.state.instance.InstanceState;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.persist.facade.ClusterPersistServiceFacade;

@DistSQLExecutorClusterModeRequired
public final class SetComputeNodeStateExecutor
implements DistSQLUpdateExecutor<SetComputeNodeStateStatement> {
    public void executeUpdate(SetComputeNodeStateStatement sqlStatement, ContextManager contextManager) {
        if ("DISABLE".equals(sqlStatement.getState())) {
            this.checkDisablingIsValid(contextManager, sqlStatement.getInstanceId());
        } else {
            this.checkEnablingIsValid(contextManager, sqlStatement.getInstanceId());
        }
        ClusterPersistServiceFacade clusterPersistServiceFacade = (ClusterPersistServiceFacade)contextManager.getPersistServiceFacade().getModeFacade();
        clusterPersistServiceFacade.getComputeNodeService().updateState(sqlStatement.getInstanceId(), "DISABLE".equals(sqlStatement.getState()) ? InstanceState.CIRCUIT_BREAK : InstanceState.OK);
    }

    private void checkEnablingIsValid(ContextManager contextManager, String instanceId) {
        ShardingSpherePreconditions.checkState((boolean)contextManager.getComputeNodeInstanceContext().getClusterInstanceRegistry().find(instanceId).isPresent(), () -> new UnsupportedSQLOperationException(String.format("`%s` does not exist", instanceId)));
    }

    private void checkDisablingIsValid(ContextManager contextManager, String instanceId) {
        ShardingSpherePreconditions.checkState((!contextManager.getComputeNodeInstanceContext().getInstance().getMetaData().getId().equals(instanceId) ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException(String.format("`%s` is the currently in use instance and cannot be disabled", instanceId)));
        ShardingSpherePreconditions.checkState((boolean)contextManager.getComputeNodeInstanceContext().getClusterInstanceRegistry().find(instanceId).isPresent(), () -> new UnsupportedSQLOperationException(String.format("`%s` does not exist", instanceId)));
        ShardingSpherePreconditions.checkState((InstanceState.CIRCUIT_BREAK != ((ComputeNodeInstance)contextManager.getComputeNodeInstanceContext().getClusterInstanceRegistry().find(instanceId).get()).getState().getCurrentState() ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException(String.format("`%s` compute node has been disabled", instanceId)));
    }

    public Class<SetComputeNodeStateStatement> getType() {
        return SetComputeNodeStateStatement.class;
    }
}

