/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.tcl.xa;

import lombok.Generated;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseProxyConnector;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseProxyConnectorFactory;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.tcl.xa.type.XABeginProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.tcl.xa.type.XACommitProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.tcl.xa.type.XAOtherOperationProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.tcl.xa.type.XARecoveryProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.tcl.xa.type.XARollbackProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.xa.XABeginStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.xa.XACommitStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.xa.XARecoveryStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.xa.XARollbackStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.xa.XAStatement;

public final class XATCLProxyBackendHandlerFactory {
    public static ProxyBackendHandler newInstance(QueryContext queryContext, ConnectionSession connectionSession) {
        XAStatement sqlStatement = (XAStatement)queryContext.getSqlStatementContext().getSqlStatement();
        DatabaseProxyConnector databaseProxyConnector = DatabaseProxyConnectorFactory.newInstance(queryContext, connectionSession.getDatabaseConnectionManager(), false);
        if (sqlStatement instanceof XARecoveryStatement) {
            return new XARecoveryProxyBackendHandler(databaseProxyConnector);
        }
        if (sqlStatement instanceof XABeginStatement) {
            return new XABeginProxyBackendHandler(queryContext.getMetaData(), connectionSession, databaseProxyConnector);
        }
        if (sqlStatement instanceof XACommitStatement) {
            return new XACommitProxyBackendHandler(connectionSession, databaseProxyConnector);
        }
        if (sqlStatement instanceof XARollbackStatement) {
            return new XARollbackProxyBackendHandler(connectionSession, databaseProxyConnector);
        }
        return new XAOtherOperationProxyBackendHandler(databaseProxyConnector);
    }

    @Generated
    private XATCLProxyBackendHandlerFactory() {
    }
}

