/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.constant;

import lombok.Generated;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;

public enum FirebirdValueFormat {
    TEXT(0),
    BINARY(1),
    BOOLEAN(2),
    INT(3),
    STRING(4);

    private final int code;

    public static FirebirdValueFormat valueOf(int code) {
        switch (code) {
            case 0: {
                return TEXT;
            }
            case 1: {
                return BINARY;
            }
        }
        throw new UnsupportedSQLOperationException(String.format("Unsupported Firebird format code `%s`", code));
    }

    @Generated
    private FirebirdValueFormat(int code) {
        this.code = code;
    }

    @Generated
    public int getCode() {
        return this.code;
    }
}

